/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.SimpleCreateTrigger;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2035;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2111;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6862;

public class CreateAdvancement {
    static final class_2960 BACKGROUND = Create.asResource("textures/gui/advancements.png");
    static final String LANG = "advancement.create.";
    static final String SECRET_SUFFIX = "\n\u00a77(Hidden Advancement)";
    private class_161.class_162 builder = class_161.class_162.method_707();
    private SimpleCreateTrigger builtinTrigger;
    private CreateAdvancement parent;
    class_161 datagenResult;
    private String id;
    private String title;
    private String description;

    public CreateAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        if (!t.externalTrigger) {
            this.builtinTrigger = AllTriggers.addSimple(id + "_builtin");
            this.builder.method_709("0", (class_184)this.builtinTrigger.instance());
        }
        this.builder.method_20416(t.icon, (class_2561)Components.translatable(this.titleKey()), (class_2561)Components.translatable(this.descriptionKey()).method_27694(s -> s.method_36139(14393875)), (class_2960)(id.equals("root") ? BACKGROUND : null), t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        if (t.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        AllAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return true;
        }
        class_3222 sp = (class_3222)player;
        class_161 advancement = sp.method_5682().method_3851().method_12896(Create.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.method_14236().method_12882(advancement).method_740();
    }

    public void awardTo(class_1657 player) {
        if (!(player instanceof class_3222)) {
            return;
        }
        class_3222 sp = (class_3222)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    void save(Consumer<class_161> t) {
        if (this.parent != null) {
            this.builder.method_701(this.parent.datagenResult);
        }
        this.datagenResult = this.builder.method_694(t, Create.asResource(this.id).toString());
    }

    void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private class_1799 icon;

        Builder() {
        }

        Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        Builder after(CreateAdvancement other) {
            CreateAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        Builder icon(class_1935 item) {
            return this.icon(new class_1799(item));
        }

        Builder icon(class_1799 stack) {
            this.icon = stack;
            return this;
        }

        Builder title(String title) {
            CreateAdvancement.this.title = title;
            return this;
        }

        Builder description(String description) {
            CreateAdvancement.this.description = description;
            return this;
        }

        Builder whenBlockPlaced(class_2248 block) {
            return this.externalTrigger((class_184)class_2111.class_2113.method_9095((class_2248)block));
        }

        Builder whenIconCollected() {
            return this.externalTrigger((class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{this.icon.method_7909()}));
        }

        Builder whenItemCollected(ItemProviderEntry<?> item) {
            return this.whenItemCollected((class_1935)item.asStack().method_7909());
        }

        Builder whenItemCollected(class_1935 itemProvider) {
            return this.externalTrigger((class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{itemProvider}));
        }

        Builder whenItemCollected(class_6862<class_1792> tag) {
            return this.externalTrigger((class_184)class_2066.class_2068.method_8957((class_2073[])new class_2073[]{new class_2073(tag, null, class_2096.class_2100.field_9708, class_2096.class_2100.field_9708, class_2035.field_20687, class_2035.field_20687, null, class_2105.field_9716)}));
        }

        Builder awardedForFree() {
            return this.externalTrigger((class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[0]));
        }

        Builder externalTrigger(class_184 trigger) {
            CreateAdvancement.this.builder.method_709(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    static enum TaskType {
        SILENT(class_189.field_1254, false, false, false),
        NORMAL(class_189.field_1254, true, false, false),
        NOISY(class_189.field_1254, true, true, false),
        EXPERT(class_189.field_1249, true, true, false),
        SECRET(class_189.field_1249, true, true, true);

        private class_189 frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(class_189 frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

