/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class FluidThresholdCondition
extends CargoThresholdCondition {
    private FilterItemStack compareStack = FilterItemStack.empty();

    @Override
    protected class_2561 getUnit() {
        return Components.literal("b");
    }

    @Override
    protected class_1799 getIcon() {
        return this.compareStack.item();
    }

    @Override
    protected boolean test(class_1937 level, Train train, class_2487 context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        long target = this.getThreshold();
        int foundFluid = 0;
        for (Carriage carriage : train.carriages) {
            CombinedTankWrapper fluids = carriage.storage.getFluids();
            Transaction t = TransferUtil.getTransaction();
            try {
                for (StorageView view : TransferUtil.getNonEmpty((Storage)fluids, (TransactionContext)t)) {
                    FluidStack fluidInTank = new FluidStack(view);
                    if (!this.compareStack.test(level, fluidInTank)) continue;
                    foundFluid = (int)((long)foundFluid + fluidInTank.getAmount());
                }
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        this.requestStatusToUpdate((long)foundFluid / 81000L, context);
        return operator.test(foundFluid, target * 81000L);
    }

    @Override
    protected void writeAdditional(class_2487 tag) {
        super.writeAdditional(tag);
        tag.method_10566("Bucket", (class_2520)this.compareStack.serializeNBT());
    }

    @Override
    protected void readAdditional(class_2487 tag) {
        super.readAdditional(tag);
        if (tag.method_10545("Bucket")) {
            this.compareStack = FilterItemStack.of(tag.method_10562("Bucket"));
        }
    }

    @Override
    public boolean tickCompletion(class_1937 level, Train train, class_2487 context) {
        return super.tickCompletion(level, train, context);
    }

    @Environment(value=EnvType.CLIENT)
    private FluidStack loadFluid() {
        return this.compareStack.fluid((class_1937)class_310.method_1551().field_1687);
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.train_holds", Lang.translateDirect("schedule.condition.threshold." + Lang.asId(this.getOperator().name()), new Object[0])), (Object)Lang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]), this.compareStack.isEmpty() ? Lang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.compareStack.isFilterItem() ? Lang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.loadFluid().getDisplayName())).method_27692(class_124.field_1062));
    }

    @Override
    public void setItem(int slot, class_1799 stack) {
        this.compareStack = FilterItemStack.of(stack);
    }

    @Override
    public class_1799 getItem(int slot) {
        return this.compareStack.item();
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("fluid_threshold");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends class_2561>)ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]))).titled(null), "Measure");
    }

    @Override
    public class_5250 getWaitingStatus(class_1937 level, Train train, class_2487 tag) {
        long lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1L) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0L, this.getThreshold() + (long)offset), Lang.translateDirect("schedule.condition.threshold.buckets", new Object[0]));
    }
}

