/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3499;
import net.minecraft.class_3709;

public class ArrivalSoundQueue {
    public int offset;
    int min;
    int max;
    Multimap<Integer, class_2338> sources = Multimaps.newMultimap(new HashMap(), ArrayList::new);

    public ArrivalSoundQueue() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    @Nullable
    public Integer firstTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.min + this.offset);
    }

    @Nullable
    public Integer lastTick() {
        return this.sources.isEmpty() ? null : Integer.valueOf(this.max + this.offset);
    }

    public boolean tick(CarriageContraptionEntity entity, int tick, boolean backwards) {
        if (!this.sources.containsKey((Object)(tick -= this.offset))) {
            return backwards ? tick > this.min : tick < this.max;
        }
        Contraption contraption = entity.getContraption();
        for (class_2338 blockPos : this.sources.get((Object)tick)) {
            ArrivalSoundQueue.play(entity, contraption.getBlocks().get(blockPos));
        }
        return backwards ? tick > this.min : tick < this.max;
    }

    public Pair<Boolean, Integer> getFirstWhistle(CarriageContraptionEntity entity) {
        Integer firstTick = this.firstTick();
        Integer lastTick = this.lastTick();
        if (firstTick == null || lastTick == null || firstTick > lastTick) {
            return null;
        }
        for (int i = firstTick.intValue(); i <= lastTick; ++i) {
            if (!this.sources.containsKey((Object)(i - this.offset))) continue;
            Contraption contraption = entity.getContraption();
            for (class_2338 blockPos : this.sources.get((Object)(i - this.offset))) {
                class_2680 state;
                class_3499.class_3501 info = contraption.getBlocks().get(blockPos);
                if (info == null || !((state = info.field_15596).method_26204() instanceof WhistleBlock) || info.field_15595 == null) continue;
                int pitch = info.field_15595.method_10550("Pitch");
                WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.method_11654(WhistleBlock.SIZE));
                return Pair.of(size == WhistleBlock.WhistleSize.LARGE, (size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch);
            }
        }
        return null;
    }

    public void serialize(class_2487 tagIn) {
        class_2487 tag = new class_2487();
        tag.method_10569("Offset", this.offset);
        tag.method_10566("Sources", (class_2520)NBTHelper.writeCompoundList(this.sources.entries(), e -> {
            class_2487 c = new class_2487();
            c.method_10569("Tick", ((Integer)e.getKey()).intValue());
            c.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_2338)e.getValue())));
            return c;
        }));
        tagIn.method_10566("SoundQueue", (class_2520)tag);
    }

    public void deserialize(class_2487 tagIn) {
        class_2487 tag = tagIn.method_10562("SoundQueue");
        this.offset = tag.method_10550("Offset");
        NBTHelper.iterateCompoundList(tag.method_10554("Sources", 10), c -> this.add(c.method_10550("Tick"), class_2512.method_10691((class_2487)c.method_10562("Pos"))));
    }

    public void add(int offset, class_2338 localPos) {
        this.sources.put((Object)offset, (Object)localPos);
        this.min = Math.min(offset, this.min);
        this.max = Math.max(offset, this.max);
    }

    public static boolean isPlayable(class_2680 state) {
        if (state.method_26204() instanceof class_3709) {
            return true;
        }
        if (state.method_26204() instanceof class_2428) {
            return true;
        }
        return state.method_26204() instanceof WhistleBlock;
    }

    public static void play(CarriageContraptionEntity entity, class_3499.class_3501 info) {
        class_2248 class_22482;
        if (info == null) {
            return;
        }
        class_2680 state = info.field_15596;
        if (state.method_26204() instanceof class_3709) {
            if (AllBlocks.HAUNTED_BELL.has(state)) {
                ArrivalSoundQueue.playSimple(entity, AllSoundEvents.HAUNTED_BELL_USE.getMainEvent(), 1.0f, 1.0f);
            } else {
                ArrivalSoundQueue.playSimple(entity, class_3417.field_17265, 1.0f, 1.0f);
            }
        }
        if ((class_22482 = state.method_26204()) instanceof class_2428) {
            class_2428 nb = (class_2428)class_22482;
            float f = (float)Math.pow(2.0, (double)((Integer)state.method_11654((class_2769)class_2428.field_11324) - 12) / 12.0);
            ArrivalSoundQueue.playSimple(entity, ((class_2766)state.method_11654((class_2769)class_2428.field_11325)).method_11886(), 1.0f, f);
        }
        if (state.method_26204() instanceof WhistleBlock && info.field_15595 != null) {
            int pitch = info.field_15595.method_10550("Pitch");
            WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.method_11654(WhistleBlock.SIZE));
            float f = (float)Math.pow(2.0, (double)((size == WhistleBlock.WhistleSize.SMALL ? 12 : 0) - pitch) / 12.0);
            ArrivalSoundQueue.playSimple(entity, (size == WhistleBlock.WhistleSize.LARGE ? AllSoundEvents.WHISTLE_TRAIN_LOW : AllSoundEvents.WHISTLE_TRAIN).getMainEvent(), 1.0f, f);
        }
    }

    private static void playSimple(CarriageContraptionEntity entity, class_3414 event, float volume, float pitch) {
        entity.field_6002.method_8449(null, (class_1297)entity, event, class_3419.field_15254, 5.0f * volume, pitch);
    }
}

