/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.thresholdSwitch;

import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.content.redstone.FilteredDetectorFilterSlot;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlock;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1936;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class ThresholdSwitchBlockEntity
extends SmartBlockEntity {
    public float onWhenAbove = 0.75f;
    public float offWhenBelow = 0.25f;
    public float currentLevel = -1.0f;
    private boolean redstoneState = false;
    private boolean inverted = false;
    private boolean poweredAfterDelay = false;
    private FilteringBehaviour filtering;
    private InvManipulationBehaviour observedInventory;
    private TankManipulationBehaviour observedTank;
    private VersionedInventoryTrackerBehaviour invVersionTracker;

    public ThresholdSwitchBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.onWhenAbove = compound.method_10583("OnAbove");
        this.offWhenBelow = compound.method_10583("OffBelow");
        this.currentLevel = compound.method_10583("Current");
        this.redstoneState = compound.method_10577("Powered");
        this.inverted = compound.method_10577("Inverted");
        this.poweredAfterDelay = compound.method_10577("PoweredAfterDelay");
        super.read(compound, clientPacket);
    }

    protected void writeCommon(class_2487 compound) {
        compound.method_10548("OnAbove", this.onWhenAbove);
        compound.method_10548("OffBelow", this.offWhenBelow);
        compound.method_10556("Inverted", this.inverted);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        this.writeCommon(compound);
        compound.method_10548("Current", this.currentLevel);
        compound.method_10556("Powered", this.redstoneState);
        compound.method_10556("PoweredAfterDelay", this.poweredAfterDelay);
        super.write(compound, clientPacket);
    }

    @Override
    public void writeSafe(class_2487 compound) {
        this.writeCommon(compound);
        super.writeSafe(compound);
    }

    public float getStockLevel() {
        return this.currentLevel;
    }

    public void updateCurrentLevel() {
        if (Transaction.isOpen()) {
            return;
        }
        boolean changed = false;
        float occupied = 0.0f;
        float totalSpace = 0.0f;
        float prevLevel = this.currentLevel;
        class_2338 target = this.field_11867.method_10093(ThresholdSwitchBlock.getTargetDirection(this.method_11010()));
        class_2586 targetBlockEntity = this.field_11863.method_8321(target);
        if (targetBlockEntity instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable observable = (ThresholdSwitchObservable)targetBlockEntity;
            this.currentLevel = observable.getPercent() / 100.0f;
        } else if (this.observedInventory.hasInventory() || this.observedTank.hasInventory()) {
            long count;
            long space;
            if (this.observedInventory.hasInventory()) {
                Storage inv = this.observedInventory.getInventory();
                if (this.invVersionTracker.stillWaiting(inv)) {
                    occupied = prevLevel;
                    totalSpace = 1.0f;
                } else {
                    this.invVersionTracker.awaitNewVersion(inv);
                    try (Transaction t = TransferUtil.getTransaction();){
                        for (StorageView view : inv.iterable((TransactionContext)t)) {
                            space = view.getCapacity();
                            count = view.getAmount();
                            if (space == 0L) continue;
                            totalSpace += 1.0f;
                            if (!this.filtering.test(((ItemVariant)view.getResource()).toStack())) continue;
                            occupied += (float)count * (1.0f / (float)space);
                        }
                    }
                }
            }
            if (this.observedTank.hasInventory()) {
                try (Transaction t = TransferUtil.getTransaction();){
                    Storage tank = this.observedTank.getInventory();
                    for (StorageView view : tank.iterable((TransactionContext)t)) {
                        space = view.getCapacity();
                        count = view.getAmount();
                        if (space == 0L) continue;
                        totalSpace += 1.0f;
                        if (!this.filtering.test(new FluidStack(view))) continue;
                        occupied += (float)count * (1.0f / (float)space);
                    }
                }
            }
            this.currentLevel = occupied / totalSpace;
            if ((double)this.currentLevel > 0.999) {
                this.currentLevel = 1.0f;
            } else if ((double)this.currentLevel < 0.001) {
                this.currentLevel = 0.0f;
            }
        } else {
            if (this.currentLevel == -1.0f) {
                return;
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.currentLevel = -1.0f;
            this.redstoneState = false;
            this.sendData();
            this.scheduleBlockTick();
            return;
        }
        this.currentLevel = class_3532.method_15363((float)this.currentLevel, (float)0.0f, (float)1.0f);
        changed = this.currentLevel != prevLevel;
        boolean previouslyPowered = this.redstoneState;
        if (this.redstoneState && this.currentLevel <= this.offWhenBelow) {
            this.redstoneState = false;
        } else if (!this.redstoneState && this.currentLevel >= this.onWhenAbove) {
            this.redstoneState = true;
        }
        boolean update = previouslyPowered != this.redstoneState;
        int displayLevel = 0;
        if (this.currentLevel > 0.0f) {
            displayLevel = (int)(1.0f + this.currentLevel * 4.0f);
        }
        this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)ThresholdSwitchBlock.LEVEL, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.scheduleBlockTick();
        }
        if (changed || update) {
            DisplayLinkBlock.notifyGatherers((class_1936)this.field_11863, this.field_11867);
            this.notifyUpdate();
        }
    }

    protected void scheduleBlockTick() {
        class_2248 block = this.method_11010().method_26204();
        if (!this.field_11863.method_8397().method_8677(this.field_11867, (Object)block)) {
            this.field_11863.method_39280(this.field_11867, block, 2, class_1953.field_9314);
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236) {
            return;
        }
        this.updateCurrentLevel();
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new FilteredDetectorFilterSlot(true)).withCallback($ -> {
            this.updateCurrentLevel();
            this.invVersionTracker.reset();
        });
        behaviours.add(this.filtering);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour(this);
        behaviours.add(this.invVersionTracker);
        CapManipulationBehaviourBase.InterfaceProvider towardBlockFacing = (w, p, s) -> new BlockFace(p, DirectedDirectionalBlock.getTargetDirection(s));
        this.observedInventory = (InvManipulationBehaviour)new InvManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedInventory);
        this.observedTank = (TankManipulationBehaviour)new TankManipulationBehaviour(this, towardBlockFacing).bypassSidedness();
        behaviours.add(this.observedTank);
    }

    public float getLevelForDisplay() {
        return this.currentLevel == -1.0f ? 0.0f : this.currentLevel;
    }

    public boolean getState() {
        return this.redstoneState;
    }

    public boolean shouldBePowered() {
        return this.inverted != this.redstoneState;
    }

    public void updatePowerAfterDelay() {
        this.poweredAfterDelay = this.shouldBePowered();
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
    }

    public boolean isPowered() {
        return this.poweredAfterDelay;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        if (inverted == this.inverted) {
            return;
        }
        this.inverted = inverted;
        this.updatePowerAfterDelay();
    }
}

