/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.ValueListDisplaySource;
import com.simibubi.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.TankManipulationBehaviour;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FluidFormatter;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LongAttached;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.FluidUnit;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import org.apache.commons.lang3.mutable.MutableInt;

public class FluidListDisplaySource
extends ValueListDisplaySource {
    @Override
    protected Stream<LongAttached<class_5250>> provideEntries(DisplayLinkContext context, int maxRows) {
        class_2586 sourceBE = context.getSourceBlockEntity();
        if (!(sourceBE instanceof SmartObserverBlockEntity)) {
            return Stream.empty();
        }
        SmartObserverBlockEntity cobe = (SmartObserverBlockEntity)sourceBE;
        TankManipulationBehaviour tankManipulationBehaviour = cobe.getBehaviour(TankManipulationBehaviour.OBSERVE);
        FilteringBehaviour filteringBehaviour = cobe.getBehaviour(FilteringBehaviour.TYPE);
        Storage handler = tankManipulationBehaviour.getInventory();
        if (handler == null) {
            return Stream.empty();
        }
        HashMap<class_3611, Long> fluids = new HashMap<class_3611, Long>();
        HashMap<class_3611, FluidStack> fluidNames = new HashMap<class_3611, FluidStack>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (StorageView view : TransferUtil.getNonEmpty(handler, (TransactionContext)t)) {
                FluidStack stack = new FluidStack(view);
                if (!filteringBehaviour.test(stack)) continue;
                fluids.merge(stack.getFluid(), stack.getAmount(), Long::sum);
                fluidNames.putIfAbsent(stack.getFluid(), stack);
            }
        }
        return fluids.entrySet().stream().sorted(Comparator.comparingDouble(value -> ((Long)value.getValue()).longValue()).reversed()).limit(maxRows).map(entry -> LongAttached.with((Long)entry.getValue(), FluidVariantAttributes.getName((FluidVariant)((FluidStack)fluidNames.get(entry.getKey())).getType()).method_27661()));
    }

    @Override
    protected List<class_5250> createComponentsFromEntry(DisplayLinkContext context, LongAttached<class_5250> entry) {
        long amount = (Long)entry.getFirst();
        class_5250 name = ((class_5250)entry.getSecond()).method_10852((class_2561)WHITESPACE);
        Couple<class_5250> formatted = FluidFormatter.asComponents(amount, this.shortenNumbers(context), this.getUnit(context));
        return List.of((class_5250)formatted.getFirst(), (class_5250)formatted.getSecond(), name);
    }

    @Override
    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayBlockEntity flapDisplay, FlapDisplayLayout layout) {
        Integer max = ((MutableInt)context.flapDisplayContext).getValue();
        boolean shorten = this.shortenNumbers(context);
        FluidUnit fluidUnit = this.getUnit(context);
        int length = FluidFormatter.asString(max.intValue(), shorten, fluidUnit).length();
        String layoutKey = "FluidList_" + length;
        if (layout.isLayout(layoutKey)) {
            return;
        }
        int unitLength = fluidUnit == FluidUnit.DROPLETS ? 8 : 2;
        int maxCharCount = flapDisplay.getMaxCharCount(1);
        int numberLength = Math.min(maxCharCount, Math.max(3, length - unitLength));
        int nameLength = Math.max(maxCharCount - numberLength - unitLength, 0);
        FlapDisplaySection value = new FlapDisplaySection(7.0f * (float)numberLength, "number", false, false);
        FlapDisplaySection unit = new FlapDisplaySection(7.0f * (float)unitLength, "fluid_units", true, true);
        FlapDisplaySection name = new FlapDisplaySection(7.0f * (float)nameLength, "alphabet", false, false);
        layout.configure(layoutKey, List.of(value, unit, name));
    }

    @Override
    protected String getTranslationKey() {
        return "list_fluids";
    }

    @Override
    protected boolean valueFirst() {
        return false;
    }

    protected FluidUnit getUnit(DisplayLinkContext context) {
        int format = context.sourceConfig().method_10550("Format");
        return format == 2 ? FluidUnit.DROPLETS : FluidUnit.MILIBUCKETS;
    }

    @Override
    protected void addFullNumberConfig(ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(0, 75, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.value_list", "shortened", "full_number", "full_number_droplets")).titled(Lang.translateDirect("display_source.value_list.display", new Object[0])), "Format");
    }
}

