/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.sequenced;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.Arrays;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SequencedRecipe<T extends ProcessingRecipe<?>> {
    private T wrapped;

    public SequencedRecipe(T wrapped) {
        this.wrapped = wrapped;
    }

    public IAssemblyRecipe getAsAssemblyRecipe() {
        return (IAssemblyRecipe)this.wrapped;
    }

    public ProcessingRecipe<?> getRecipe() {
        return this.wrapped;
    }

    public JsonObject toJson() {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).method_8119();
        JsonObject json = new JsonObject();
        json.addProperty("type", RegisteredObjects.getKeyOrThrow(serializer).toString());
        serializer.write(json, this.wrapped);
        return json;
    }

    public static SequencedRecipe<?> fromJson(JsonObject json, SequencedAssemblyRecipe parent, int index) {
        class_2960 parentId = parent.method_8114();
        class_1860 recipe = class_1863.method_17720((class_2960)new class_2960(parentId.method_12836(), parentId.method_12832() + "_step_" + index), (JsonObject)json);
        if (recipe instanceof ProcessingRecipe && recipe instanceof IAssemblyRecipe) {
            ProcessingRecipe processingRecipe = (ProcessingRecipe)recipe;
            IAssemblyRecipe assemblyRecipe = (IAssemblyRecipe)recipe;
            if (assemblyRecipe.supportsAssembly()) {
                class_1856 transit = class_1856.method_8101((class_1799[])new class_1799[]{parent.getTransitionalItem()});
                processingRecipe.method_8117().set(0, (Object)(index == 0 ? class_1856.method_8092(ImmutableList.of((Object)transit, (Object)parent.getIngredient()).stream().flatMap(i -> Arrays.stream(i.field_9019))) : transit));
                SequencedRecipe<ProcessingRecipe> sequencedRecipe = new SequencedRecipe<ProcessingRecipe>(processingRecipe);
                return sequencedRecipe;
            }
        }
        throw new JsonParseException("Not a supported recipe type");
    }

    public void writeToBuffer(class_2540 buffer) {
        ProcessingRecipeSerializer serializer = (ProcessingRecipeSerializer)((ProcessingRecipe)this.wrapped).method_8119();
        buffer.method_10812(RegisteredObjects.getKeyOrThrow(serializer));
        buffer.method_10812(((ProcessingRecipe)this.wrapped).method_8114());
        serializer.toNetwork(buffer, this.wrapped);
    }

    public static SequencedRecipe<?> readFromBuffer(class_2540 buffer) {
        class_2960 resourcelocation = buffer.method_10810();
        class_2960 resourcelocation1 = buffer.method_10810();
        class_1865 serializer = (class_1865)class_2378.field_17598.method_10223(resourcelocation);
        if (!(serializer instanceof ProcessingRecipeSerializer)) {
            throw new JsonParseException("Not a supported recipe type");
        }
        ProcessingRecipe recipe = (ProcessingRecipe)serializer.method_8122(resourcelocation1, buffer);
        return new SequencedRecipe<ProcessingRecipe>(recipe);
    }
}

