/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.basin;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.content.processing.basin.BasinBlock;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.LongAttached;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;

public class BasinRenderer
extends SmartBlockEntityRenderer<BasinBlockEntity> {
    public BasinRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    protected void renderSafe(BasinBlockEntity basin, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(basin, partialTicks, ms, buffer, light, overlay);
        float fluidLevel = this.renderFluids(basin, partialTicks, ms, buffer, light, overlay);
        float level = class_3532.method_15363((float)(fluidLevel - 0.3f), (float)0.125f, (float)0.6f);
        ms.method_22903();
        class_2338 pos = basin.method_11016();
        ms.method_22904(0.5, (double)0.2f, 0.5);
        TransformStack.cast((class_4587)ms).rotateY((double)basin.ingredientRotation.getValue(partialTicks));
        Random r = new Random(pos.hashCode());
        class_243 baseVector = new class_243(0.125, (double)level, 0.0);
        Storage<ItemVariant> inv = basin.itemCapability;
        if (inv != null) {
            int itemCount = 0;
            List stacks = TransferUtil.getAllItems(inv);
            itemCount = stacks.size();
            if (itemCount == 1) {
                baseVector = new class_243(0.0, (double)level, 0.0);
            }
            float anglePartition = 360.0f / (float)itemCount;
            for (class_1799 stack : stacks) {
                ms.method_22903();
                if (fluidLevel > 0.0f) {
                    ms.method_22904(0.0, (double)((class_3532.method_15374((float)(AnimationTickHolder.getRenderTime((class_1936)basin.method_10997()) / 12.0f + anglePartition * (float)itemCount)) + 1.5f) * 1.0f / 32.0f), 0.0);
                }
                class_243 itemPosition = VecHelper.rotate(baseVector, anglePartition * (float)itemCount, class_2350.class_2351.field_11052);
                ms.method_22904(itemPosition.field_1352, itemPosition.field_1351, itemPosition.field_1350);
                ((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)(anglePartition * (float)itemCount + 35.0f))).rotateX(65.0);
                for (int i = 0; i <= stack.method_7947() / 8; ++i) {
                    ms.method_22903();
                    class_243 vec = VecHelper.offsetRandomly(class_243.field_1353, r, 0.0625f);
                    ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
                    this.renderItem(ms, buffer, light, overlay, stack);
                    ms.method_22909();
                }
                ms.method_22909();
                --itemCount;
            }
        }
        ms.method_22909();
        class_2680 blockState = basin.method_11010();
        if (!(blockState.method_26204() instanceof BasinBlock)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)BasinBlock.FACING);
        if (direction == class_2350.field_11033) {
            return;
        }
        class_243 directionVec = class_243.method_24954((class_2382)direction.method_10163());
        class_243 outVec = VecHelper.getCenterOf((class_2382)class_2338.field_10980).method_1019(directionVec.method_1021(0.55).method_1023(0.0, 0.5, 0.0));
        boolean outToBasin = basin.method_10997().method_8320(basin.method_11016().method_10093(direction)).method_26204() instanceof BasinBlock;
        for (LongAttached<class_1799> LongAttached2 : basin.visualizedOutputItems) {
            float progress = 1.0f - ((float)((Long)LongAttached2.getFirst()).longValue() - partialTicks) / 10.0f;
            if (!outToBasin && progress > 0.35f) continue;
            ms.method_22903();
            ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((class_4587)ms).translate(outVec)).translate(new class_243(0.0, (double)Math.max(-0.55f, -(progress * progress * 2.0f)), 0.0))).translate(directionVec.method_1021((double)(progress * 0.5f)))).rotateY((double)AngleHelper.horizontalAngle(direction))).rotateX((double)(progress * 180.0f));
            this.renderItem(ms, buffer, light, overlay, LongAttached2.getValue());
            ms.method_22909();
        }
    }

    protected void renderItem(class_4587 ms, class_4597 buffer, int light, int overlay, class_1799 stack) {
        class_310.method_1551().method_1480().method_23178(stack, class_809.class_811.field_4318, light, overlay, ms, buffer, 0);
    }

    protected float renderFluids(BasinBlockEntity basin, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        SmartFluidTankBehaviour inputFluids = basin.getBehaviour(SmartFluidTankBehaviour.INPUT);
        SmartFluidTankBehaviour outputFluids = basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT);
        SmartFluidTankBehaviour[] tanks = new SmartFluidTankBehaviour[]{inputFluids, outputFluids};
        float totalUnits = basin.getTotalFluidUnits(partialTicks);
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        float fluidLevel = class_3532.method_15363((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
        fluidLevel = 1.0f - (1.0f - fluidLevel) * (1.0f - fluidLevel);
        float xMin = 0.125f;
        float xMax = 0.125f;
        float yMin = 0.125f;
        float yMax = 0.125f + 0.75f * fluidLevel;
        float zMin = 0.125f;
        float zMax = 0.875f;
        for (SmartFluidTankBehaviour behaviour : tanks) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                float units;
                FluidStack renderedFluid = tankSegment.getRenderedFluid();
                if (renderedFluid.isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
                float partial = class_3532.method_15363((float)(units / totalUnits), (float)0.0f, (float)1.0f);
                FluidRenderer.renderFluidBox(renderedFluid, xMin, 0.125f, 0.125f, xMax += partial * 12.0f / 16.0f, yMax, 0.875f, buffer, ms, light, false);
                xMin = xMax;
            }
        }
        return yMax;
    }

    public int method_33893() {
        return 16;
    }
}

