/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.google.common.collect.Iterators;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import net.minecraft.class_3902;

public class DepotItemHandler
extends SnapshotParticipant<class_3902>
implements Storage<ItemVariant> {
    private static final int MAIN_SLOT = 0;
    private DepotBehaviour behaviour;

    public DepotItemHandler(DepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (!this.behaviour.getHeldItemStack().method_7960() && !this.behaviour.canMergeItems()) {
            return 0L;
        }
        if (!this.behaviour.isOutputEmpty() && !this.behaviour.canMergeItems()) {
            return 0L;
        }
        int toInsert = Math.min(ItemHelper.truncateLong(maxAmount), resource.getItem().method_7882());
        class_1799 stack = resource.toStack(toInsert);
        if (!this.behaviour.isItemValid(stack)) {
            return 0L;
        }
        class_1799 remainder = this.behaviour.insert(new TransportedItemStack(stack), transaction);
        return stack.method_7947() - remainder.method_7947();
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long extracted = this.behaviour.processingOutputBuffer.extract(resource, maxAmount, transaction);
        if (extracted == maxAmount) {
            return extracted;
        }
        extracted += this.extractFromMain(resource, maxAmount - extracted, transaction);
        return extracted;
    }

    public long extractFromMain(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        TransportedItemStack held = this.behaviour.heldItem;
        if (held == null) {
            return 0L;
        }
        class_1799 stack = held.stack;
        if (!resource.matches(stack)) {
            return 0L;
        }
        int toExtract = Math.min(ItemHelper.truncateLong(maxAmount), Math.min(stack.method_7947(), this.behaviour.maxStackSize.get()));
        stack = stack.method_7972();
        stack.method_7934(toExtract);
        if (stack.method_7960()) {
            stack = class_1799.field_8037;
        }
        this.behaviour.snapshotParticipant.updateSnapshots(transaction);
        this.behaviour.heldItem.stack = stack;
        if (stack.method_7960()) {
            this.behaviour.heldItem = null;
        }
        return toExtract;
    }

    public Iterator<? extends StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)new MainSlotView()), (Iterator)this.behaviour.processingOutputBuffer.iterator(transaction));
    }

    protected class_3902 createSnapshot() {
        return class_3902.field_17274;
    }

    protected void readSnapshot(class_3902 snapshot) {
    }

    protected void onFinalCommit() {
        super.onFinalCommit();
        this.behaviour.blockEntity.notifyUpdate();
    }

    public class MainSlotView
    implements StorageView<ItemVariant> {
        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return DepotItemHandler.this.extractFromMain(resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return this.getResource().isBlank();
        }

        public ItemVariant getResource() {
            return ItemVariant.of((class_1799)this.getStack());
        }

        public long getAmount() {
            class_1799 stack = this.getStack();
            return stack.method_7960() ? 0L : (long)stack.method_7947();
        }

        public long getCapacity() {
            class_1799 stack = this.getStack();
            return stack.method_7960() ? (long)DepotItemHandler.this.behaviour.maxStackSize.get().intValue() : (long)Math.min(stack.method_7914(), DepotItemHandler.this.behaviour.maxStackSize.get());
        }

        public class_1799 getStack() {
            TransportedItemStack held = DepotItemHandler.this.behaviour.heldItem;
            if (held == null || held.stack == null || held.stack.method_7960()) {
                return class_1799.field_8037;
            }
            return held.stack;
        }
    }
}

