/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.chute;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.logistics.chute.ChuteShapes;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AdventureUtil;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public abstract class AbstractChuteBlock
extends class_2248
implements IWrenchable,
IBE<ChuteBlockEntity>,
ReducedDestroyEffects {
    public AbstractChuteBlock(class_4970.class_2251 p_i48440_1_) {
        super(p_i48440_1_);
    }

    public static boolean isChute(class_2680 state) {
        return state.method_26204() instanceof AbstractChuteBlock;
    }

    public static boolean isOpenChute(class_2680 state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.method_26204()).isOpen(state);
    }

    public static boolean isTransparentChute(class_2680 state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.method_26204()).isTransparent(state);
    }

    @Nullable
    public static class_2350 getChuteFacing(class_2680 state) {
        return !AbstractChuteBlock.isChute(state) ? null : ((AbstractChuteBlock)state.method_26204()).getFacing(state);
    }

    public class_2350 getFacing(class_2680 state) {
        return class_2350.field_11033;
    }

    public boolean isOpen(class_2680 state) {
        return true;
    }

    public boolean isTransparent(class_2680 state) {
        return false;
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public void method_9502(class_1922 worldIn, class_1297 entityIn) {
        super.method_9502(worldIn, entityIn);
        if (!(entityIn instanceof class_1542)) {
            return;
        }
        if (entityIn.field_6002.field_9236) {
            return;
        }
        if (!entityIn.method_5805()) {
            return;
        }
        DirectBeltInputBehaviour input = BlockEntityBehaviour.get((class_1922)entityIn.field_6002, new class_2338(entityIn.method_19538().method_1031(0.0, 0.5, 0.0)).method_10074(), DirectBeltInputBehaviour.TYPE);
        if (input == null) {
            return;
        }
        if (!input.canInsertFromSide(class_2350.field_11036)) {
            return;
        }
        class_1542 itemEntity = (class_1542)entityIn;
        class_1799 toInsert = itemEntity.method_6983();
        class_1799 remainder = input.handleInsertion(toInsert, class_2350.field_11036, false);
        if (remainder.method_7960()) {
            itemEntity.method_31472();
        }
        if (remainder.method_7947() < toInsert.method_7947()) {
            itemEntity.method_6979(remainder);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 p_220082_4_, boolean p_220082_5_) {
        this.withBlockEntityDo((class_1922)world, pos, ChuteBlockEntity::onAdded);
        this.updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(class_2680 state, class_1937 world, class_2338 pos) {
        class_2680 stateToUpdate;
        if (!AbstractChuteBlock.isChute(state)) {
            return;
        }
        AbstractChuteBlock block = (AbstractChuteBlock)state.method_26204();
        class_2350 facing = block.getFacing(state);
        class_2338 toUpdate = pos.method_10074();
        if (facing.method_10166().method_10179()) {
            toUpdate = toUpdate.method_10093(facing.method_10153());
        }
        if (AbstractChuteBlock.isChute(stateToUpdate = world.method_8320(toUpdate)) && !world.method_8397().method_8674(toUpdate, (Object)stateToUpdate.method_26204())) {
            world.method_39279(toUpdate, stateToUpdate.method_26204(), 1);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
        IBE.onRemove(state, world, pos, newState);
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
        for (class_2350 direction : Iterate.horizontalDirections) {
            class_2338 toUpdate = pos.method_10084().method_10093(direction);
            class_2680 stateToUpdate = world.method_8320(toUpdate);
            if (!AbstractChuteBlock.isChute(stateToUpdate) || world.method_8397().method_8674(toUpdate, (Object)stateToUpdate.method_26204())) continue;
            world.method_39279(toUpdate, stateToUpdate.method_26204(), 1);
        }
    }

    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, Random pRandom) {
        class_2680 updated = this.updateChuteState(pState, pLevel.method_8320(pPos.method_10084()), (class_1922)pLevel, pPos);
        if (pState != updated) {
            pLevel.method_8501(pPos, updated);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 above, class_1936 world, class_2338 pos, class_2338 p_196271_6_) {
        if (direction != class_2350.field_11036) {
            return state;
        }
        return this.updateChuteState(state, above, (class_1922)world, pos);
    }

    public void method_9612(class_2680 p_220069_1_, class_1937 world, class_2338 pos, class_2248 p_220069_4_, class_2338 neighbourPos, boolean p_220069_6_) {
        if (pos.method_10074().equals((Object)neighbourPos)) {
            this.withBlockEntityDo((class_1922)world, pos, ChuteBlockEntity::blockBelowChanged);
        }
    }

    public abstract class_2680 updateChuteState(class_2680 var1, class_2680 var2, class_1922 var3, class_2338 var4);

    public class_265 method_9530(class_2680 p_220053_1_, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    public class_265 method_9549(class_2680 p_220071_1_, class_1922 p_220071_2_, class_2338 p_220071_3_, class_3726 p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    @Override
    public Class<ChuteBlockEntity> getBlockEntityClass() {
        return ChuteBlockEntity.class;
    }

    public class_1269 method_9534(class_2680 p_225533_1_, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 p_225533_6_) {
        if (AdventureUtil.isAdventure(player)) {
            return class_1269.field_5811;
        }
        if (!player.method_5998(hand).method_7960()) {
            return class_1269.field_5811;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        return this.onBlockEntityUse((class_1922)world, pos, be -> {
            if (be.item.method_7960()) {
                return class_1269.field_5811;
            }
            player.method_31548().method_7398(be.item);
            be.setItem(class_1799.field_8037);
            return class_1269.field_5812;
        });
    }
}

