/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.waterwheel;

import com.jozufozu.flywheel.core.StitchedSprite;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.waterwheel.LargeWaterWheelBlock;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlock;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelModelKey;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.render.BakedModelRenderHelper;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.SuperByteBufferCache;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import net.minecraft.class_5614;
import net.minecraft.class_6880;
import net.minecraft.class_777;

public class WaterWheelRenderer<T extends WaterWheelBlockEntity>
extends KineticBlockEntityRenderer<T> {
    public static final SuperByteBufferCache.Compartment<WaterWheelModelKey> WATER_WHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite OAK_PLANKS_TEMPLATE = new StitchedSprite(new class_2960("block/oak_planks"));
    public static final StitchedSprite OAK_LOG_TEMPLATE = new StitchedSprite(new class_2960("block/oak_log"));
    public static final StitchedSprite OAK_LOG_TOP_TEMPLATE = new StitchedSprite(new class_2960("block/oak_log_top"));
    private static final String[] LOG_SUFFIXES = new String[]{"_log", "_stem"};
    protected final boolean large;

    public WaterWheelRenderer(class_5614.class_5615 context, boolean large) {
        super(context);
        this.large = large;
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> standard(class_5614.class_5615 context) {
        return new WaterWheelRenderer<T>(context, false);
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> large(class_5614.class_5615 context) {
        return new WaterWheelRenderer<T>(context, true);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(T be, class_2680 state) {
        WaterWheelModelKey key = new WaterWheelModelKey(this.large, state, ((WaterWheelBlockEntity)be).material);
        return CreateClient.BUFFER_CACHE.get(WATER_WHEEL, key, () -> {
            class_1087 model = WaterWheelRenderer.generateModel(key);
            class_2680 state1 = key.state();
            class_2350 dir = key.large() ? class_2350.method_10169((class_2350.class_2351)((class_2350.class_2351)state1.method_11654((class_2769)LargeWaterWheelBlock.AXIS)), (class_2350.class_2352)class_2350.class_2352.field_11056) : (class_2350)state1.method_11654((class_2769)WaterWheelBlock.FACING);
            class_4587 transform = CachedBufferer.rotateToFaceVertical(dir).get();
            return BakedModelRenderHelper.standardModelRender(model, class_2246.field_10124.method_9564(), transform);
        });
    }

    public static class_1087 generateModel(WaterWheelModelKey key) {
        boolean extension;
        class_1087 template = key.large() ? ((extension = ((Boolean)key.state().method_11654((class_2769)LargeWaterWheelBlock.EXTENSION)).booleanValue()) ? AllPartialModels.LARGE_WATER_WHEEL_EXTENSION.get() : AllPartialModels.LARGE_WATER_WHEEL.get()) : AllPartialModels.WATER_WHEEL.get();
        return WaterWheelRenderer.generateModel(template, key.material());
    }

    public static class_1087 generateModel(class_1087 template, class_2680 planksBlockState) {
        class_2248 planksBlock = planksBlockState.method_26204();
        class_2960 id = RegisteredObjects.getKeyOrThrow(planksBlock);
        String path = id.method_12832();
        if (path.endsWith("_planks")) {
            String namespace = id.method_12836();
            String wood = path.substring(0, path.length() - 7);
            class_2680 logBlockState = WaterWheelRenderer.getLogBlockState(namespace, wood);
            Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
            map.put(OAK_PLANKS_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(planksBlockState, class_2350.field_11036));
            map.put(OAK_LOG_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11035));
            map.put(OAK_LOG_TOP_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, class_2350.field_11036));
            return BakedModelHelper.generateModel(template, ((Map)map)::get);
        }
        return BakedModelHelper.generateModel(template, sprite -> null);
    }

    private static class_2680 getLogBlockState(String namespace, String wood) {
        for (String suffix : LOG_SUFFIXES) {
            Optional<class_2680> state = class_2378.field_11146.method_40264(class_5321.method_29179((class_5321)class_2378.field_25105, (class_2960)new class_2960(namespace, wood + suffix))).map(class_6880::comp_349).map(class_2248::method_9564);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return class_2246.field_10431.method_9564();
    }

    private static class_1058 getSpriteOnSide(class_2680 state, class_2350 side) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (model == null) {
            return null;
        }
        Random random = new Random(42L);
        List quads = model.method_4707(state, side, random);
        if (!quads.isEmpty()) {
            return ((class_777)quads.get(0)).method_35788();
        }
        random.setSeed(42L);
        quads = model.method_4707(state, null, random);
        if (!quads.isEmpty()) {
            for (class_777 quad : quads) {
                if (quad.method_3358() != side) continue;
                return quad.method_35788();
            }
        }
        return model.method_4711();
    }
}

