/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.steamEngine;

import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class PoweredShaftBlockEntity
extends GeneratingKineticBlockEntity {
    public class_2338 enginePos;
    public float engineEfficiency;
    public int movementDirection = 1;
    public int initialTicks = 3;
    public class_2248 capacityKey;

    public PoweredShaftBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.initialTicks > 0) {
            --this.initialTicks;
        }
    }

    public void update(class_2338 sourcePos, int direction, float efficiency) {
        class_2338 key;
        this.enginePos = key = this.field_11867.method_10059((class_2382)sourcePos);
        float prev = this.engineEfficiency;
        this.engineEfficiency = efficiency;
        int prevDirection = this.movementDirection;
        if (class_3532.method_15347((float)efficiency, (float)prev) && prevDirection == direction) {
            return;
        }
        this.capacityKey = this.field_11863.method_8320(sourcePos).method_26204();
        this.movementDirection = direction;
        this.updateGeneratedRotation();
    }

    public void remove(class_2338 sourcePos) {
        if (!this.isPoweredBy(sourcePos)) {
            return;
        }
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        this.movementDirection = 0;
        this.capacityKey = null;
        this.updateGeneratedRotation();
    }

    public boolean canBePoweredBy(class_2338 globalPos) {
        return this.initialTicks == 0 && (this.enginePos == null || this.isPoweredBy(globalPos));
    }

    public boolean isPoweredBy(class_2338 globalPos) {
        class_2338 key = this.field_11867.method_10059((class_2382)globalPos);
        return key.equals((Object)this.enginePos);
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Direction", this.movementDirection);
        if (this.initialTicks > 0) {
            compound.method_10569("Warmup", this.initialTicks);
        }
        if (this.enginePos != null && this.capacityKey != null) {
            compound.method_10566("EnginePos", (class_2520)class_2512.method_10692((class_2338)this.enginePos));
            compound.method_10548("EnginePower", this.engineEfficiency);
            compound.method_10582("EngineType", RegisteredObjects.getKeyOrThrow(this.capacityKey).toString());
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.movementDirection = compound.method_10550("Direction");
        this.initialTicks = compound.method_10550("Warmup");
        this.enginePos = null;
        this.engineEfficiency = 0.0f;
        if (compound.method_10545("EnginePos")) {
            this.enginePos = class_2512.method_10691((class_2487)compound.method_10562("EnginePos"));
            this.engineEfficiency = compound.method_10583("EnginePower");
            this.capacityKey = (class_2248)class_2378.field_11146.method_10223(new class_2960(compound.method_10558("EngineType")));
        }
    }

    @Override
    public float getGeneratedSpeed() {
        return this.getCombinedCapacity() > 0.0f ? (float)(this.movementDirection * 16 * this.getSpeedModifier()) : 0.0f;
    }

    private float getCombinedCapacity() {
        return this.capacityKey == null ? 0.0f : (float)((double)this.engineEfficiency * BlockStressValues.getCapacity(this.capacityKey));
    }

    private int getSpeedModifier() {
        return (int)(1.0 + (this.engineEfficiency >= 1.0f ? 3.0 : Math.min(2.0, Math.floor(this.engineEfficiency * 4.0f))));
    }

    @Override
    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.getCombinedCapacity() / (float)this.getSpeedModifier();
        return capacity;
    }

    @Override
    public int getRotationAngleOffset(class_2350.class_2351 axis) {
        int combinedCoords = axis.method_10173(this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260());
        return super.getRotationAngleOffset(axis) + (combinedCoords % 2 == 0 ? 180 : 0);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    public boolean addToEngineTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }
}

