/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.press;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.kinetics.crafter.MechanicalCraftingRecipe;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.kinetics.press.PressingRecipe;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3955;

public class MechanicalPressBlockEntity
extends BasinOperatingBlockEntity
implements PressingBehaviour.PressingBehaviourSpecifics {
    private static final Object compressingRecipesKey = new Object();
    public PressingBehaviour pressingBehaviour;
    private int tracksCreated;
    private static final class_1263 pressingInv = new ItemStackHandlerContainer(1);

    public MechanicalPressBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1012(0.0, -1.5, 0.0).method_1012(0.0, 1.0, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.pressingBehaviour = new PressingBehaviour(this);
        behaviours.add(this.pressingBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.PRESS, AllAdvancements.COMPACTING, AllAdvancements.TRACK_CRAFTING);
    }

    public void onItemPressed(class_1799 result) {
        this.award(AllAdvancements.PRESS);
        if (AllTags.AllBlockTags.TRACKS.matches(result)) {
            this.tracksCreated += result.method_7947();
        }
        if (this.tracksCreated >= 1000) {
            this.award(AllAdvancements.TRACK_CRAFTING);
            this.tracksCreated = 0;
        }
    }

    public PressingBehaviour getPressingBehaviour() {
        return this.pressingBehaviour;
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        this.applyBasinRecipe();
        Optional<BasinBlockEntity> basin = this.getBasin();
        if (basin.isPresent()) {
            SmartInventory inputs = basin.get().getInputInventory();
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                class_1799 stackInSlot = inputs.method_5438(slot);
                if (stackInSlot.method_7960()) continue;
                this.pressingBehaviour.particleItems.add(stackInSlot);
            }
        }
        return true;
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        if (this.getBehaviour(AdvancementBehaviour.TYPE).isOwnerPresent()) {
            compound.method_10569("TracksCreated", this.tracksCreated);
        }
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tracksCreated = compound.method_10550("TracksCreated");
    }

    @Override
    public boolean tryProcessInWorld(class_1542 itemEntity, boolean simulate) {
        class_1799 item = itemEntity.method_6983();
        Optional<PressingRecipe> recipe = this.getRecipe(item);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        class_1799 itemCreated = class_1799.field_8037;
        this.pressingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.method_7947() == 1) {
            RecipeApplier.applyRecipeOn(itemEntity, (class_1860)recipe.get());
            itemCreated = itemEntity.method_6983().method_7972();
        } else {
            for (class_1799 result : RecipeApplier.applyRecipeOn(ItemHandlerHelper.copyStackWithSize((class_1799)item, (int)1), (class_1860)recipe.get())) {
                if (itemCreated.method_7960()) {
                    itemCreated = result.method_7972();
                }
                class_1542 created = new class_1542(this.field_11863, itemEntity.method_23317(), itemEntity.method_23318(), itemEntity.method_23321(), result);
                created.method_6988();
                created.method_18799(VecHelper.offsetRandomly(class_243.field_1353, Create.RANDOM, 0.05f));
                this.field_11863.method_8649((class_1297)created);
            }
            item.method_7934(1);
        }
        if (!itemCreated.method_7960()) {
            this.onItemPressed(itemCreated);
        }
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<class_1799> outputList, boolean simulate) {
        Optional<PressingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.pressingBehaviour.particleItems.add(input.stack);
        List<class_1799> outputs = RecipeApplier.applyRecipeOn(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((class_1799)input.stack, (int)1), (class_1860)recipe.get());
        for (class_1799 created : outputs) {
            if (created.method_7960()) continue;
            this.onItemPressed(created);
            break;
        }
        outputList.addAll(outputs);
        return true;
    }

    @Override
    public void onPressingCompleted() {
        if (this.pressingBehaviour.onBasin() && this.matchBasinRecipe(this.currentRecipe) && this.getBasin().filter(BasinBlockEntity::canContinueProcessing).isPresent()) {
            this.startProcessingBasin();
        } else {
            this.basinChecker.scheduleUpdate();
        }
    }

    public Optional<PressingRecipe> getRecipe(class_1799 item) {
        Optional<PressingRecipe> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(this.field_11863, item, AllRecipeTypes.PRESSING.getType(), PressingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        pressingInv.method_5447(0, item);
        return AllRecipeTypes.PRESSING.find(pressingInv, this.field_11863);
    }

    public static <C extends class_1263> boolean canCompress(class_1860<C> recipe) {
        if (!(recipe instanceof class_3955) || !((Boolean)AllConfigs.server().recipes.allowShapedSquareInPress.get()).booleanValue()) {
            return false;
        }
        class_2371 ingredients = recipe.method_8117();
        return (ingredients.size() == 4 || ingredients.size() == 9) && ItemHelper.matchAllIngredients((class_2371<class_1856>)ingredients);
    }

    @Override
    protected <C extends class_1263> boolean matchStaticFilters(class_1860<C> recipe) {
        return recipe instanceof class_3955 && !(recipe instanceof MechanicalCraftingRecipe) && MechanicalPressBlockEntity.canCompress(recipe) && !AllRecipeTypes.shouldIgnoreInAutomation(recipe) || recipe.method_17716() == AllRecipeTypes.COMPACTING.getType();
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean canProcessInBulk() {
        return (Boolean)AllConfigs.server().recipes.bulkPressing.get();
    }

    @Override
    protected Object getRecipeCacheKey() {
        return compressingRecipesKey;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public void startProcessingBasin() {
        if (this.pressingBehaviour.running && this.pressingBehaviour.runningTicks <= 120) {
            return;
        }
        super.startProcessingBasin();
        this.pressingBehaviour.start(PressingBehaviour.Mode.BASIN);
    }

    @Override
    protected void onBasinRemoved() {
        this.pressingBehaviour.particleItems.clear();
        this.pressingBehaviour.running = false;
        this.pressingBehaviour.runningTicks = 0;
        this.sendData();
    }

    @Override
    protected boolean isRunning() {
        return this.pressingBehaviour.running;
    }

    @Override
    protected Optional<CreateAdvancement> getProcessedRecipeTrigger() {
        return Optional.of(AllAdvancements.COMPACTING);
    }
}

