/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.transfer;

import com.simibubi.create.content.fluids.transfer.FluidManipulationBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BBHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3902;
import net.minecraft.class_4706;
import net.minecraft.class_6756;
import net.minecraft.class_6757;
import net.minecraft.class_6862;

public class FluidFillingBehaviour
extends FluidManipulationBehaviour {
    public static final BehaviourType<FluidFillingBehaviour> TYPE = new BehaviourType();
    class_4706<FluidManipulationBehaviour.BlockPosEntry> queue;
    List<FluidManipulationBehaviour.BlockPosEntry> infinityCheckFrontier;
    Set<class_2338> infinityCheckVisited;
    SnapshotParticipant<Data> snapshotParticipant = new SnapshotParticipant<Data>(){

        protected Data createSnapshot() {
            return new Data(new HashSet<class_2338>(FluidFillingBehaviour.this.visited), FluidManipulationBehaviour.copySet(FluidFillingBehaviour.this.queue), FluidFillingBehaviour.this.counterpartActed);
        }

        protected void readSnapshot(Data snapshot) {
            FluidFillingBehaviour.this.visited = snapshot.visited;
            FluidFillingBehaviour.this.queue = snapshot.queue;
            FluidFillingBehaviour.this.counterpartActed = snapshot.counterpartActed;
        }
    };

    @Override
    protected SnapshotParticipant<?> snapshotParticipant() {
        return this.snapshotParticipant;
    }

    public FluidFillingBehaviour(SmartBlockEntity be) {
        super(be);
        this.queue = class_4706.method_34959((p, p2) -> -this.comparePositions((FluidManipulationBehaviour.BlockPosEntry)p, (FluidManipulationBehaviour.BlockPosEntry)p2));
        this.revalidateIn = 1;
        this.infinityCheckFrontier = new ArrayList<FluidManipulationBehaviour.BlockPosEntry>();
        this.infinityCheckVisited = new HashSet<class_2338>();
    }

    @Override
    public void tick() {
        class_3611 fluid;
        super.tick();
        if (!this.infinityCheckFrontier.isEmpty() && this.rootPos != null && (fluid = this.getWorld().method_8316(this.rootPos).method_15772()) != class_3612.field_15906) {
            this.continueValidation(fluid);
        }
        if (this.revalidateIn > 0) {
            --this.revalidateIn;
        }
    }

    protected void continueValidation(class_3611 fluid) {
        try {
            this.search(fluid, this.infinityCheckFrontier, this.infinityCheckVisited, (p, d) -> this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry((class_2338)p, (int)d)), true);
        }
        catch (FluidManipulationBehaviour.ChunkNotLoadedException e) {
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.setLongValidationTimer();
            return;
        }
        int maxBlocks = this.maxBlocks();
        if (this.infinityCheckVisited.size() > maxBlocks && maxBlocks != -1 && !this.fillInfinite()) {
            if (!this.infinite) {
                this.reset(null);
                this.infinite = true;
                this.blockEntity.sendData();
            }
            this.infinityCheckFrontier.clear();
            this.setLongValidationTimer();
            return;
        }
        if (!this.infinityCheckFrontier.isEmpty()) {
            return;
        }
        if (this.infinite) {
            this.reset(null);
            return;
        }
        this.infinityCheckVisited.clear();
    }

    public boolean tryDeposit(final class_3611 fluid, class_2338 root, TransactionContext ctx) {
        if (!Objects.equals(root, this.rootPos)) {
            this.reset(ctx);
            this.rootPos = root;
            FluidManipulationBehaviour.BlockPosEntry e = new FluidManipulationBehaviour.BlockPosEntry(root, 0);
            this.queue.add((Object)e);
            this.affectedArea = class_3341.method_34390((class_2382)this.rootPos, (class_2382)this.rootPos);
            return false;
        }
        if (this.counterpartActed) {
            this.counterpartActed = false;
            this.softReset(root);
            return false;
        }
        if (this.affectedArea == null) {
            this.affectedArea = class_3341.method_34390((class_2382)root, (class_2382)root);
        }
        if (this.revalidateIn == 0) {
            this.visited.clear();
            this.infinityCheckFrontier.clear();
            this.infinityCheckVisited.clear();
            this.infinityCheckFrontier.add(new FluidManipulationBehaviour.BlockPosEntry(root, 0));
            this.setValidationTimer();
            this.softReset(root);
        }
        final class_1937 world = this.getWorld();
        int maxRange = this.maxRange();
        int maxRangeSq = maxRange * maxRange;
        int maxBlocks = this.maxBlocks();
        boolean evaporate = world.method_8597().method_27999() && FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517);
        boolean canPlaceSources = (Boolean)AllConfigs.server().fluids.fluidFillPlaceFluidSourceBlocks.get();
        if (!this.fillInfinite() && this.infinite || evaporate || !canPlaceSources) {
            class_3610 fluidState = world.method_8316(this.rootPos);
            boolean equivalentTo = fluidState.method_15772().method_15780(fluid);
            if (!equivalentTo && !evaporate && canPlaceSources) {
                return false;
            }
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> {
                this.playEffect(world, root, fluid, false);
                if (evaporate) {
                    int i = root.method_10263();
                    int j = root.method_10264();
                    int k = root.method_10260();
                    world.method_8465(null, (double)i, (double)j, (double)k, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.8f);
                } else if (!canPlaceSources) {
                    this.blockEntity.award(AllAdvancements.HOSE_PULLEY);
                }
            });
            return true;
        }
        boolean success = false;
        for (int i = 0; !success && !this.queue.isEmpty() && i < 1024; ++i) {
            SpaceType spaceType;
            FluidManipulationBehaviour.BlockPosEntry entry = (FluidManipulationBehaviour.BlockPosEntry)this.queue.method_23865();
            final class_2338 currentPos = entry.pos();
            if (this.visited.contains(currentPos)) {
                FluidFillingBehaviour.dequeue(this.queue);
                continue;
            }
            this.snapshotParticipant.updateSnapshots(ctx);
            this.visited.add(currentPos);
            if (this.visited.size() >= maxBlocks && maxBlocks != -1) {
                this.infinite = true;
                if (!this.fillInfinite()) {
                    this.visited.clear();
                    this.queue.clear();
                    return false;
                }
            }
            if ((spaceType = this.getAtPos(world, currentPos, fluid)) == SpaceType.BLOCKING) continue;
            if (spaceType == SpaceType.FILLABLE) {
                success = true;
                class_2680 blockState = world.method_8320(currentPos);
                if (!this.blockEntity.isVirtual()) {
                    world.updateSnapshots(ctx);
                }
                new SnapshotParticipant<class_3902>(){

                    protected class_3902 createSnapshot() {
                        return class_3902.field_17274;
                    }

                    protected void readSnapshot(class_3902 snapshot) {
                    }

                    protected void onFinalCommit() {
                        FluidFillingBehaviour.this.playEffect(world, currentPos, fluid, false);
                        class_6756 pendingFluidTicks = world.method_8405();
                        if (pendingFluidTicks instanceof class_6757) {
                            class_6757 serverTickList = (class_6757)pendingFluidTicks;
                            serverTickList.method_39380(new class_3341(currentPos));
                        }
                        FluidFillingBehaviour.this.affectedArea = BBHelper.encapsulate(FluidFillingBehaviour.this.affectedArea, currentPos);
                    }
                }.updateSnapshots(ctx);
                if (blockState.method_28498((class_2769)class_2741.field_12508) && fluid.method_15780((class_3611)class_3612.field_15910)) {
                    if (!this.blockEntity.isVirtual()) {
                        world.method_8652(currentPos, this.updatePostWaterlogging((class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true))), 18);
                    }
                } else {
                    this.replaceBlock(world, currentPos, blockState, ctx);
                    if (!this.blockEntity.isVirtual()) {
                        world.method_8652(currentPos, FluidHelper.convertToStill(fluid).method_15785().method_15759(), 18);
                    }
                }
            }
            this.visited.add(currentPos);
            FluidFillingBehaviour.dequeue(this.queue);
            for (class_2350 side : Iterate.directions) {
                SpaceType nextSpaceType;
                class_2338 offsetPos;
                if (side == class_2350.field_11036 || this.visited.contains(offsetPos = currentPos.method_10093(side)) || offsetPos.method_10262((class_2382)this.rootPos) > (double)maxRangeSq || (nextSpaceType = this.getAtPos(world, offsetPos, fluid)) == SpaceType.BLOCKING) continue;
                this.queue.add((Object)new FluidManipulationBehaviour.BlockPosEntry(offsetPos, entry.distance() + 1));
            }
        }
        if (success) {
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.blockEntity.award(AllAdvancements.HOSE_PULLEY));
        }
        return success;
    }

    protected void softReset(class_2338 root) {
        this.visited.clear();
        this.queue.clear();
        this.queue.add((Object)new FluidManipulationBehaviour.BlockPosEntry(root, 0));
        this.infinite = false;
        this.setValidationTimer();
        this.blockEntity.sendData();
    }

    protected SpaceType getAtPos(class_1937 world, class_2338 pos, class_3611 toFill) {
        class_2680 blockState = world.method_8320(pos);
        class_3610 fluidState = blockState.method_26227();
        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
            return toFill.method_15780((class_3611)class_3612.field_15910) ? (((Boolean)blockState.method_11654((class_2769)class_2741.field_12508)).booleanValue() ? SpaceType.FILLED : SpaceType.FILLABLE) : SpaceType.BLOCKING;
        }
        if (blockState.method_26204() instanceof class_2404) {
            return (Integer)blockState.method_11654((class_2769)class_2404.field_11278) == 0 ? (toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING) : SpaceType.FILLABLE;
        }
        if (fluidState.method_15772() != class_3612.field_15906 && blockState.method_26194((class_1922)this.getWorld(), pos, class_3726.method_16194()).method_1110()) {
            return toFill.method_15780(fluidState.method_15772()) ? SpaceType.FILLED : SpaceType.BLOCKING;
        }
        return this.canBeReplacedByFluid((class_1922)world, pos, blockState) ? SpaceType.FILLABLE : SpaceType.BLOCKING;
    }

    protected void replaceBlock(class_1937 world, class_2338 pos, class_2680 state, TransactionContext ctx) {
        class_2586 blockEntity = state.method_31709() ? world.method_8321(pos) : null;
        TransactionCallback.onSuccess((TransactionContext)ctx, () -> class_2248.method_9610((class_2680)state, (class_1936)world, (class_2338)pos, (class_2586)blockEntity));
    }

    protected boolean canBeReplacedByFluid(class_1922 world, class_2338 pos, class_2680 state) {
        class_2248 block = state.method_26204();
        if (!(block instanceof class_2323) && !state.method_26164(class_3481.field_15500) && block != class_2246.field_9983 && block != class_2246.field_10424 && block != class_2246.field_10422) {
            class_3614 material = state.method_26207();
            if (material != class_3614.field_15919 && material != class_3614.field_15927 && material != class_3614.field_15947 && material != class_3614.field_15926) {
                return !material.method_15801();
            }
            return false;
        }
        return false;
    }

    protected class_2680 updatePostWaterlogging(class_2680 state) {
        if (state.method_28498((class_2769)class_2741.field_12548)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    @Override
    public void reset(@Nullable TransactionContext ctx) {
        super.reset(ctx);
        this.queue.clear();
        this.infinityCheckFrontier.clear();
        this.infinityCheckVisited.clear();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    static enum SpaceType {
        FILLABLE,
        FILLED,
        BLOCKING;

    }

    record Data(Set<class_2338> visited, class_4706<FluidManipulationBehaviour.BlockPosEntry> queue, boolean counterpartActed) {
    }
}

