/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.spout;

import com.simibubi.create.AllItems;
import com.simibubi.create.api.behaviour.BlockSpoutingBehaviour;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.content.fluids.spout.FillingBySpout;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.extensions.BlockEntityExtensions;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class SpoutBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
BlockEntityExtensions,
FluidTransferable,
CustomRenderBoundingBoxBlockEntity {
    public static final int FILLING_TIME = 20;
    protected BeltProcessingBehaviour beltProcessing;
    public int processingTicks = -1;
    public boolean sendSplash;
    public BlockSpoutingBehaviour customProcess;
    SmartFluidTankBehaviour tank;
    private boolean createdSweetRoll;
    private boolean createdHoneyApple;
    private boolean createdChocolateBerries;
    protected static int SPLASH_PARTICLE_COUNT = 20;

    public SpoutBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1012(0.0, -2.0, 0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single(this, 81000L);
        behaviours.add(this.tank);
        this.beltProcessing = new BeltProcessingBehaviour(this).whenItemEnters(this::onItemReceived).whileItemHeld(this::whenItemHeld);
        behaviours.add(this.beltProcessing);
        this.registerAwardables(behaviours, AllAdvancements.SPOUT, AllAdvancements.FOODS);
    }

    protected BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (handler.blockEntity.isVirtual()) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!FillingBySpout.canItemBeFilled(this.field_11863, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (FillingBySpout.getRequiredAmountForItem(this.field_11863, transported.stack, this.getCurrentFluidInTank()) == -1L) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    protected BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.processingTicks != -1 && this.processingTicks != 5) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (!FillingBySpout.canItemBeFilled(this.field_11863, transported.stack)) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.tank.isEmpty()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        FluidStack fluid = this.getCurrentFluidInTank();
        long requiredAmountForItem = FillingBySpout.getRequiredAmountForItem(this.field_11863, transported.stack, fluid.copy());
        if (requiredAmountForItem == -1L) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (requiredAmountForItem > fluid.getAmount()) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.processingTicks == -1) {
            this.processingTicks = 20;
            this.notifyUpdate();
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        class_1799 out = FillingBySpout.fillItem(this.field_11863, requiredAmountForItem, transported.stack, fluid);
        if (!out.method_7960()) {
            ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
            TransportedItemStack held = null;
            TransportedItemStack result = transported.copy();
            result.stack = out;
            if (!transported.stack.method_7960()) {
                held = transported.copy();
            }
            outList.add(result);
            handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, held));
        }
        this.award(AllAdvancements.SPOUT);
        if (this.trackFoods()) {
            this.createdChocolateBerries |= AllItems.CHOCOLATE_BERRIES.isIn(out);
            this.createdHoneyApple |= AllItems.HONEYED_APPLE.isIn(out);
            this.createdSweetRoll |= AllItems.SWEET_ROLL.isIn(out);
            if (this.createdChocolateBerries && this.createdHoneyApple && this.createdSweetRoll) {
                this.award(AllAdvancements.FOODS);
            }
        }
        this.tank.getPrimaryHandler().setFluid(fluid.isEmpty() ? FluidStack.EMPTY : fluid);
        this.sendSplash = true;
        this.notifyUpdate();
        return BeltProcessingBehaviour.ProcessingResult.HOLD;
    }

    private FluidStack getCurrentFluidInTank() {
        return this.tank.getPrimaryHandler().getFluid();
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.method_10569("ProcessingTicks", this.processingTicks);
        if (this.sendSplash && clientPacket) {
            compound.method_10556("Splash", true);
            this.sendSplash = false;
        }
        if (!this.trackFoods()) {
            return;
        }
        if (this.createdChocolateBerries) {
            NBTHelper.putMarker(compound, "ChocolateBerries");
        }
        if (this.createdHoneyApple) {
            NBTHelper.putMarker(compound, "HoneyApple");
        }
        if (this.createdSweetRoll) {
            NBTHelper.putMarker(compound, "SweetRoll");
        }
    }

    private boolean trackFoods() {
        return this.getBehaviour(AdvancementBehaviour.TYPE).isOwnerPresent();
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.processingTicks = compound.method_10550("ProcessingTicks");
        this.createdChocolateBerries = compound.method_10545("ChocolateBerries");
        this.createdHoneyApple = compound.method_10545("HoneyApple");
        this.createdSweetRoll = compound.method_10545("SweetRoll");
        if (!clientPacket) {
            return;
        }
        if (compound.method_10545("Splash")) {
            this.spawnSplash(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    @Nullable
    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        if (face != class_2350.field_11033) {
            return this.tank.getCapability();
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        FluidStack currentFluidInTank = this.getCurrentFluidInTank();
        if (!(this.processingTicks != -1 || !this.isVirtual() && this.field_11863.method_8608() || currentFluidInTank.isEmpty())) {
            BlockSpoutingBehaviour.forEach(behaviour -> {
                if (this.customProcess != null) {
                    return;
                }
                if (behaviour.fillBlock(this.field_11863, this.field_11867.method_10087(2), this, currentFluidInTank, true) > 0L) {
                    this.processingTicks = 20;
                    this.customProcess = behaviour;
                    this.notifyUpdate();
                }
            });
        }
        if (this.processingTicks >= 0) {
            --this.processingTicks;
            if (this.processingTicks == 5 && this.customProcess != null) {
                long fillBlock = this.customProcess.fillBlock(this.field_11863, this.field_11867.method_10087(2), this, currentFluidInTank, false);
                this.customProcess = null;
                if (fillBlock > 0L) {
                    FluidStack newStack = FluidHelper.copyStackWithAmount(currentFluidInTank, currentFluidInTank.getAmount() - fillBlock);
                    if (newStack.isEmpty()) {
                        newStack = FluidStack.EMPTY;
                    }
                    this.tank.getPrimaryHandler().setFluid(newStack);
                    this.sendSplash = true;
                    this.notifyUpdate();
                }
            }
        }
        if (this.processingTicks >= 8 && this.field_11863.field_9236) {
            this.spawnProcessingParticles(this.tank.getPrimaryTank().getRenderedFluid());
        }
    }

    protected void spawnProcessingParticles(FluidStack fluid) {
        if (this.isVirtual()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1023(0.0, 0.5, 0.0);
        class_2394 particle = FluidFX.getFluidParticle(fluid);
        this.field_11863.method_8494(particle, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, (double)-0.1f, 0.0);
    }

    protected void spawnSplash(FluidStack fluid) {
        if (this.isVirtual()) {
            return;
        }
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        vec = vec.method_1023(0.0, 1.6875, 0.0);
        class_2394 particle = FluidFX.getFluidParticle(fluid);
        for (int i = 0; i < SPLASH_PARTICLE_COUNT; ++i) {
            class_243 m = VecHelper.offsetRandomly(class_243.field_1353, this.field_11863.field_9229, 0.125f);
            m = new class_243(m.field_1352, Math.abs(m.field_1351), m.field_1350);
            this.field_11863.method_8494(particle, vec.field_1352, vec.field_1351, vec.field_1350, m.field_1352, m.field_1351, m.field_1350);
        }
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getFluidStorage(null));
    }
}

