/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.potion;

import com.simibubi.create.Create;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.kinetics.mixer.MixingRecipe;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import io.github.fabricators_of_create.porting_lib.brewing.BrewingRecipe;
import io.github.fabricators_of_create.porting_lib.brewing.BrewingRecipeRegistry;
import io.github.fabricators_of_create.porting_lib.brewing.IBrewingRecipe;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.PotionBrewing;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.PotionBrewingAccessor;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2378;

public class PotionMixingRecipes {
    public static final List<class_1792> SUPPORTED_CONTAINERS = List.of(class_1802.field_8574, class_1802.field_8436, class_1802.field_8150);
    public static final List<MixingRecipe> ALL = PotionMixingRecipes.createRecipes();
    public static final Map<class_1792, List<MixingRecipe>> BY_ITEM = PotionMixingRecipes.sortRecipesByItem(ALL);

    private static List<MixingRecipe> createRecipes() {
        ArrayList<MixingRecipe> mixingRecipes = new ArrayList<MixingRecipe>();
        int recipeIndex = 0;
        ArrayList<class_1792> allowedSupportedContainers = new ArrayList<class_1792>();
        ArrayList<class_1799> supportedContainerStacks = new ArrayList<class_1799>();
        for (class_1792 container : SUPPORTED_CONTAINERS) {
            class_1799 stack = new class_1799((class_1935)container);
            supportedContainerStacks.add(stack);
            if (!PotionBrewingAccessor.port_lib$ALLOWED_CONTAINER().test(stack)) continue;
            allowedSupportedContainers.add(container);
        }
        for (class_1792 container : allowedSupportedContainers) {
            PotionFluid.BottleType bottleType = PotionFluidHandler.bottleTypeFromItem(container);
            for (class_1845.class_1846 mix : PotionBrewingAccessor.port_lib$POTION_MIXES()) {
                PotionBrewing.MixAccessor access = (PotionBrewing.MixAccessor)mix;
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion((class_1842)access.port_lib$from(), bottleType, 81000L);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion((class_1842)access.port_lib$to(), bottleType, 81000L);
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, access.port_lib$ingredient(), fromFluid, toFluid));
            }
        }
        for (class_1845.class_1846 mix : PotionBrewingAccessor.port_lib$CONTAINER_MIXES()) {
            class_1792 to;
            PotionBrewing.MixAccessor access = (PotionBrewing.MixAccessor)mix;
            class_1792 from = (class_1792)access.port_lib$from();
            if (!allowedSupportedContainers.contains(from) || !allowedSupportedContainers.contains(to = (class_1792)access.port_lib$to())) continue;
            PotionFluid.BottleType fromBottleType = PotionFluidHandler.bottleTypeFromItem(from);
            PotionFluid.BottleType toBottleType = PotionFluidHandler.bottleTypeFromItem(to);
            class_1856 ingredient = access.port_lib$ingredient();
            for (Map.Entry entry : class_2378.field_11143.method_29722()) {
                class_1842 potion = (class_1842)entry.getValue();
                if (potion == class_1847.field_8984) continue;
                FluidStack fromFluid = PotionFluidHandler.getFluidFromPotion(potion, fromBottleType, 81000L);
                FluidStack toFluid = PotionFluidHandler.getFluidFromPotion(potion, toBottleType, 81000L);
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_vanilla_" + recipeIndex++, ingredient, fromFluid, toFluid));
            }
        }
        recipeIndex = 0;
        for (IBrewingRecipe recipe : BrewingRecipeRegistry.getRecipes()) {
            BrewingRecipe recipeImpl;
            class_1799 output;
            if (!(recipe instanceof BrewingRecipe) || !SUPPORTED_CONTAINERS.contains((output = (recipeImpl = (BrewingRecipe)recipe).getOutput()).method_7909())) continue;
            class_1856 input = recipeImpl.getInput();
            class_1856 ingredient = recipeImpl.getIngredient();
            FluidStack outputFluid = null;
            for (class_1799 stack : supportedContainerStacks) {
                if (!input.method_8093(stack)) continue;
                FluidStack inputFluid = PotionFluidHandler.getFluidFromPotionItem(stack);
                if (outputFluid == null) {
                    outputFluid = PotionFluidHandler.getFluidFromPotionItem(output);
                }
                mixingRecipes.add(PotionMixingRecipes.createRecipe("potion_mixing_modded_" + recipeIndex++, ingredient, inputFluid, outputFluid));
            }
        }
        return mixingRecipes;
    }

    private static MixingRecipe createRecipe(String id, class_1856 ingredient, FluidStack fromFluid, FluidStack toFluid) {
        return new ProcessingRecipeBuilder<MixingRecipe>(MixingRecipe::new, Create.asResource(id)).require(ingredient).require(FluidIngredient.fromFluidStack(fromFluid)).output(toFluid).requiresHeat(HeatCondition.HEATED).build();
    }

    private static Map<class_1792, List<MixingRecipe>> sortRecipesByItem(List<MixingRecipe> all) {
        HashMap<class_1792, List<MixingRecipe>> byItem = new HashMap<class_1792, List<MixingRecipe>>();
        HashSet<class_1792> processedItems = new HashSet<class_1792>();
        for (MixingRecipe recipe : all) {
            for (class_1856 ingredient : recipe.method_8117()) {
                for (class_1799 itemStack : ingredient.method_8105()) {
                    class_1792 item = itemStack.method_7909();
                    if (!processedItems.add(item)) continue;
                    byItem.computeIfAbsent(item, i -> new ArrayList()).add(recipe);
                }
            }
            processedItems.clear();
        }
        return byItem;
    }
}

