/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ToolboxInventory
extends ItemStackHandler {
    public static final int STACKS_PER_COMPARTMENT = 4;
    List<class_1799> filters;
    boolean settling;
    private ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(ToolboxBlockEntity be) {
        super(32);
        this.blockEntity = be;
        this.limitedMode = false;
        this.filters = new ArrayList<class_1799>();
        this.settling = false;
        for (int i = 0; i < 8; ++i) {
            this.filters.add(class_1799.field_8037);
        }
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public void settle(int compartment) {
        int i;
        int totalCount = 0;
        boolean valid = true;
        boolean shouldBeEmpty = false;
        class_1799 sample = class_1799.field_8037;
        for (i = 0; i < 4; ++i) {
            class_1799 stackInSlot = this.getStackInSlot(compartment * 4 + i);
            totalCount += stackInSlot.method_7947();
            if (!shouldBeEmpty) {
                shouldBeEmpty = stackInSlot.method_7960() || stackInSlot.method_7947() != stackInSlot.method_7914();
                continue;
            }
            if (stackInSlot.method_7960()) continue;
            valid = false;
            sample = stackInSlot;
        }
        if (valid) {
            return;
        }
        this.settling = true;
        if (!sample.method_7946()) {
            block1: for (i = 0; i < 4; ++i) {
                if (!this.getStackInSlot(compartment * 4 + i).method_7960()) continue;
                for (int j = i + 1; j < 4; ++j) {
                    class_1799 stackInSlot = this.getStackInSlot(compartment * 4 + j);
                    if (stackInSlot.method_7960()) continue;
                    this.setStackInSlot(compartment * 4 + i, stackInSlot);
                    this.setStackInSlot(compartment * 4 + j, class_1799.field_8037);
                    continue block1;
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                class_1799 copy = totalCount <= 0 ? class_1799.field_8037 : ItemHandlerHelper.copyStackWithSize((class_1799)sample, (int)Math.min(totalCount, sample.method_7914()));
                this.setStackInSlot(compartment * 4 + i, copy);
                totalCount -= copy.method_7947();
            }
        }
        this.settling = false;
        this.blockEntity.sendData();
    }

    public boolean isItemValid(int slot, ItemVariant var) {
        class_1799 stack = var.toStack();
        if (!stack.method_7909().method_31568()) {
            return false;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return false;
        }
        int compartment = slot / 4;
        class_1799 filter = this.filters.get(compartment);
        if (this.limitedMode && filter.method_7960()) {
            return false;
        }
        if (filter.method_7960() || ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return super.isItemValid(slot, var);
        }
        return false;
    }

    protected ItemStackHandlerSnapshot createSnapshot() {
        ItemStackHandlerSnapshot snapshot = super.createSnapshot();
        return new ToolboxSnapshotData(snapshot, new ArrayList<class_1799>(this.filters));
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        super.setStackInSlot(slot, stack);
        this.updateCompartmentFilters(slot, stack, null);
    }

    protected void contentsChangedInternal(int slot, class_1799 newStack, TransactionContext ctx) {
        super.contentsChangedInternal(slot, newStack, ctx);
        this.updateCompartmentFilters(slot, newStack, ctx);
    }

    private void updateCompartmentFilters(int slot, class_1799 stack, @Nullable TransactionContext ctx) {
        int compartment = slot / 4;
        if (!stack.method_7960() && this.filters.get(compartment).method_7960()) {
            this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)1));
            if (ctx != null) {
                TransactionCallback.onSuccess((TransactionContext)ctx, this.blockEntity::sendData);
            } else {
                this.blockEntity.sendData();
            }
        }
    }

    public class_2487 serializeNBT() {
        class_2487 compound = super.serializeNBT();
        compound.method_10566("Compartments", (class_2520)NBTHelper.writeItemList(this.filters));
        return compound;
    }

    protected void onContentsChanged(int slot) {
        if (!this.settling && !this.blockEntity.method_10997().field_9236) {
            this.settle(slot / 4);
        }
        this.blockEntity.sendData();
        this.blockEntity.method_5431();
        super.onContentsChanged(slot);
    }

    public void deserializeNBT(class_2487 nbt) {
        this.filters = NBTHelper.readItemList(nbt.method_10554("Compartments", 10));
        if (this.filters.size() != 8) {
            this.filters.clear();
            for (int i = 0; i < 8; ++i) {
                this.filters.add(class_1799.field_8037);
            }
        }
        super.deserializeNBT(nbt);
    }

    public class_1799 distributeToCompartment(@Nonnull class_1799 stack, int compartment, TransactionContext ctx) {
        if (stack.method_7960()) {
            return stack;
        }
        if (this.filters.get(compartment).method_7960()) {
            return stack;
        }
        this.updateSnapshots(ctx);
        int toInsert = stack.method_7947();
        int inserted = 0;
        for (int i = 3; i >= 0; --i) {
            int room;
            int slot = compartment * 4 + i;
            class_1799 held = this.getStackInSlot(slot);
            boolean holdingEmpty = held.method_7960();
            if (!holdingEmpty && !ItemHandlerHelper.canItemStacksStack((class_1799)stack, (class_1799)held)) continue;
            int n = room = holdingEmpty ? stack.method_7914() : held.method_7909().method_7882() - held.method_7947();
            if (room > 0) {
                int insert = Math.min(toInsert, room);
                toInsert -= insert;
                inserted += insert;
                held = holdingEmpty ? stack.method_7972() : ItemHandlerHelper.copyStackWithSize((class_1799)held, (int)(held.method_7947() + insert));
                this.contentsChangedInternal(slot, held, ctx);
            }
            if (toInsert != 0) continue;
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        remainder.method_7939(toInsert - inserted);
        return remainder;
    }

    public class_1799 takeFromCompartment(int amount, int compartment, TransactionContext ctx) {
        if (amount == 0) {
            return class_1799.field_8037;
        }
        int remaining = amount;
        class_1799 lastValid = class_1799.field_8037;
        this.updateSnapshots(ctx);
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            class_1799 held = this.getStackInSlot(slot);
            int canExtract = Math.min(remaining, held.method_7947());
            class_1799 extracted = held.method_7972();
            extracted.method_7939(canExtract);
            held = held.method_7972();
            held.method_7934(canExtract);
            this.contentsChangedInternal(slot, held, ctx);
            remaining -= extracted.method_7947();
            if (!extracted.method_7960()) {
                lastValid = extracted;
            }
            if (remaining != 0) continue;
            return ItemHandlerHelper.copyStackWithSize((class_1799)lastValid, (int)amount);
        }
        if (remaining == amount) {
            return class_1799.field_8037;
        }
        return ItemHandlerHelper.copyStackWithSize((class_1799)lastValid, (int)(amount - remaining));
    }

    public static class_1799 cleanItemNBT(class_1799 stack) {
        if (AllItems.BELT_CONNECTOR.isIn(stack)) {
            stack.method_7983("FirstPulley");
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(class_1799 stack1, class_1799 stack2) {
        if (!stack1.method_7946() && !stack2.method_7946() && stack1.method_7963() && stack2.method_7963()) {
            return stack1.method_7909() == stack2.method_7909();
        }
        if (AllItems.BELT_CONNECTOR.isIn(stack1) && AllItems.BELT_CONNECTOR.isIn(stack2)) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((class_1799)stack1, (class_1799)stack2);
    }

    public static class ToolboxSnapshotData
    implements ItemStackHandlerSnapshot {
        public final ItemStackHandlerSnapshot base;
        public final List<class_1799> filters;

        public ToolboxSnapshotData(ItemStackHandlerSnapshot base, List<class_1799> filters) {
            this.base = base;
            this.filters = filters;
        }

        public void apply(ItemStackHandler handler) {
            this.base.apply(handler);
            ((ToolboxInventory)handler).filters = this.filters;
        }
    }
}

