/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.toolbox.RadialToolboxMenu;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.content.equipment.toolbox.ToolboxEquipPacket;
import com.simibubi.create.content.equipment.toolbox.ToolboxHandler;
import com.simibubi.create.content.equipment.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Comparator;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4587;
import net.minecraft.class_746;

public class ToolboxHandlerClient {
    static int COOLDOWN = 0;

    public static void clientTick() {
        if (COOLDOWN > 0 && !AllKeys.TOOLBELT.isPressed()) {
            --COOLDOWN;
        }
    }

    public static boolean onPickItem() {
        class_1297 entity;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return false;
        }
        class_1937 level = player.field_6002;
        class_239 hitResult = mc.field_1765;
        if (hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return false;
        }
        if (player.method_7337()) {
            return false;
        }
        class_1799 result = class_1799.field_8037;
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((class_1936)player.field_6002, (class_1657)player, 8);
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hitResult).method_17777();
            class_2680 state = level.method_8320(pos);
            if (state.method_26207() == class_3614.field_15959) {
                return false;
            }
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof BlockPickInteractionAware) {
                BlockPickInteractionAware aware = (BlockPickInteractionAware)class_22482;
                result = aware.getPickedStack(state, (class_1922)level, pos, (class_1657)player, hitResult);
            }
        } else if (hitResult.method_17783() == class_239.class_240.field_1331 && (entity = ((class_3966)hitResult).method_17782()) instanceof EntityPickInteractionAware) {
            EntityPickInteractionAware aware = (EntityPickInteractionAware)entity;
            result = aware.getPickedStack((class_1657)player, hitResult);
        }
        if (result.method_7960()) {
            return false;
        }
        for (ToolboxBlockEntity toolboxBlockEntity : toolboxes) {
            ToolboxInventory inventory = toolboxBlockEntity.inventory;
            Transaction t = TransferUtil.getTransaction();
            try {
                for (int comp = 0; comp < 8; ++comp) {
                    class_1799 inSlot = inventory.takeFromCompartment(1, comp, (TransactionContext)t);
                    if (inSlot.method_7960() || inSlot.method_7909() != result.method_7909() || !class_1799.method_7975((class_1799)inSlot, (class_1799)result)) continue;
                    AllPackets.getChannel().sendToServer((C2SPacket)new ToolboxEquipPacket(toolboxBlockEntity.method_11016(), comp, player.method_31548().field_7545));
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (t == null) continue;
                t.close();
            }
        }
        return false;
    }

    public static void onKeyInput(int key, boolean pressed) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1761 == null || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        if (key != AllKeys.TOOLBELT.getBoundCode() || !pressed) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        class_1937 level = player.field_6002;
        List<ToolboxBlockEntity> toolboxes = ToolboxHandler.getNearest((class_1936)player.field_6002, (class_1657)player, 8);
        toolboxes.sort(Comparator.comparing(ToolboxBlockEntity::getUniqueId));
        class_2487 compound = player.getExtraCustomData().method_10562("CreateToolboxData");
        String slotKey = String.valueOf(player.method_31548().field_7545);
        boolean equipped = compound.method_10545(slotKey);
        if (equipped) {
            class_2586 blockEntity;
            boolean canReachToolbox;
            class_2338 pos = class_2512.method_10691((class_2487)compound.method_10562(slotKey).method_10562("Pos"));
            double max = ToolboxHandler.getMaxRange((class_1657)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance(player.method_19538(), pos) < max * max;
            if (canReachToolbox && (blockEntity = level.method_8321(pos)) instanceof ToolboxBlockEntity) {
                RadialToolboxMenu screen = new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP, (ToolboxBlockEntity)blockEntity);
                screen.prevSlot(compound.method_10562(slotKey).method_10550("Slot"));
                ScreenOpener.open(screen);
                return;
            }
            ScreenOpener.open(new RadialToolboxMenu((List<ToolboxBlockEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH, null));
            return;
        }
        if (toolboxes.isEmpty()) {
            return;
        }
        if (toolboxes.size() == 1) {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM, toolboxes.get(0)));
        } else {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_BOX, null));
        }
    }

    public static void renderOverlay(class_4587 poseStack, float partialTicks, class_1041 window) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1761.method_2920() == class_1934.field_9219) {
            return;
        }
        int x = window.method_4486() / 2 - 90;
        int y = window.method_4502() - 23;
        RenderSystem.enableDepthTest();
        class_746 player = mc.field_1724;
        class_2487 persistentData = player.getExtraCustomData();
        if (!persistentData.method_10545("CreateToolboxData")) {
            return;
        }
        class_2487 compound = player.getExtraCustomData().method_10562("CreateToolboxData");
        if (compound.method_33133()) {
            return;
        }
        poseStack.method_22903();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.method_10545(key)) continue;
            class_2338 pos = class_2512.method_10691((class_2487)compound.method_10562(key).method_10562("Pos"));
            double max = ToolboxHandler.getMaxRange((class_1657)player);
            boolean selected = player.method_31548().field_7545 == slot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance(player.method_19538(), pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.render(poseStack, x + 20 * slot - offset, y + offset - (Integer)AllConfigs.client().toolboxHotbarOverlayOffset.get());
        }
        poseStack.method_22909();
    }
}

