/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.steamWhistle;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Random;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class WhistleBlock
extends class_2248
implements IBE<WhistleBlockEntity>,
IWrenchable {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 WALL = class_2746.method_11825((String)"wall");
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2754<WhistleSize> SIZE = class_2754.method_11850((String)"size", WhistleSize.class);

    public WhistleBlock(class_4970.class_2251 p_49795_) {
        super(p_49795_);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WALL, (Comparable)Boolean.valueOf(false))).method_11657(SIZE, (Comparable)((Object)WhistleSize.MEDIUM)));
    }

    public void method_9567(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1309 pPlacer, class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return FluidTankBlock.isTank(pLevel.method_8320(pPos.method_10093(WhistleBlock.getAttachedDirection(pState))));
    }

    @Override
    public class_2680 getRotatedBlockState(class_2680 originalState, class_2350 targetedFace) {
        return (class_2680)originalState.method_28493(SIZE);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(new class_2769[]{FACING, POWERED, SIZE, WALL}));
    }

    public class_2680 method_9605(class_1750 pContext) {
        class_2680 state;
        class_1937 level = pContext.method_8045();
        class_2338 clickedPos = pContext.method_8037();
        class_2350 face = pContext.method_8038();
        boolean wall = true;
        if (face.method_10166() == class_2350.class_2351.field_11052) {
            face = pContext.method_8042().method_10153();
            wall = false;
        }
        if (!this.method_9558(state = (class_2680)((class_2680)((class_2680)super.method_9605(pContext).method_11657((class_2769)FACING, (Comparable)face.method_10153())).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(level.method_8479(clickedPos)))).method_11657((class_2769)WALL, (Comparable)Boolean.valueOf(wall)), (class_4538)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public class_1269 method_9534(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (pPlayer == null) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = pPlayer.method_5998(pHand);
        if (AllBlocks.STEAM_WHISTLE.isIn(heldItem)) {
            WhistleBlock.incrementSize((class_1936)pLevel, pPos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static void incrementSize(class_1936 pLevel, class_2338 pPos) {
        class_2680 base = pLevel.method_8320(pPos);
        if (!base.method_28498(SIZE)) {
            return;
        }
        WhistleSize size = (WhistleSize)((Object)base.method_11654(SIZE));
        class_2498 soundtype = base.method_26231();
        class_2338 currentPos = pPos.method_10084();
        for (int i = 1; i <= 6; ++i) {
            class_2680 blockState = pLevel.method_8320(currentPos);
            float pVolume = (soundtype.method_10597() + 1.0f) / 2.0f;
            class_3414 growSound = class_3417.field_14776;
            class_3414 hitSound = soundtype.method_10596();
            if (AllBlocks.STEAM_WHISTLE_EXTENSION.has(blockState)) {
                if (blockState.method_11654(WhistleExtenderBlock.SHAPE) == WhistleExtenderBlock.WhistleExtenderShape.SINGLE) {
                    pLevel.method_8652(currentPos, (class_2680)blockState.method_11657(WhistleExtenderBlock.SHAPE, (Comparable)((Object)WhistleExtenderBlock.WhistleExtenderShape.DOUBLE)), 3);
                    if (soundtype != null) {
                        float pPitch = (float)Math.pow(2.0, (double)(-(i * 2)) / 12.0);
                        pLevel.method_8396(null, currentPos, growSound, class_3419.field_15245, pVolume / 4.0f, pPitch);
                        pLevel.method_8396(null, currentPos, hitSound, class_3419.field_15245, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.method_26207().method_15800()) {
                    return;
                }
                pLevel.method_8652(currentPos, (class_2680)AllBlocks.STEAM_WHISTLE_EXTENSION.getDefaultState().method_11657(SIZE, (Comparable)((Object)size)), 3);
                if (soundtype != null) {
                    float pPitch = (float)Math.pow(2.0, (double)(-(i * 2 - 1)) / 12.0);
                    pLevel.method_8396(null, currentPos, growSound, class_3419.field_15245, pVolume / 4.0f, pPitch);
                    pLevel.method_8396(null, currentPos, hitSound, class_3419.field_15245, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.method_10084();
        }
    }

    public static void queuePitchUpdate(class_1936 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)class_22482;
            if (!level.method_8397().method_8674(pos, (Object)whistle)) {
                level.method_39279(pos, (class_2248)whistle, 1);
            }
        }
    }

    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, Random pRandom) {
        this.withBlockEntityDo((class_1922)pLevel, pPos, WhistleBlockEntity::updatePitch);
    }

    public void method_9615(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.method_10093(WhistleBlock.getAttachedDirection(pState)));
        if (pOldState.method_26204() != this || pOldState.method_11654(SIZE) != pState.method_11654(SIZE)) {
            WhistleBlock.queuePitchUpdate((class_1936)pLevel, pPos);
        }
    }

    public void method_9536(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2680 pNewState, boolean pIsMoving) {
        IBE.onRemove(pState, pLevel, pPos, pNewState);
        FluidTankBlock.updateBoilerState(pState, pLevel, pPos.method_10093(WhistleBlock.getAttachedDirection(pState)));
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (worldIn.field_9236) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (previouslyPowered != worldIn.method_8479(pos)) {
            worldIn.method_8652(pos, (class_2680)state.method_28493((class_2769)POWERED), 2);
        }
    }

    public class_2680 method_9559(class_2680 pState, class_2350 pFacing, class_2680 pFacingState, class_1936 pLevel, class_2338 pCurrentPos, class_2338 pFacingPos) {
        return WhistleBlock.getAttachedDirection(pState) == pFacing && !pState.method_26184((class_4538)pLevel, pCurrentPos) ? class_2246.field_10124.method_9564() : pState;
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        WhistleSize size = (WhistleSize)((Object)pState.method_11654(SIZE));
        if (!((Boolean)pState.method_11654((class_2769)WALL)).booleanValue()) {
            return size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_FLOOR : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_FLOOR : AllShapes.WHISTLE_LARGE_FLOOR);
        }
        class_2350 direction = (class_2350)pState.method_11654((class_2769)FACING);
        return (size == WhistleSize.SMALL ? AllShapes.WHISTLE_SMALL_WALL : (size == WhistleSize.MEDIUM ? AllShapes.WHISTLE_MEDIUM_WALL : AllShapes.WHISTLE_LARGE_WALL)).get(direction);
    }

    public boolean method_9516(class_2680 state, class_1922 reader, class_2338 pos, class_10 type) {
        return false;
    }

    public static class_2350 getAttachedDirection(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WALL) != false ? (class_2350)state.method_11654((class_2769)FACING) : class_2350.field_11033;
    }

    @Override
    public Class<WhistleBlockEntity> getBlockEntityClass() {
        return WhistleBlockEntity.class;
    }

    @Override
    public class_2591<? extends WhistleBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.STEAM_WHISTLE.get();
    }

    public class_2680 method_9598(class_2680 pState, class_2470 pRotation) {
        return (class_2680)pState.method_11657((class_2769)FACING, (Comparable)pRotation.method_10503((class_2350)pState.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 pState, class_2415 pMirror) {
        return pMirror == class_2415.field_11302 ? pState : pState.method_26186(pMirror.method_10345((class_2350)pState.method_11654((class_2769)FACING)));
    }

    public static enum WhistleSize implements class_3542
    {
        SMALL,
        MEDIUM,
        LARGE;


        public String method_15434() {
            return Lang.asId(this.name());
        }
    }
}

