/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.piston;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.simibubi.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Random;
import me.alphamode.forgetags.Tags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class MechanicalPistonBlock
extends DirectionalAxisKineticBlock
implements IBE<MechanicalPistonBlockEntity> {
    public static final class_2754<PistonState> STATE = class_2754.method_11850((String)"state", PistonState.class);
    protected boolean isSticky;

    public static MechanicalPistonBlock normal(class_4970.class_2251 properties) {
        return new MechanicalPistonBlock(properties, false);
    }

    public static MechanicalPistonBlock sticky(class_4970.class_2251 properties) {
        return new MechanicalPistonBlock(properties, true);
    }

    protected MechanicalPistonBlock(class_4970.class_2251 properties, boolean sticky) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(STATE, (Comparable)((Object)PistonState.RETRACTED)));
        this.isSticky = sticky;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STATE});
        super.method_9515(builder);
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (!player.method_7294()) {
            return class_1269.field_5811;
        }
        if (player.method_5715()) {
            return class_1269.field_5811;
        }
        if (!player.method_5998(handIn).method_31573(Tags.Items.SLIMEBALLS)) {
            if (player.method_5998(handIn).method_7960()) {
                this.withBlockEntityDo((class_1922)worldIn, pos, be -> {
                    be.assembleNextTick = true;
                });
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        if (state.method_11654(STATE) != PistonState.RETRACTED) {
            return class_1269.field_5811;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        if (hit.method_17780() != direction) {
            return class_1269.field_5811;
        }
        if (((MechanicalPistonBlock)state.method_26204()).isSticky) {
            return class_1269.field_5811;
        }
        if (worldIn.field_9236) {
            class_243 vec = hit.method_17784();
            worldIn.method_8406((class_2394)class_2398.field_11246, vec.field_1352, vec.field_1351, vec.field_1350, 0.0, 0.0, 0.0);
            return class_1269.field_5812;
        }
        AllSoundEvents.SLIME_ADDED.playOnServer(worldIn, (class_2382)pos, 0.5f, 1.0f);
        if (!player.method_7337()) {
            player.method_5998(handIn).method_7934(1);
        }
        worldIn.method_8501(pos, (class_2680)((class_2680)AllBlocks.STICKY_MECHANICAL_PISTON.getDefaultState().method_11657((class_2769)FACING, (Comparable)direction)).method_11657((class_2769)AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.method_11654((class_2769)AXIS_ALONG_FIRST_COORDINATE))));
        return class_1269.field_5812;
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 p_220069_4_, class_2338 fromPos, boolean p_220069_6_) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        if (!fromPos.equals((Object)pos.method_10093(direction.method_10153()))) {
            return;
        }
        if (!world.field_9236 && !world.method_8397().method_8677(pos, (Object)this)) {
            world.method_39279(pos, (class_2248)this, 0);
        }
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, Random r) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2680 pole = worldIn.method_8320(pos.method_10093(direction.method_10153()));
        if (!AllBlocks.PISTON_EXTENSION_POLE.has(pole)) {
            return;
        }
        if (((class_2350)pole.method_11654((class_2769)PistonExtensionPoleBlock.field_10927)).method_10166() != direction.method_10166()) {
            return;
        }
        this.withBlockEntityDo((class_1922)worldIn, pos, be -> {
            if (be.lastException == null) {
                return;
            }
            be.lastException = null;
            be.sendData();
        });
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        if (state.method_11654(STATE) != PistonState.RETRACTED) {
            return class_1269.field_5811;
        }
        return super.onWrenched(state, context);
    }

    public void method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 block;
        class_2338 currentPos;
        int offset;
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        class_2338 pistonHead = null;
        class_2338 pistonBase = pos;
        boolean dropBlocks = player == null || !player.method_7337();
        Integer maxPoles = MechanicalPistonBlock.maxAllowedPistonPoles();
        for (offset = 1; offset < maxPoles; ++offset) {
            currentPos = pos.method_10079(direction, offset);
            block = worldIn.method_8320(currentPos);
            if (MechanicalPistonBlock.isExtensionPole(block) && direction.method_10166() == ((class_2350)block.method_11654((class_2769)class_2741.field_12525)).method_10166()) continue;
            if (!MechanicalPistonBlock.isPistonHead(block) || block.method_11654((class_2769)class_2741.field_12525) != direction) break;
            pistonHead = currentPos;
            break;
        }
        if (pistonHead != null && pistonBase != null) {
            class_2338.method_20437((class_2338)pistonBase, pistonHead).filter(p -> !p.equals((Object)pos)).forEach(p -> worldIn.method_22352(p, dropBlocks));
        }
        for (offset = 1; offset < maxPoles && MechanicalPistonBlock.isExtensionPole(block = worldIn.method_8320(currentPos = pos.method_10079(direction.method_10153(), offset))) && direction.method_10166() == ((class_2350)block.method_11654((class_2769)class_2741.field_12525)).method_10166(); ++offset) {
            worldIn.method_22352(currentPos, dropBlocks);
        }
        super.method_9576(worldIn, pos, state, player);
    }

    public static int maxAllowedPistonPoles() {
        return (Integer)AllConfigs.server().kinetics.maxPistonPoles.get();
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        if (state.method_11654(STATE) == PistonState.EXTENDED) {
            return AllShapes.MECHANICAL_PISTON_EXTENDED.get((class_2350)state.method_11654((class_2769)FACING));
        }
        if (state.method_11654(STATE) == PistonState.MOVING) {
            return AllShapes.MECHANICAL_PISTON.get((class_2350)state.method_11654((class_2769)FACING));
        }
        return class_259.method_1077();
    }

    @Override
    public Class<MechanicalPistonBlockEntity> getBlockEntityClass() {
        return MechanicalPistonBlockEntity.class;
    }

    @Override
    public class_2591<? extends MechanicalPistonBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.MECHANICAL_PISTON.get();
    }

    public static boolean isPiston(class_2680 state) {
        return AllBlocks.MECHANICAL_PISTON.has(state) || MechanicalPistonBlock.isStickyPiston(state);
    }

    public static boolean isStickyPiston(class_2680 state) {
        return AllBlocks.STICKY_MECHANICAL_PISTON.has(state);
    }

    public static boolean isExtensionPole(class_2680 state) {
        return AllBlocks.PISTON_EXTENSION_POLE.has(state);
    }

    public static boolean isPistonHead(class_2680 state) {
        return AllBlocks.MECHANICAL_PISTON_HEAD.has(state);
    }

    public static enum PistonState implements class_3542
    {
        RETRACTED,
        MOVING,
        EXTENDED;


        public String method_15434() {
            return Lang.asId(this.name());
        }
    }
}

