/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.mounted;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.IDisplayAssemblyExceptions;
import com.simibubi.create.content.contraptions.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.minecart.CouplingHandler;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.redstone.rail.ControllerRailBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3532;

public class CartAssemblerBlockEntity
extends SmartBlockEntity
implements IDisplayAssemblyExceptions {
    private static final int assemblyCooldown = 8;
    protected ScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;
    protected AssemblyException lastException;
    protected class_1688 cartToAssemble;

    public CartAssemblerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
        this.tryAssemble(this.cartToAssemble);
        this.cartToAssemble = null;
    }

    public void tryAssemble(class_1688 cart) {
        if (cart == null) {
            return;
        }
        if (!this.isMinecartUpdateValid()) {
            return;
        }
        this.resetTicksSinceMinecartUpdate();
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (!AllBlocks.CART_ASSEMBLER.has(state)) {
            return;
        }
        CartAssemblerBlock block = (CartAssemblerBlock)state.method_26204();
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble()) {
            this.assemble(this.field_11863, this.field_11867, cart);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.field_11863, this.field_11867, cart);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE && cart.method_18798().method_1033() > 0.0078125) {
            class_2350 facing = cart.method_5755();
            class_2768 railShape = (class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE);
            for (class_2350 d : Iterate.directionsInAxis(railShape == class_2768.field_12674 ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051)) {
                if (!this.field_11863.method_8320(this.field_11867.method_10093(d)).method_26212((class_1922)this.field_11863, this.field_11867.method_10093(d))) continue;
                facing = d.method_10153();
            }
            float speed = 0.4f;
            cart.method_18800((double)((float)facing.method_10148() * speed), (double)((float)facing.method_10164() * speed), (double)((float)facing.method_10165() * speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            class_2382 accelerationVector = ControllerRailBlock.getAccelerationVector((class_2680)((class_2680)AllBlocks.CONTROLLER_RAIL.getDefaultState().method_11657(ControllerRailBlock.SHAPE, (Comparable)((class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE)))).method_11657((class_2769)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.method_11654((class_2769)CartAssemblerBlock.BACKWARDS))));
            float speed = 0.4f;
            cart.method_18799(class_243.method_24954((class_2382)accelerationVector).method_1021((double)speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            class_243 diff = VecHelper.getCenterOf((class_2382)this.field_11867).method_1020(cart.method_19538());
            cart.method_18800(diff.field_1352 / 16.0, 0.0, diff.field_1350 / 16.0);
        }
    }

    protected void assemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (!cart.method_5685().isEmpty()) {
            return;
        }
        LazyOptional optional = cart.lazyController();
        if (optional.isPresent() && ((MinecartController)optional.orElse(null)).isCoupledThroughContraption()) {
            return;
        }
        CartMovementMode mode = CartMovementMode.values()[this.movementMode.value];
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        class_2350 initialOrientation = CartAssemblerBlock.getHorizontalDirection(this.method_11010());
        if (couplingFound) {
            cart.method_5814((double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.method_5628(), contraption.connectedCart.method_5628())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, class_2338.field_10980);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(class_2350.class_2351.field_11052);
        if (couplingFound) {
            class_243 diff = contraption.connectedCart.method_19538().method_1020(cart.method_19538());
            initialOrientation = class_2350.method_10150((double)(class_3532.method_15349((double)diff.field_1350, (double)diff.field_1352) * 180.0 / Math.PI));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.method_5667());
        }
        entity.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        world.method_8649((class_1297)entity);
        entity.method_5804((class_1297)cart);
        if (cart instanceof class_1696) {
            class_2487 nbt = NBTSerializer.serializeNBTCompound((Object)cart);
            nbt.method_10549("PushZ", 0.0);
            nbt.method_10549("PushX", 0.0);
            NBTSerializer.deserializeNBT((Object)cart, (class_2520)nbt);
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    protected void disassemble(class_1937 world, class_2338 pos, class_1688 cart) {
        if (cart.method_5685().isEmpty()) {
            return;
        }
        class_1297 entity = (class_1297)cart.method_5685().get(0);
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(this.method_11010()).method_10144();
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            class_2338 otherPos = minecartController.cart().method_24515();
            class_2680 blockState = world.method_8320(otherPos);
            if (!AllBlocks.CART_ASSEMBLER.has(blockState)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(class_1688 cart) {
        cart.method_5772();
        if (cart instanceof class_1696) {
            class_2487 nbt = NBTSerializer.serializeNBTCompound((Object)cart);
            nbt.method_10549("PushZ", cart.method_18798().field_1352);
            nbt.method_10549("PushX", cart.method_18798().field_1350);
            NBTSerializer.deserializeNBT((Object)cart, (class_2520)nbt);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementMode = new ScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, (class_2561)Lang.translateDirect("contraptions.cart_movement_mode", new Object[0]), this, this.getMovementModeSlot());
        behaviours.add(this.movementMode);
        this.registerAwardables(behaviours, AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        AssemblyException.write(compound, this.lastException);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        this.lastException = AssemblyException.read(compound);
        super.read(compound, clientPacket);
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    protected ValueBoxTransform getMovementModeSlot() {
        return new CartAssemblerValueBoxTransform();
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(class_1688 cart) {
        if (this.cartToAssemble == null) {
            this.cartToAssemble = cart;
        }
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements INamedIconOptions
    {
        ROTATE(AllIcons.I_CART_ROTATE),
        ROTATE_PAUSED(AllIcons.I_CART_ROTATE_PAUSED),
        ROTATION_LOCKED(AllIcons.I_CART_ROTATE_LOCKED);

        private String translationKey;
        private AllIcons icon;

        private CartMovementMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.cart_movement_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class CartAssemblerValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public CartAssemblerValueBoxTransform() {
            super((class_2680 state, class_2350 d) -> {
                if (d.method_10166().method_10178()) {
                    return false;
                }
                if (!state.method_28498(CartAssemblerBlock.RAIL_SHAPE)) {
                    return false;
                }
                class_2768 railShape = (class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE);
                return d.method_10166() == class_2350.class_2351.field_11048 == (railShape == class_2768.field_12665);
            });
        }

        @Override
        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace(8.0, 7.0, 17.5);
        }
    }
}

