/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.elevator;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.elevator.ElevatorColumn;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorContactScreen;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.content.redstone.diodes.BrassDiodeBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.BlockHelper;
import io.github.fabricators_of_create.porting_lib.block.ConnectableRedstoneBlock;
import io.github.fabricators_of_create.porting_lib.block.WeakPowerCheckingBlock;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_746;

public class ElevatorContactBlock
extends WrenchableDirectionalBlock
implements IBE<ElevatorContactBlockEntity>,
ISpecialBlockItemRequirement,
WeakPowerCheckingBlock,
ConnectableRedstoneBlock {
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 CALLING = class_2746.method_11825((String)"calling");
    public static final class_2746 POWERING = BrassDiodeBlock.POWERING;

    public ElevatorContactBlock(class_4970.class_2251 pProperties) {
        super(pProperties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)CALLING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_10927, (Comparable)class_2350.field_11035));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{CALLING, POWERING, POWERED}));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        if (onWrenched != class_1269.field_5812) {
            return onWrenched;
        }
        class_1937 level = context.method_8045();
        if (level.method_8608()) {
            return onWrenched;
        }
        class_2338 pos = context.method_8037();
        state = level.method_8320(pos);
        class_2350 facing = (class_2350)state.method_11654((class_2769)RedstoneContactBlock.field_10927);
        if (facing.method_10166() != class_2350.class_2351.field_11052 && ElevatorColumn.get((class_1936)level, new ElevatorColumn.ColumnCoords(pos.method_10263(), pos.method_10260(), facing)) != null) {
            return onWrenched;
        }
        level.method_8501(pos, BlockHelper.copyProperties(state, AllBlocks.REDSTONE_CONTACT.getDefaultState()));
        return onWrenched;
    }

    @Nullable
    public static ElevatorColumn.ColumnCoords getColumnCoords(class_1936 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        if (!AllBlocks.ELEVATOR_CONTACT.has(blockState) && !AllBlocks.REDSTONE_CONTACT.has(blockState)) {
            return null;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)field_10927);
        class_2338 target = pos;
        return new ElevatorColumn.ColumnCoords(target.method_10263(), target.method_10260(), facing);
    }

    public void method_9612(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_2248 pBlock, class_2338 pFromPos, boolean pIsMoving) {
        if (pLevel.field_9236) {
            return;
        }
        boolean isPowered = (Boolean)pState.method_11654((class_2769)POWERED);
        if (isPowered == pLevel.method_8479(pPos)) {
            return;
        }
        pLevel.method_8652(pPos, (class_2680)pState.method_28493((class_2769)POWERED), 2);
        if (isPowered) {
            return;
        }
        if (((Boolean)pState.method_11654((class_2769)CALLING)).booleanValue()) {
            return;
        }
        ElevatorColumn elevatorColumn = ElevatorColumn.getOrCreate((class_1936)pLevel, ElevatorContactBlock.getColumnCoords((class_1936)pLevel, pPos));
        this.callToContactAndUpdate(elevatorColumn, pState, pLevel, pPos, true);
    }

    public void callToContactAndUpdate(ElevatorColumn elevatorColumn, class_2680 pState, class_1937 pLevel, class_2338 pPos, boolean powered) {
        pLevel.method_8652(pPos, (class_2680)pState.method_28493((class_2769)CALLING), 2);
        for (class_2338 otherPos : elevatorColumn.getContacts()) {
            class_2680 otherState;
            if (otherPos.equals((Object)pPos) || !AllBlocks.ELEVATOR_CONTACT.has(otherState = pLevel.method_8320(otherPos))) continue;
            pLevel.method_8652(otherPos, (class_2680)otherState.method_11657((class_2769)CALLING, (Comparable)Boolean.valueOf(false)), 18);
            this.scheduleActivation((class_1936)pLevel, otherPos);
        }
        if (powered) {
            pState = (class_2680)pState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true));
        }
        pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)CALLING, (Comparable)Boolean.valueOf(true)), 2);
        pLevel.method_8452(pPos, (class_2248)this);
        elevatorColumn.target(pPos.method_10264());
        elevatorColumn.markDirty();
    }

    public void scheduleActivation(class_1936 pLevel, class_2338 pPos) {
        if (!pLevel.method_8397().method_8674(pPos, (Object)this)) {
            pLevel.method_39279(pPos, (class_2248)this, 1);
        }
    }

    public void method_9588(class_2680 pState, class_3218 pLevel, class_2338 pPos, Random pRand) {
        boolean wasPowering = (Boolean)pState.method_11654((class_2769)POWERING);
        Optional optionalBE = this.getBlockEntityOptional((class_1922)pLevel, pPos);
        boolean shouldBePowering = optionalBE.map(be -> {
            boolean activateBlock = be.activateBlock;
            be.activateBlock = false;
            be.method_5431();
            return activateBlock;
        }).orElse(false);
        if (wasPowering || (shouldBePowering |= RedstoneContactBlock.hasValidContact((class_1936)pLevel, pPos, (class_2350)pState.method_11654((class_2769)field_10927)))) {
            pLevel.method_8652(pPos, (class_2680)pState.method_11657((class_2769)POWERING, (Comparable)Boolean.valueOf(shouldBePowering)), 18);
        }
        pLevel.method_8452(pPos, (class_2248)this);
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (facing != stateIn.method_11654((class_2769)field_10927)) {
            return stateIn;
        }
        boolean hasValidContact = RedstoneContactBlock.hasValidContact(worldIn, currentPos, facing);
        if ((Boolean)stateIn.method_11654((class_2769)POWERING) != hasValidContact) {
            this.scheduleActivation(worldIn, currentPos);
        }
        return stateIn;
    }

    public boolean shouldCheckWeakPower(class_2680 state, class_4538 level, class_2338 pos, class_2350 side) {
        return false;
    }

    public boolean method_9506(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)POWERING);
    }

    public class_1799 method_9574(class_1922 pLevel, class_2338 pPos, class_2680 pState) {
        return AllBlocks.REDSTONE_CONTACT.asStack();
    }

    public boolean canConnectRedstone(class_2680 state, class_1922 world, class_2338 pos, @Nullable class_2350 side) {
        if (side == null) {
            return true;
        }
        return state.method_11654((class_2769)field_10927) != side.method_10153();
    }

    public int method_9524(class_2680 state, class_1922 blockAccess, class_2338 pos, class_2350 side) {
        if (side == null) {
            return 0;
        }
        class_2680 toState = blockAccess.method_8320(pos.method_10093(side.method_10153()));
        if (toState.method_27852((class_2248)this)) {
            return 0;
        }
        return (Boolean)state.method_11654((class_2769)POWERING) != false ? 15 : 0;
    }

    @Override
    public Class<ElevatorContactBlockEntity> getBlockEntityClass() {
        return ElevatorContactBlockEntity.class;
    }

    @Override
    public class_2591<? extends ElevatorContactBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.ELEVATOR_CONTACT.get();
    }

    public void method_9578(class_1761 pTab, class_2371<class_1799> pItems) {
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state, class_2586 be) {
        return ItemRequirement.of(AllBlocks.REDSTONE_CONTACT.getDefaultState(), be);
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        if (player != null && AllItems.WRENCH.isIn(player.method_5998(handIn))) {
            return class_1269.field_5811;
        }
        EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.withBlockEntityDo((class_1922)worldIn, pos, be -> this.displayScreen((ElevatorContactBlockEntity)be, player)));
        return class_1269.field_5812;
    }

    @Environment(value=EnvType.CLIENT)
    protected void displayScreen(ElevatorContactBlockEntity be, class_1657 player) {
        if (player instanceof class_746) {
            ScreenOpener.open(new ElevatorContactScreen(be.method_11016(), be.shortName, be.longName, be.doorControls.mode));
        }
    }

    public static int getLight(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)POWERING) != false ? 10 : 0;
    }
}

