/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour.dispenser;

import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.dispenser.DispenseItemLocation;
import com.simibubi.create.content.contraptions.behaviour.dispenser.MovedDefaultDispenseItemBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.ArrayList;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;

public class DropperMovementBehaviour
implements MovementBehaviour {
    protected static final MovedDefaultDispenseItemBehaviour DEFAULT_BEHAVIOUR = new MovedDefaultDispenseItemBehaviour();
    private static final Random RNG = new Random();

    protected void activate(MovementContext context, class_2338 pos) {
        DispenseItemLocation location = this.getDispenseLocation(context);
        if (location.isEmpty()) {
            context.world.method_20290(1001, pos, 0);
        } else {
            this.setItemStackAt(location, DEFAULT_BEHAVIOUR.dispense(this.getItemStackAt(location, context), context, pos), context);
        }
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236) {
            return;
        }
        this.collectItems(context);
        this.activate(context, pos);
    }

    private void collectItems(MovementContext context) {
        this.getStacks(context).stream().filter(itemStack -> !itemStack.method_7960() && itemStack.method_7909() != class_1802.field_8162 && itemStack.method_7914() > itemStack.method_7947()).forEach(itemStack -> itemStack.method_7933(ItemHelper.extract((Storage<ItemVariant>)context.contraption.getSharedInventory(), arg_0 -> ((class_1799)itemStack).method_7962(arg_0), ItemHelper.ExtractionCountMode.UPTO, itemStack.method_7914() - itemStack.method_7947(), false).method_7947()));
    }

    private void updateTemporaryData(MovementContext context) {
        if (!(context.temporaryData instanceof class_2371) && context.world != null) {
            class_2371 stacks = class_2371.method_10213((int)DropperMovementBehaviour.getInvSize(), (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)context.blockEntityData, (class_2371)stacks);
            context.temporaryData = stacks;
        }
    }

    private class_2371<class_1799> getStacks(MovementContext context) {
        this.updateTemporaryData(context);
        return (class_2371)context.temporaryData;
    }

    private ArrayList<DispenseItemLocation> getUseableLocations(MovementContext context) {
        ArrayList<DispenseItemLocation> useable = new ArrayList<DispenseItemLocation>();
        try (Transaction t = TransferUtil.getTransaction();){
            for (int slot = 0; slot < DropperMovementBehaviour.getInvSize(); ++slot) {
                DispenseItemLocation location = new DispenseItemLocation(slot);
                class_1799 testStack = this.getItemStackAt(location, context);
                if (testStack == null || testStack.method_7960()) continue;
                if (testStack.method_7914() == 1) {
                    ResourceAmount available = StorageUtil.findExtractableContent((Storage)context.contraption.getSharedInventory(), v -> v.matches(testStack), (TransactionContext)t);
                    if (available == null) continue;
                    location = new DispenseItemLocation((ResourceAmount<ItemVariant>)available);
                    useable.add(location);
                    continue;
                }
                if (testStack.method_7947() < 2) continue;
                useable.add(location);
            }
            ArrayList<DispenseItemLocation> arrayList = useable;
            return arrayList;
        }
    }

    @Override
    public void writeExtraData(MovementContext context) {
        class_2371<class_1799> stacks = this.getStacks(context);
        if (stacks == null) {
            return;
        }
        class_1262.method_5426((class_2487)context.blockEntityData, stacks);
    }

    @Override
    public void stopMoving(MovementContext context) {
        MovementBehaviour.super.stopMoving(context);
        this.writeExtraData(context);
    }

    protected DispenseItemLocation getDispenseLocation(MovementContext context) {
        int i = -1;
        int j = 1;
        ArrayList<DispenseItemLocation> useableLocations = this.getUseableLocations(context);
        for (int k = 0; k < useableLocations.size(); ++k) {
            if (RNG.nextInt(j++) != 0) continue;
            i = k;
        }
        if (i < 0) {
            return DispenseItemLocation.NONE;
        }
        return (DispenseItemLocation)useableLocations.get(i);
    }

    protected class_1799 getItemStackAt(DispenseItemLocation location, MovementContext context) {
        if (location.isInternal()) {
            return (class_1799)this.getStacks(context).get(location.getSlot());
        }
        return location.getVariant().toStack(location.getCount());
    }

    protected void setItemStackAt(DispenseItemLocation location, class_1799 stack, MovementContext context) {
        if (location.isInternal()) {
            this.getStacks(context).set(location.getSlot(), (Object)stack);
        } else {
            try (Transaction t = TransferUtil.getTransaction();){
                context.contraption.getSharedInventory().extract(location.getVariant(), location.getCount(), (TransactionContext)t);
                context.contraption.getSharedInventory().insert(ItemVariant.of((class_1799)stack), stack.method_7947(), (TransactionContext)t);
                t.commit();
            }
        }
    }

    private static int getInvSize() {
        return 9;
    }
}

