/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.actors.roller.PaveTask;
import com.simibubi.create.content.contraptions.actors.roller.RollerActorInstance;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlock;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.simibubi.create.content.contraptions.actors.roller.RollerRenderer;
import com.simibubi.create.content.contraptions.actors.roller.TrackPaverV2;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.bogey.StandardBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1282;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

public class RollerMovementBehaviour
extends BlockBreakingMovementBehaviour {
    RollerTravellingPoint rollerScout = new RollerTravellingPoint();

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !(context.contraption instanceof PulleyContraption) && VecHelper.isVecPointingTowards(context.relativeMotion, (class_2350)context.state.method_11654((class_2769)RollerBlock.field_11177));
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new RollerActorInstance(materialManager, simulationWorld, context);
    }

    @Override
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffers) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            RollerRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)RollerBlock.field_11177)).method_10163()).method_1021(0.45).method_1023(0.0, 2.0, 0.0);
    }

    @Override
    protected float getBlockBreakingSpeed(MovementContext context) {
        return class_3532.method_15363((float)(super.getBlockBreakingSpeed(context) * 1.5f), (float)0.0078125f, (float)16.0f);
    }

    @Override
    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        for (class_2350 side : Iterate.directions) {
            if (!world.method_8320(breakingPos.method_10093(side)).method_26164(class_3481.field_21780)) continue;
            return false;
        }
        return super.canBreak(world, breakingPos, state) && !state.method_26220((class_1922)world, breakingPos).method_1110() && !AllBlocks.TRACK.has(state);
    }

    @Override
    protected class_1282 getDamageSource() {
        return RollerBlock.damageSourceRoller;
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        class_2680 stateVisited = world.method_8320(pos);
        if (!stateVisited.method_26212((class_1922)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.field_9236) {
            return;
        }
        List<class_2338> positionsToBreak = this.getPositionsToBreak(context, pos);
        if (positionsToBreak.isEmpty()) {
            this.triggerPaver(context, pos);
            return;
        }
        class_2338 argMax = null;
        double max = -1.0;
        for (class_2338 toBreak : positionsToBreak) {
            float hardness = context.world.method_8320(toBreak).method_26214((class_1922)world, toBreak);
            if ((double)hardness < max) continue;
            max = hardness;
            argMax = toBreak;
        }
        if (argMax == null) {
            this.triggerPaver(context, pos);
            return;
        }
        context.data.method_10566("ReferencePos", (class_2520)class_2512.method_10692((class_2338)pos));
        context.data.method_10566("BreakingPos", (class_2520)class_2512.method_10692(argMax));
        context.stall = true;
    }

    @Override
    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (!context.data.method_10545("ReferencePos")) {
            return;
        }
        class_2338 referencePos = class_2512.method_10691((class_2487)context.data.method_10562("ReferencePos"));
        for (class_2338 otherPos : this.getPositionsToBreak(context, referencePos)) {
            if (otherPos.equals((Object)pos)) continue;
            this.destroyBlock(context, otherPos);
        }
        this.triggerPaver(context, referencePos);
        context.data.method_10551("ReferencePos");
    }

    @Override
    protected void destroyBlock(MovementContext context, class_2338 breakingPos) {
        class_2680 blockState = context.world.method_8320(breakingPos);
        boolean noHarvest = blockState.method_26164(class_3481.field_33718) || blockState.method_26164(class_3481.field_33719) || blockState.method_26164(class_3481.field_33717);
        BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> {
            if (noHarvest || context.world.field_9229.nextBoolean()) {
                return;
            }
            this.dropItem(context, (class_1799)stack);
        });
        super.destroyBlock(context, breakingPos);
    }

    protected List<class_2338> getPositionsToBreak(MovementContext context, class_2338 visitedPos) {
        PaveTask profileForTracks;
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE) {
            return positions;
        }
        int startingY = 1;
        if (!this.getStateToPaveWith(context).method_26215()) {
            FilterItemStack filter = context.getFilterFromBE();
            if (!ItemHelper.extract((Storage<ItemVariant>)context.contraption.getSharedInventory(), stack -> filter.test(context.world, (class_1799)stack), 1, true).method_7960()) {
                startingY = 0;
            }
        }
        if ((profileForTracks = this.createHeightProfileForTracks(context)) != null) {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                boolean shouldPlaceSlab;
                float height = profileForTracks.get(coords);
                class_2338 targetPosition = new class_2338((double)((Integer)coords.getFirst()).intValue(), (double)height, (double)((Integer)coords.getSecond()).intValue());
                boolean bl = shouldPlaceSlab = (double)height > Math.floor(height) + 0.45;
                if (startingY == 1 && shouldPlaceSlab && context.world.method_8320(targetPosition.method_10084()).method_28500((class_2769)class_2482.field_11501).orElse(class_2771.field_12682) == class_2771.field_12681) {
                    startingY = 2;
                }
                for (int i = startingY; i <= (shouldPlaceSlab ? 3 : 2); ++i) {
                    if (!this.testBreakerTarget(context, targetPosition.method_10086(i), i)) continue;
                    positions.add(targetPosition.method_10086(i));
                }
            }
            return positions;
        }
        for (int i = startingY; i <= 2; ++i) {
            if (!this.testBreakerTarget(context, visitedPos.method_10086(i), i)) continue;
            positions.add(visitedPos.method_10086(i));
        }
        return positions;
    }

    protected boolean testBreakerTarget(MovementContext context, class_2338 target, int columnY) {
        class_2680 stateToPaveWith = this.getStateToPaveWith(context);
        class_2680 stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        class_2680 stateAbove = context.world.method_8320(target);
        if (columnY == 0 && stateAbove.method_27852(stateToPaveWith.method_26204())) {
            return false;
        }
        if (stateToPaveWithAsSlab != null && columnY == 1 && stateAbove.method_27852(stateToPaveWithAsSlab.method_26204())) {
            return false;
        }
        return this.canBreak(context.world, target, stateAbove);
    }

    @Nullable
    protected PaveTask createHeightProfileForTracks(MovementContext context) {
        if (context.contraption == null) {
            return null;
        }
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return null;
        }
        Train train = carriage.train;
        if (train == null || train.graph == null) {
            return null;
        }
        CarriageBogey mainBogey = (CarriageBogey)carriage.bogeys.getFirst();
        TravellingPoint point = mainBogey.trailing();
        this.rollerScout.node1 = point.node1;
        this.rollerScout.node2 = point.node2;
        this.rollerScout.edge = point.edge;
        this.rollerScout.position = point.position;
        class_2350.class_2351 axis = class_2350.class_2351.field_11048;
        class_3499.class_3501 info = context.contraption.getBlocks().get(class_2338.field_10980);
        if (info != null && info.field_15596.method_28498((class_2769)StandardBogeyBlock.AXIS)) {
            axis = (class_2350.class_2351)info.field_15596.method_11654((class_2769)StandardBogeyBlock.AXIS);
        }
        class_2350 orientation = cce.getInitialOrientation();
        class_2350 rollerFacing = (class_2350)context.state.method_11654((class_2769)RollerBlock.field_11177);
        int step = orientation.method_10171().method_10181();
        double widthWiseOffset = axis.method_10173(-context.localPos.method_10260(), 0, -context.localPos.method_10263()) * step;
        double lengthWiseOffset = axis.method_10173(-context.localPos.method_10263(), 0, context.localPos.method_10260()) * step - 1;
        if (rollerFacing == orientation.method_10170()) {
            lengthWiseOffset += 1.0;
        }
        double distanceToTravel = 2.0;
        PaveTask heightProfile = new PaveTask(widthWiseOffset, widthWiseOffset);
        TravellingPoint.ITrackSelector steering = this.rollerScout.steer(TravellingPoint.SteerDirection.NONE, new class_243(0.0, 1.0, 0.0));
        this.rollerScout.traversalCallback = (edge, coords) -> {};
        this.rollerScout.travel(train.graph, lengthWiseOffset + 1.0, steering);
        this.rollerScout.traversalCallback = (edge, coords) -> {
            if (edge == null) {
                return;
            }
            if (edge.isInterDimensional()) {
                return;
            }
            if (edge.node1.getLocation().dimension != context.world.method_27983()) {
                return;
            }
            TrackPaverV2.pave(heightProfile, train.graph, edge, (Double)coords.getFirst(), (Double)coords.getSecond());
        };
        this.rollerScout.travel(train.graph, distanceToTravel, steering);
        for (Couple<Integer> entry : heightProfile.keys()) {
            heightProfile.put((Integer)entry.getFirst(), (Integer)entry.getSecond(), (float)context.localPos.method_10264() + heightProfile.get(entry));
        }
        return heightProfile;
    }

    protected void triggerPaver(MovementContext context, class_2338 pos) {
        class_2680 stateToPaveWith = this.getStateToPaveWith(context);
        class_2680 stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE && stateToPaveWith.method_26215()) {
            return;
        }
        class_243 directionVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)RollerBlock.field_11177)).method_10170().method_10163());
        directionVec = (class_243)context.rotation.apply(directionVec);
        PaveResult paveResult = PaveResult.PASS;
        int yOffset = 0;
        ArrayList<Pair<class_2338, Boolean>> paveSet = new ArrayList<Pair<class_2338, Boolean>>();
        PaveTask profileForTracks = this.createHeightProfileForTracks(context);
        if (profileForTracks == null) {
            paveSet.add(Pair.of(pos, false));
        } else {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                float f = profileForTracks.get(coords);
                boolean shouldPlaceSlab = (double)f > Math.floor(f) + 0.45;
                class_2338 class_23382 = new class_2338((double)((Integer)coords.getFirst()).intValue(), (double)f, (double)((Integer)coords.getSecond()).intValue());
                paveSet.add(Pair.of(class_23382, shouldPlaceSlab));
            }
        }
        if (paveSet.isEmpty()) {
            return;
        }
        while (paveResult == PaveResult.PASS) {
            boolean bl;
            if (yOffset > (Integer)AllConfigs.server().kinetics.rollerFillDepth.get()) {
                paveResult = PaveResult.FAIL;
                break;
            }
            HashSet<Pair<class_2338, Boolean>> currentLayer = new HashSet<Pair<class_2338, Boolean>>();
            if (mode == RollerBlockEntity.RollingMode.WIDE_FILL) {
                for (Pair pair : paveSet) {
                    int radius = (yOffset + 1) / 2;
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            if (class_2338.field_10980.method_19455((class_2382)new class_2338(i, 0, j)) > radius) continue;
                            currentLayer.add(Pair.of(((class_2338)pair.getFirst()).method_10069(i, -yOffset, j), (Boolean)pair.getSecond()));
                        }
                    }
                }
            } else {
                for (Pair pair : paveSet) {
                    currentLayer.add(Pair.of(((class_2338)pair.getFirst()).method_10087(yOffset), (Boolean)pair.getSecond()));
                }
            }
            boolean completelyBlocked = true;
            boolean bl2 = false;
            for (Pair pair : currentLayer) {
                if (stateToPaveWithAsSlab != null && yOffset == 0 && ((Boolean)pair.getSecond()).booleanValue()) {
                    this.tryFill(context, ((class_2338)pair.getFirst()).method_10084(), stateToPaveWithAsSlab);
                }
                if ((paveResult = this.tryFill(context, (class_2338)pair.getFirst(), stateToPaveWith)) != PaveResult.FAIL) {
                    completelyBlocked = false;
                }
                if (paveResult != PaveResult.SUCCESS) continue;
                bl = true;
            }
            if (bl) {
                paveResult = PaveResult.SUCCESS;
            } else if (!completelyBlocked || yOffset == 0) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult == PaveResult.SUCCESS && stateToPaveWith.method_26204() instanceof class_2346) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult != PaveResult.PASS || mode == RollerBlockEntity.RollingMode.TUNNEL_PAVE) break;
            ++yOffset;
        }
        if (paveResult == PaveResult.SUCCESS) {
            context.data.method_10569("WaitingTicks", 2);
            context.data.method_10566("LastPos", (class_2520)class_2512.method_10692((class_2338)pos));
            context.stall = true;
        }
    }

    public static class_2680 getStateToPaveWith(class_1799 itemStack) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 bi = (class_1747)class_17922;
            class_2680 defaultBlockState = bi.method_7711().method_9564();
            if (defaultBlockState.method_28498((class_2769)class_2482.field_11501)) {
                defaultBlockState = (class_2680)defaultBlockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682);
            }
            return defaultBlockState;
        }
        return class_2246.field_10124.method_9564();
    }

    protected class_2680 getStateToPaveWith(MovementContext context) {
        return RollerMovementBehaviour.getStateToPaveWith(class_1799.method_7915((class_2487)context.blockEntityData.method_10562("Filter")));
    }

    protected class_2680 getStateToPaveWithAsSlab(MovementContext context) {
        class_2680 stateToPaveWith = this.getStateToPaveWith(context);
        if (stateToPaveWith.method_28498((class_2769)class_2482.field_11501)) {
            return (class_2680)stateToPaveWith.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        }
        class_2248 block = stateToPaveWith.method_26204();
        if (block == null) {
            return null;
        }
        class_2960 rl = block.getRegistryName();
        String namespace = rl.method_12836();
        String blockName = rl.method_12832();
        int nameLength = blockName.length();
        ArrayList<CallSite> possibleSlabLocations = new ArrayList<CallSite>();
        possibleSlabLocations.add((CallSite)((Object)(blockName + "_slab")));
        if (blockName.endsWith("s") && nameLength > 1) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 1) + "_slab")));
        }
        if (blockName.endsWith("planks") && nameLength > 7) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 7) + "_slab")));
        }
        for (String string : possibleSlabLocations) {
            class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25105, (class_2960)new class_2960(namespace, string));
            Optional<class_2248> result = class_2378.field_11146.method_40264(key).map(slabHolder -> (class_2248)slabHolder.comp_349());
            if (result.isEmpty()) continue;
            return result.get().method_9564();
        }
        return null;
    }

    protected RollerBlockEntity.RollingMode getMode(MovementContext context) {
        return RollerBlockEntity.RollingMode.values()[context.blockEntityData.method_10550("ScrollValue")];
    }

    protected PaveResult tryFill(MovementContext context, class_2338 targetPos, class_2680 toPlace) {
        class_1937 level = context.world;
        if (!level.method_8477(targetPos)) {
            return PaveResult.FAIL;
        }
        class_2680 existing = level.method_8320(targetPos);
        if (existing.method_27852(toPlace.method_26204())) {
            return PaveResult.PASS;
        }
        if (!(existing.method_26164(class_3481.field_15503) || existing.method_26207().method_15800() || existing.method_26220((class_1922)level, targetPos).method_1110())) {
            return PaveResult.FAIL;
        }
        FilterItemStack filter = context.getFilterFromBE();
        class_1799 held = ItemHelper.extract((Storage<ItemVariant>)context.contraption.getSharedInventory(), stack -> filter.test(context.world, (class_1799)stack), 1, false);
        if (held.method_7960()) {
            return PaveResult.FAIL;
        }
        level.method_8501(targetPos, toPlace);
        return PaveResult.SUCCESS;
    }

    private final class RollerTravellingPoint
    extends TravellingPoint {
        public BiConsumer<TrackEdge, Couple<Double>> traversalCallback;

        private RollerTravellingPoint() {
        }

        @Override
        protected Double edgeTraversedFrom(TrackGraph graph, boolean forward, TravellingPoint.IEdgePointListener edgePointListener, TravellingPoint.ITurnListener turnListener, double prevPos, double totalDistance) {
            double from = forward ? prevPos : this.position;
            double to = forward ? this.position : prevPos;
            this.traversalCallback.accept(this.edge, Couple.create(from, to));
            return super.edgeTraversedFrom(graph, forward, edgePointListener, turnListener, prevPos, totalDistance);
        }
    }

    private static enum PaveResult {
        FAIL,
        PASS,
        SUCCESS;

    }
}

