/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.psi;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlockEntity;
import io.github.fabricators_of_create.porting_lib.transfer.WrappedStorage;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTransferable;
import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class PortableFluidInterfaceBlockEntity
extends PortableStorageInterfaceBlockEntity
implements FluidTransferable {
    protected InterfaceFluidHandler capability = this.createEmptyHandler();

    public PortableFluidInterfaceBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void startTransferringTo(Contraption contraption, float distance) {
        this.capability.setWrapped((Storage<FluidVariant>)contraption.getSharedFluidTanks());
        super.startTransferringTo(contraption, distance);
    }

    @Override
    protected void invalidateCapability() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
    }

    @Override
    protected void stopTransferring() {
        this.capability.setWrapped((Storage<FluidVariant>)Storage.empty());
        super.stopTransferring();
    }

    private InterfaceFluidHandler createEmptyHandler() {
        return new InterfaceFluidHandler((Storage<FluidVariant>)Storage.empty());
    }

    public Storage<FluidVariant> getFluidStorage(@Nullable class_2350 face) {
        return this.capability;
    }

    public class InterfaceFluidHandler
    extends WrappedStorage<FluidVariant> {
        public InterfaceFluidHandler(Storage<FluidVariant> wrapped) {
            super(wrapped);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFluidInterfaceBlockEntity.this.isConnected()) {
                return 0L;
            }
            long fill = this.wrapped.insert((Object)resource, maxAmount, transaction);
            if (fill > 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return fill;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!PortableFluidInterfaceBlockEntity.this.canTransfer()) {
                return 0L;
            }
            long drain = this.wrapped.extract((Object)resource, maxAmount, transaction);
            if (drain != 0L) {
                TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            }
            return drain;
        }

        @Nullable
        public StorageView<FluidVariant> exactView(TransactionContext transaction, FluidVariant resource) {
            TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            return super.exactView(transaction, (Object)resource);
        }

        public Iterator<? extends StorageView<FluidVariant>> iterator(TransactionContext transaction) {
            TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            return super.iterator(transaction);
        }

        public Iterable<? extends StorageView<FluidVariant>> iterable(TransactionContext transaction) {
            TransactionCallback.onSuccess((TransactionContext)transaction, this::keepAlive);
            return super.iterable(transaction);
        }

        public void keepAlive() {
            PortableFluidInterfaceBlockEntity.this.onContentTransferred();
        }

        private void setWrapped(Storage<FluidVariant> wrapped) {
            this.wrapped = wrapped;
        }
    }
}

