/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.harvester;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterActorInstance;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterRenderer;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.util.IPlantable;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2523;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_4597;
import net.minecraft.class_4863;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class HarvesterMovementBehaviour
implements MovementBehaviour {
    @Override
    public boolean isActive(MovementContext context) {
        return MovementBehaviour.super.isActive(context) && !VecHelper.isVecPointingTowards(context.relativeMotion, ((class_2350)context.state.method_11654((class_2769)HarvesterBlock.field_11177)).method_10153());
    }

    @Override
    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Override
    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new HarvesterActorInstance(materialManager, simulationWorld, context);
    }

    @Override
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffers) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            HarvesterRenderer.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    @Override
    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)HarvesterBlock.field_11177)).method_10163()).method_1021(0.45);
    }

    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        class_1937 world = context.world;
        class_2680 stateVisited = world.method_8320(pos);
        boolean notCropButCuttable = false;
        if (world.field_9236) {
            return;
        }
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        class_1799 item = class_1799.field_8037;
        float effectChance = 1.0f;
        if (stateVisited.method_26164(class_3481.field_15503)) {
            item = new class_1799((class_1935)class_1802.field_8868);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        class_2680 state = stateVisited;
        BlockHelper.destroyBlockAs(world, pos, null, item, effectChance, stack -> {
            if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !seedSubtracted.getValue().booleanValue() && stack.method_7962(new class_1799((class_1935)state.method_26204()))) {
                stack.method_7934(1);
                seedSubtracted.setTrue();
            }
            if (!stack.method_7960()) {
                this.dropItem(context, (class_1799)stack);
            }
        });
        class_2680 cutCrop = this.cutCrop(world, pos, stateVisited);
        world.method_8501(pos, cutCrop.method_26184((class_4538)world, pos) ? cutCrop : class_2246.field_10124.method_9564());
    }

    public boolean isValidCrop(class_1937 world, class_2338 pos, class_2680 state) {
        boolean harvestPartial = (Boolean)AllConfigs.server().kinetics.harvestPartiallyGrown.get();
        boolean replant = (Boolean)AllConfigs.server().kinetics.harvesterReplants.get();
        if (state.method_26204() instanceof class_2302) {
            class_2302 crop = (class_2302)state.method_26204();
            if (harvestPartial) {
                return (Integer)state.method_11654((class_2769)crop.method_9824()) != 0 || !replant;
            }
            return crop.method_9825(state);
        }
        if (state.method_26220((class_1922)world, pos).method_1110() || state.method_26204() instanceof class_2282) {
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758)) continue;
                class_2758 ageProperty = (class_2758)property;
                if (!property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                int age = (Integer)state.method_11654((class_2769)ageProperty);
                if (state.method_26204() instanceof class_3830 && age <= 1 && replant || age == 0 && replant || !harvestPartial && ageProperty.method_11898().size() - 1 != age) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidOther(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() instanceof class_2302) {
            return false;
        }
        if (state.method_26204() instanceof class_2523) {
            return true;
        }
        if (state.method_26164(class_3481.field_15503)) {
            return true;
        }
        if (state.method_26204() instanceof class_2282) {
            return (Integer)state.method_11654((class_2769)class_2282.field_10779) == 2;
        }
        if (state.method_26220((class_1922)world, pos).method_1110()) {
            if (state.method_26204() instanceof class_4863) {
                return true;
            }
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758) || !property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                return false;
            }
            if (state.method_26204() instanceof IPlantable) {
                return true;
            }
        }
        return false;
    }

    private class_2680 cutCrop(class_1937 world, class_2338 pos, class_2680 state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.method_26227().method_15769()) {
                return class_2246.field_10124.method_9564();
            }
            return state.method_26227().method_15759();
        }
        class_2248 block = state.method_26204();
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            return crop.method_9828(0);
        }
        if (block == class_2246.field_16999) {
            return (class_2680)state.method_11657((class_2769)class_2741.field_12497, (Comparable)Integer.valueOf(1));
        }
        if (block == class_2246.field_10424 || block instanceof class_4863) {
            if (state.method_26227().method_15769()) {
                return class_2246.field_10124.method_9564();
            }
            return state.method_26227().method_15759();
        }
        if (state.method_26220((class_1922)world, pos).method_1110() || block instanceof class_2282) {
            for (class_2769 property : state.method_28501()) {
                if (!(property instanceof class_2758) || !property.method_11899().equals(class_2741.field_12521.method_11899())) continue;
                return (class_2680)state.method_11657((class_2769)((class_2758)property), (Comparable)Integer.valueOf(0));
            }
        }
        if (state.method_26227().method_15769()) {
            return class_2246.field_10124.method_9564();
        }
        return state.method_26227().method_15759();
    }
}

