/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.contraptionControls;

import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionDisableActorPacket;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.behaviour.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.elevator.ElevatorTargetFloorPacket;
import com.simibubi.create.foundation.utility.AdventureUtil;
import java.util.Iterator;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import me.pepperbell.simplenetworking.S2CPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContraptionControlsMovingInteraction
extends MovingInteractionBehaviour {
    @Override
    public boolean handlePlayerInteraction(class_1657 player, class_1268 activeHand, class_2338 localPos, AbstractContraptionEntity contraptionEntity) {
        if (AdventureUtil.isAdventure(player)) {
            return false;
        }
        Contraption contraption = contraptionEntity.getContraption();
        MutablePair<class_3499.class_3501, MovementContext> actor = contraption.getActorAt(localPos);
        if (actor == null) {
            return false;
        }
        MovementContext ctx = (MovementContext)actor.right;
        if (ctx == null) {
            return false;
        }
        if (contraption instanceof ElevatorContraption) {
            ElevatorContraption ec = (ElevatorContraption)contraption;
            return this.elevatorInteraction(localPos, contraptionEntity, ec, ctx);
        }
        if (contraptionEntity.field_6002.method_8608()) {
            class_2586 class_25862 = contraption.presentBlockEntities.get(ctx.localPos);
            if (class_25862 instanceof ContraptionControlsBlockEntity) {
                ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)class_25862;
                cbe.pressButton();
            }
            return true;
        }
        class_1799 filter = ContraptionControlsMovement.getFilter(ctx);
        boolean disable = true;
        boolean invert = false;
        List<class_1799> disabledActors = contraption.getDisabledActors();
        Iterator<class_1799> iterator = disabledActors.iterator();
        while (iterator.hasNext()) {
            class_1799 presentFilter = iterator.next();
            boolean sameFilter = ContraptionControlsMovement.isSameFilter(presentFilter, filter);
            if (presentFilter.method_7960()) {
                iterator.remove();
                disable = false;
                if (sameFilter) continue;
                invert = true;
                continue;
            }
            if (!sameFilter) continue;
            iterator.remove();
            disable = false;
            break;
        }
        if (invert) {
            for (MutablePair<class_3499.class_3501, MovementContext> pair : contraption.getActors()) {
                class_1799 behaviourStack;
                MovementBehaviour behaviour = AllMovementBehaviours.getBehaviour(((class_3499.class_3501)pair.left).field_15596);
                if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)pair.right)) == null || ContraptionControlsMovement.isSameFilter(behaviourStack, filter) || contraption.isActorTypeDisabled(behaviourStack)) continue;
                disabledActors.add(behaviourStack);
                this.send(contraptionEntity, behaviourStack, true);
            }
        }
        if (filter.method_7960()) {
            disabledActors.clear();
        }
        if (disable) {
            disabledActors.add(filter);
        }
        contraption.setActorsActive(filter, !disable);
        ContraptionControlsBlockEntity.sendStatus(player, filter, !disable);
        this.send(contraptionEntity, filter, disable);
        AllSoundEvents.CONTROLLER_CLICK.play(player.field_6002, null, (class_2382)new class_2338(contraptionEntity.toGlobalVector(class_243.method_24953((class_2382)localPos), 1.0f)), 1.0f, disable ? 0.8f : 1.5f);
        return true;
    }

    private void send(AbstractContraptionEntity contraptionEntity, class_1799 filter, boolean disable) {
        AllPackets.getChannel().sendToClientsTracking((S2CPacket)new ContraptionDisableActorPacket(contraptionEntity.method_5628(), filter, !disable), (class_1297)contraptionEntity);
    }

    private boolean elevatorInteraction(class_2338 localPos, AbstractContraptionEntity contraptionEntity, ElevatorContraption contraption, MovementContext ctx) {
        if (!contraptionEntity.field_6002.method_8608()) {
            class_2338 pos = new class_2338(contraptionEntity.toGlobalVector(class_243.method_24953((class_2382)localPos), 1.0f));
            AllSoundEvents.CONTROLLER_CLICK.play(contraptionEntity.field_6002, null, (class_2382)pos, 1.0f, 1.5f);
            AllSoundEvents.CONTRAPTION_ASSEMBLE.play(contraptionEntity.field_6002, null, (class_2382)pos, 0.75f, 0.8f);
            return true;
        }
        Object object = ctx.temporaryData;
        if (!(object instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
            return false;
        }
        ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)object;
        if (efs.currentTargetY == contraption.clientYTarget) {
            return true;
        }
        AllPackets.getChannel().sendToServer((C2SPacket)new ElevatorTargetFloorPacket(contraptionEntity, efs.currentTargetY));
        Object v = contraption.presentBlockEntities.get(ctx.localPos);
        if (v instanceof ContraptionControlsBlockEntity) {
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)v;
            cbe.pressButton();
        }
        return true;
    }
}

