/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.contraptionControls;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.DyeHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class ContraptionControlsBlockEntity
extends SmartBlockEntity {
    public FilteringBehaviour filtering;
    public boolean disabled;
    public boolean powered;
    public LerpedFloat indicator = LerpedFloat.angular().startWithValue(0.0);
    public LerpedFloat button = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.125, LerpedFloat.Chaser.EXP);

    public ContraptionControlsBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new ControlsSlot());
        behaviours.add(this.filtering);
        this.filtering.setLabel(Lang.translateDirect("contraptions.contoller.target", new Object[0]));
        this.filtering.withPredicate(AllTags.AllItemTags.CONTRAPTION_CONTROLLED::matches);
    }

    public void pressButton() {
        this.button.setValue(1.0);
    }

    public void updatePoweredState() {
        if (this.field_11863.method_8608()) {
            return;
        }
        boolean powered = this.field_11863.method_8479(this.field_11867);
        if (this.powered == powered) {
            return;
        }
        this.powered = powered;
        this.disabled = powered;
        this.notifyUpdate();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updatePoweredState();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.field_11863.method_8608()) {
            return;
        }
        this.tickAnimations();
        int value = this.disabled ? 180 : 0;
        this.indicator.setValue(value);
        this.indicator.updateChaseTarget(value);
    }

    public void tickAnimations() {
        this.button.tickChaser();
        this.indicator.tickChaser();
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.disabled = tag.method_10577("Disabled");
        this.powered = tag.method_10577("Powered");
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.method_10556("Disabled", this.disabled);
        tag.method_10556("Powered", this.powered);
    }

    public static void sendStatus(class_1657 player, class_1799 filter, boolean enabled) {
        class_5250 state = Lang.translate("contraption.controls.actor_toggle." + (enabled ? "on" : "off"), new Object[0]).color((Integer)DyeHelper.DYE_TABLE.get(enabled ? class_1767.field_7961 : class_1767.field_7946).getFirst()).component();
        if (filter.method_7960()) {
            Lang.translate("contraption.controls.all_actor_toggle", state).sendStatus(player);
            return;
        }
        Lang.translate("contraption.controls.specific_actor_toggle", filter.method_7964().getString(), state).sendStatus(player);
    }

    public static class ControlsSlot
    extends ValueBoxTransform.Sided {
        @Override
        public class_243 getLocalOffset(class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ControlsBlock.field_11177);
            float yRot = AngleHelper.horizontalAngle(facing);
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8.0, 12.0, 5.5), yRot, class_2350.class_2351.field_11052);
        }

        @Override
        public void rotate(class_2680 state, class_4587 ms) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)ControlsBlock.field_11177);
            float yRot = AngleHelper.horizontalAngle(facing);
            ((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)(yRot + 180.0f))).rotateX(67.5);
        }

        @Override
        public float getScale() {
            return 0.508f;
        }

        @Override
        protected class_243 getSouthLocation() {
            return class_243.field_1353;
        }
    }
}

