/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.rt.api.util;

import io.github.null2264.shadowed.manifold.util.JreUtil;
import io.github.null2264.shadowed.manifold.util.ReflectUtil;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;

public class ServiceUtil {
    public static <C> Set<C> loadRegisteredServices(Set<C> services, Class<C> serviceClass, ClassLoader classLoader) {
        C service2;
        Iterator<C> iterator2;
        ServiceLoader<C> loader = ServiceLoader.load(serviceClass);
        try {
            ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(loader, serviceClass, null);
            iterator2 = loader.iterator();
            while (iterator2.hasNext()) {
                try {
                    service2 = iterator2.next();
                    if (!ServiceUtil.isAbsent(services, service2)) continue;
                    services.add(service2);
                }
                catch (ServiceConfigurationError service2) {}
            }
        }
        catch (UnsupportedClassVersionError iterator2) {
            // empty catch block
        }
        if (Thread.currentThread().getContextClassLoader() != classLoader) {
            loader = ServiceLoader.load(serviceClass, classLoader);
            ServiceUtil.hackServiceLoaderToHandleProxyFactoryForJpms(loader, serviceClass, classLoader);
            iterator2 = loader.iterator();
            while (iterator2.hasNext()) {
                try {
                    service2 = iterator2.next();
                    if (!ServiceUtil.isAbsent(services, service2)) continue;
                    services.add(service2);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {}
            }
        }
        return services;
    }

    private static <C> void hackServiceLoaderToHandleProxyFactoryForJpms(ServiceLoader<C> serviceLoader, Class<?> serviceClass, ClassLoader classLoader) {
        if (!JreUtil.isJava9Modular_runtime() || !serviceClass.getSimpleName().equals("IProxyFactory_gen")) {
            return;
        }
        ReflectUtil.field(serviceLoader, "lookupIterator1").set(ReflectUtil.constructor("io.github.null2264.shadowed.manifold.util.LazyClassPathLookupIterator", Class.class, ClassLoader.class).newInstance(serviceClass, classLoader == null ? ReflectUtil.field(serviceLoader, "loader").get() : classLoader));
    }

    static <C> boolean isAbsent(Set<C> services, C service) {
        for (C existingSp : services) {
            if (!existingSp.getClass().equals(service.getClass())) continue;
            return false;
        }
        return true;
    }
}

