/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.shadowed.manifold.rt.api.util;

import io.github.null2264.shadowed.manifold.rt.api.util.ManStringUtil;
import io.github.null2264.shadowed.manifold.rt.api.util.ReservedWordMapping;

public class ManIdentifierUtil {
    public static String makeIdentifier(String name) {
        String identifier = ReservedWordMapping.getIdentifierForName(name);
        if (!identifier.equals(name)) {
            return identifier;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (sb.length() == 0 && Character.isWhitespace(c)) continue;
            if (i == 0 && c >= '0' && c <= '9') {
                sb.append('_').append(c);
                continue;
            }
            if (c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        identifier = ManIdentifierUtil.makeCorrections(sb);
        return identifier;
    }

    public static String makePascalCaseIdentifier(String name, boolean firstChar) {
        return ManStringUtil.toPascalCase(ManIdentifierUtil.makeIdentifier(name).toLowerCase(), !firstChar);
    }

    private static String makeCorrections(StringBuilder sb) {
        String identifier = sb.toString();
        if (ManIdentifierUtil.isAllUnderscores(identifier)) {
            identifier = "_" + identifier.length();
        }
        return identifier;
    }

    private static boolean isAllUnderscores(String result) {
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) == '_') continue;
            return false;
        }
        return true;
    }
}

