/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.network;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.extensions.net.minecraft.network.FriendlyByteBuf.ByteBufExt;
import io.github.null2264.cobblegen.network.payload.CGPacketPayload;
import io.github.null2264.cobblegen.network.payload.CGPayloadReader;
import io.github.null2264.cobblegen.network.payload.CGPingC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGPingS2CPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncC2SPayload;
import io.github.null2264.cobblegen.network.payload.CGSyncS2CPayload;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_634;
import org.jetbrains.annotations.ApiStatus;

public class CGClientPlayNetworkHandler {
    public static boolean handlePacket(class_634 listener, class_2658 packet) {
        CGIdentifier id = CGIdentifier.fromMC(packet.method_11456());
        class_2540 packetData = packet.method_11458();
        CGPayloadReader reader = (CGPayloadReader)Constants.KNOWN_CLIENT_PAYLOADS.get((Object)id);
        if (reader == null) {
            return false;
        }
        CGPacketPayload payload = (CGPacketPayload)reader.apply(packetData);
        if (payload instanceof CGSyncS2CPayload) {
            Boolean isReload = ((CGSyncS2CPayload)payload).isReload();
            CobbleGen.FLUID_INTERACTION.readGeneratorsFromPayload((CGSyncS2CPayload)payload);
            boolean isSync = CobbleGen.FLUID_INTERACTION.isSync();
            if (isSync) {
                CGLog.info("CobbleGen config has been", isReload != false ? "re-synced" : "retrieved from the server");
            }
            CGSyncC2SPayload newPayload = new CGSyncC2SPayload(isSync);
            listener.method_2883((class_2596)CGClientPlayNetworkHandler.createC2SPacket(newPayload));
            return true;
        }
        if (payload instanceof CGPingS2CPayload) {
            CGPingC2SPayload newPayload = new CGPingC2SPayload(((CGPingS2CPayload)payload).reload(), Util.isAnyRecipeViewerLoaded());
            listener.method_2883((class_2596)CGClientPlayNetworkHandler.createC2SPacket(newPayload));
            return true;
        }
        return false;
    }

    public static void onDisconnect() {
        CobbleGen.FLUID_INTERACTION.disconnect();
    }

    @ApiStatus.Internal
    private static class_2817 createC2SPacket(CGPacketPayload payload) {
        class_2540 buf = ByteBufExt.unpooled();
        payload.write(buf);
        return new class_2817(payload.id(), buf);
    }

    static {
        IBootstrap.dasBoot();
    }
}

