/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.rei;

import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.integration.viewer.rei.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class FluidInteractionCategory
implements DisplayCategory<FluidInteractionRecipe> {
    public static String ID_PREFIX;
    private final Renderer icon;
    private final GeneratorType type;
    private final int initialHeight;

    public FluidInteractionCategory(GeneratorType generatorType) {
        this.initialHeight = generatorType.equals((Object)GeneratorType.STONE) ? 56 : 36;
        class_1799 iconStack = class_1802.field_8162.method_7854();
        switch (generatorType) {
            case COBBLE: {
                iconStack = class_1802.field_20412.method_7854();
                break;
            }
            case STONE: {
                iconStack = class_1802.field_20391.method_7854();
                break;
            }
            case BASALT: {
                iconStack = class_1802.field_22000.method_7854();
            }
        }
        this.icon = EntryStacks.of((class_1799)iconStack);
        this.type = generatorType;
    }

    public static CategoryIdentifier<? extends FluidInteractionRecipe> generateIdentifier(GeneratorType type) {
        return CategoryIdentifier.of((class_2960)Util.identifierOf(ID_PREFIX + type.name().toLowerCase()));
    }

    public int getDisplayHeight() {
        return this.initialHeight + 6 + 18 + 20 + 9 + 6 + 2;
    }

    public class_2561 getTitle() {
        return TextCompat.translatable("cobblegen.generators." + this.type.name().toLowerCase());
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public List<Widget> setupDisplay(FluidInteractionRecipe display, Rectangle bounds) {
        Integer maxY;
        int offset = 18;
        int gap = 2;
        int gapAgainstBound = 6;
        Rectangle base = bounds.clone();
        base.resize(18, 18);
        base.translate(6, 6);
        Rectangle cold = base.clone();
        Rectangle lava = base.clone();
        lava.x += 40;
        Rectangle result = base.clone();
        result.x += 20;
        Rectangle resultMod = result.clone();
        resultMod.y += 20;
        if (this.type == GeneratorType.STONE) {
            lava.x -= 20;
            cold.y += 20;
            result.y = resultMod.y;
            resultMod.y += 20;
        }
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createSlot((Rectangle)lava).entries((Collection)display.getInputEntries().get(0)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)cold).entries((Collection)display.getInputEntries().get(1)).markInput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)result).entries((Collection)display.getOutputEntries().get(0)).markOutput().disableBackground());
        widgets.add((Widget)Widgets.createSlot((Rectangle)resultMod).entry((EntryStack)display.getInputEntries().get(2).get(0)).markInput().disableBackground());
        class_310 minecraft = class_310.method_1551();
        Integer minY = display.getResult().minY;
        if (minY == null) {
            minY = minecraft.field_1687 != null ? minecraft.field_1687.method_31607() : 0;
        }
        if ((maxY = display.getResult().maxY) == null) {
            maxY = minecraft.field_1687 != null ? minecraft.field_1687.method_31600() : 256;
        }
        List<class_5250> texts = List.of(TextCompat.translatable("cobblegen.info.weight").method_10852(class_2561.method_30163((String)display.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").method_10852(class_2561.method_30163((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").method_10852(class_2561.method_30163((String)maxY.toString())));
        int y = base.y;
        for (class_2561 class_25612 : texts) {
            Point labelPoint = new Point(bounds.x + this.getDisplayWidth(display) - 6, y);
            Label label = Widgets.createLabel((Point)labelPoint, (class_2561)class_25612).rightAligned().noShadow().color(-12566464, -4473925);
            widgets.add((Widget)label);
            y += 9;
        }
        class_5250 text = TextCompat.translatable("cobblegen.info.dimensions");
        Point point = new Point(bounds.getCenterX(), resultMod.y + 18 + 9);
        widgets.add((Widget)Widgets.createLabel((Point)point, (class_2561)text).centered().noShadow().color(-12566464, -4473925));
        Rectangle dimensionBounds = base.clone();
        dimensionBounds.resize(15, 20);
        dimensionBounds.y = point.y + 18;
        Rectangle whitelistBounds = dimensionBounds.clone();
        whitelistBounds.x += 18;
        Widget whitelistIcon = Widgets.createTexturedWidget((class_2960)Constants.JEI_UI_COMPONENT.toMC(), (Rectangle)whitelistBounds, (float)0.0f, (float)0.0f, (int)256, (int)256);
        ArrayList<class_5250> whitelist = new ArrayList<class_5250>();
        whitelist.add(TextCompat.translatable("cobblegen.info.whitelistedDim"));
        List<String> recipeWhitelist = display.getResult().dimensions;
        try {
            for (String dim : recipeWhitelist) {
                class_2960 id = new class_2960(dim);
                whitelist.add(TextCompat.literal("- " + id));
            }
        }
        catch (NullPointerException ignored) {
            whitelist.add(TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.any")));
        }
        widgets.add((Widget)Widgets.withTooltip((WidgetWithBounds)Widgets.withBounds((Widget)whitelistIcon, (Rectangle)whitelistBounds), whitelist));
        Rectangle blacklistBounds = dimensionBounds.clone();
        blacklistBounds.x += bounds.width - 15 - 18 - 12;
        Widget blacklistIcon = Widgets.createTexturedWidget((class_2960)Constants.JEI_UI_COMPONENT.toMC(), (Rectangle)blacklistBounds, (float)15.0f, (float)0.0f, (int)256, (int)256);
        ArrayList<class_5250> blacklist = new ArrayList<class_5250>();
        blacklist.add(TextCompat.translatable("cobblegen.info.blacklistedDim"));
        List<String> recipeBlacklist = display.getResult().excludedDimensions;
        try {
            for (String dim : recipeBlacklist) {
                class_2960 id = new class_2960(dim);
                blacklist.add(TextCompat.literal("- " + id));
            }
        }
        catch (NullPointerException ignored) {
            blacklist.add(TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.none")));
        }
        widgets.add((Widget)Widgets.withTooltip((WidgetWithBounds)Widgets.withBounds((Widget)blacklistIcon, (Rectangle)blacklistBounds), blacklist));
        return widgets;
    }

    public CategoryIdentifier<? extends FluidInteractionRecipe> getCategoryIdentifier() {
        return FluidInteractionCategory.generateIdentifier(this.type);
    }

    static {
        IBootstrap.dasBoot();
        ID_PREFIX = "fluid_interaction_";
    }
}

