/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.jei;

import io.github.null2264.cobblegen.compat.GraphicsCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class FluidInteractionCategory
implements IRecipeCategory<FluidInteractionRecipeHolder> {
    private final IDrawable background;
    private final Long full;
    private final IDrawable icon;
    private final GeneratorType type;
    private final int initialHeight;
    private final IDrawable whitelistIcon;
    private final IDrawable blacklistIcon;
    private int dimensionIconsY = 0;

    public FluidInteractionCategory(IGuiHelper guiHelper, IPlatformFluidHelper<?> fluidHelper, GeneratorType generatorType) {
        this.initialHeight = generatorType.equals((Object)GeneratorType.STONE) ? 56 : 36;
        this.background = guiHelper.createBlankDrawable(136, this.initialHeight + 18 + 20 + 9);
        this.full = 10L * fluidHelper.bucketVolume();
        class_1799 iconStack = class_1802.field_8162.method_7854();
        switch (generatorType) {
            case COBBLE: {
                iconStack = class_1802.field_20412.method_7854();
                break;
            }
            case STONE: {
                iconStack = class_1802.field_20391.method_7854();
                break;
            }
            case BASALT: {
                iconStack = class_1802.field_22000.method_7854();
            }
        }
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)iconStack);
        this.type = generatorType;
        this.whitelistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 0, 0, 15, 20).build();
        this.blacklistIcon = guiHelper.drawableBuilder(Constants.JEI_UI_COMPONENT.toMC(), 15, 0, 15, 20).build();
    }

    @NotNull
    public RecipeType<FluidInteractionRecipeHolder> getRecipeType() {
        return new RecipeType(Util.identifierOf(this.type), FluidInteractionRecipeHolder.class);
    }

    @NotNull
    public class_2561 getTitle() {
        return TextCompat.translatable("cobblegen.generators." + this.type.name().toLowerCase());
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidInteractionRecipeHolder recipe, IFocusGroup focuses) {
        WeightedBlock output = recipe.getResult();
        class_2248 modifier = recipe.getModifier();
        class_3611 source = recipe.getSourceFluid();
        class_3611 neighbourFluid = recipe.getNeighbourFluid();
        class_2248 neighbourBlock = recipe.getNeighbourBlock();
        int offset = 18;
        int x = 0;
        int y = 0;
        int gap = 2;
        int coldY = y;
        int lavaX = x + 40;
        int resultX = x + 18 + 2;
        int resultY = y;
        int resultModY = y + 18 + 2;
        if (this.type.equals((Object)GeneratorType.STONE)) {
            lavaX = x + 18 + 2;
            coldY = y + 18 + 2;
            resultY = resultModY;
            resultModY = resultModY + 18 + 2;
        }
        IRecipeSlotBuilder coldBuilder = builder.addSlot(RecipeIngredientRole.INPUT, x, coldY);
        if (this.type.equals((Object)GeneratorType.BASALT)) {
            coldBuilder.addItemStack(neighbourBlock.method_8389().method_7854());
        } else {
            coldBuilder.addFluidStack(neighbourFluid, this.full.longValue());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, lavaX, y).addFluidStack(source, this.full.longValue());
        builder.addSlot(RecipeIngredientRole.OUTPUT, resultX, resultY).addItemStack(output.getBlock().method_8389().method_7854());
        builder.addSlot(RecipeIngredientRole.INPUT, resultX, resultModY).addItemStack(modifier.method_8389().method_7854());
    }

    public void draw(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, class_4587 graphicsTarget, double mouseX, double mouseY) {
        int n;
        Integer maxY;
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        Integer minY = recipe.getResult().minY;
        if (minY == null) {
            minY = minecraft.field_1687 != null ? minecraft.field_1687.method_31607() : 0;
        }
        if ((maxY = recipe.getResult().maxY) == null) {
            maxY = minecraft.field_1687 != null ? minecraft.field_1687.method_31600() : 256;
        }
        List<class_5250> texts = List.of(TextCompat.translatable("cobblegen.info.weight").method_10852(class_2561.method_30163((String)recipe.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").method_10852(class_2561.method_30163((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").method_10852(class_2561.method_30163((String)maxY.toString())));
        int y = 0;
        for (class_2561 class_25612 : texts) {
            int width = font.method_27525((class_5348)class_25612);
            GraphicsCompat.drawString(graphicsTarget, class_25612, this.getBackground().getWidth() - width, y, -8355712);
            Objects.requireNonNull(font);
            y += 9;
        }
        class_5250 text = TextCompat.translatable("cobblegen.info.dimensions");
        int n2 = this.initialHeight + 9;
        GraphicsCompat.drawString(graphicsTarget, (class_2561)text, (int)((float)this.getBackground().getWidth() / 2.0f - (float)font.method_27525((class_5348)text) / 2.0f), n2, -8355712);
        Objects.requireNonNull(font);
        this.dimensionIconsY = n = n2 + 9 + 9;
        this.whitelistIcon.draw(graphicsTarget, 18, n);
        this.blacklistIcon.draw(graphicsTarget, this.getBackground().getWidth() - 15 - 18, n);
    }

    @NotNull
    public List<class_2561> getTooltipStrings(FluidInteractionRecipeHolder recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 18.0 && mouseX < 33.0 && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<class_2561> biomeList = new ArrayList<class_2561>();
            biomeList.add((class_2561)TextCompat.translatable("cobblegen.info.whitelistedDim"));
            List<String> recipeDimList = recipe.getResult().dimensions;
            try {
                for (String dim : recipeDimList) {
                    class_2960 id = new class_2960(dim);
                    biomeList.add((class_2561)TextCompat.literal("- " + id));
                }
            }
            catch (NullPointerException ignored) {
                biomeList.add((class_2561)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.any")));
            }
            return biomeList;
        }
        int aetherX = this.getBackground().getWidth() - 18;
        if (mouseX > (double)(aetherX - 15) && mouseX < (double)aetherX && mouseY > (double)this.dimensionIconsY && mouseY < (double)(this.dimensionIconsY + 20)) {
            ArrayList<class_2561> biomeList = new ArrayList<class_2561>();
            biomeList.add((class_2561)TextCompat.translatable("cobblegen.info.blacklistedDim"));
            List<String> recipeDimList = recipe.getResult().excludedDimensions;
            try {
                for (String dim : recipeDimList) {
                    class_2960 id = new class_2960(dim);
                    biomeList.add((class_2561)TextCompat.literal("- " + id));
                }
            }
            catch (NullPointerException ignored) {
                biomeList.add((class_2561)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.none")));
            }
            return biomeList;
        }
        return List.of();
    }

    @Deprecated
    @NotNull
    public class_2960 getUid() {
        return Util.identifierOf("fluid_interaction");
    }

    @Deprecated
    @NotNull
    public Class<? extends FluidInteractionRecipeHolder> getRecipeClass() {
        return FluidInteractionRecipeHolder.class;
    }

    static {
        IBootstrap.dasBoot();
    }
}

