/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.FluidInteractionRecipeHolder;
import io.github.null2264.cobblegen.integration.viewer.emi.CGEMIPlugin;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class FluidInteractionRecipe
extends FluidInteractionRecipeHolder
implements EmiRecipe {
    private final int initialHeight;

    public FluidInteractionRecipe(class_3611 sourceFluid, class_3611 neighbourFluid, class_2248 neighbourBlock, WeightedBlock result, GeneratorType type, class_2248 modifier) {
        super(sourceFluid, neighbourFluid, neighbourBlock, result, type, modifier);
        this.initialHeight = type.equals((Object)GeneratorType.STONE) ? 56 : 36;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return this.initialHeight + 18 + 20 + 9 + 2;
    }

    public EmiRecipeCategory getCategory() {
        return CGEMIPlugin.FLUID_INTERACTION_CATEGORIES.get(this.getType().name());
    }

    public List<EmiIngredient> getInputs() {
        EmiStack source = EmiStack.of((class_3611)this.getSourceFluid(), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
        EmiStack neighbour = EmiStack.of((class_3611)this.getNeighbourFluid(), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
        return List.of(source.copy().setRemainder(source), this.getType().equals((Object)GeneratorType.BASALT) ? EmiStack.of((class_1935)this.getNeighbourBlock()) : neighbour.copy().setRemainder(neighbour), EmiStack.of((class_1935)this.getModifier()));
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((class_1935)this.getResult().getBlock()));
    }

    public void addWidgets(WidgetHolder widgets) {
        Integer maxY;
        int offset = 18;
        int gap = 2;
        Point base = new Point(0, 0);
        Point cold = (Point)base.clone();
        Point lava = (Point)base.clone();
        lava.x += 40;
        Point result = (Point)base.clone();
        result.x += 20;
        Point resultMod = (Point)result.clone();
        resultMod.y += 20;
        if (this.getType() == GeneratorType.STONE) {
            lava.x -= 20;
            cold.y += 20;
            result.y = resultMod.y;
            resultMod.y += 20;
        }
        widgets.addSlot(this.getInputs().get(0), lava.x, lava.y).catalyst(true);
        widgets.addSlot(this.getInputs().get(1), cold.x, cold.y).catalyst(true);
        widgets.addSlot((EmiIngredient)this.getOutputs().get(0), result.x, result.y).recipeContext((EmiRecipe)this);
        widgets.addSlot(this.getInputs().get(2), resultMod.x, resultMod.y).catalyst(true);
        class_310 minecraft = class_310.method_1551();
        class_327 textRenderer = minecraft.field_1772;
        Integer minY = this.getResult().minY;
        if (minY == null) {
            minY = minecraft.field_1687 != null ? minecraft.field_1687.method_31607() : 0;
        }
        if ((maxY = this.getResult().maxY) == null) {
            maxY = minecraft.field_1687 != null ? minecraft.field_1687.method_31600() : 256;
        }
        List<class_5250> texts = List.of(TextCompat.translatable("cobblegen.info.weight").method_10852(class_2561.method_30163((String)this.getResult().weight.toString())), TextCompat.translatable("cobblegen.info.minY").method_10852(class_2561.method_30163((String)minY.toString())), TextCompat.translatable("cobblegen.info.maxY").method_10852(class_2561.method_30163((String)maxY.toString())));
        int y = base.y;
        for (class_2561 class_25612 : texts) {
            Point labelPoint = new Point(this.getDisplayWidth() - textRenderer.method_27525((class_5348)class_25612), y);
            widgets.addText(class_25612, labelPoint.x, labelPoint.y, -1, true);
            y += 9;
        }
        class_5250 text = TextCompat.translatable("cobblegen.info.dimensions");
        Point point = new Point(this.getDisplayWidth() / 2 - textRenderer.method_27525((class_5348)text) / 2, resultMod.y + 18 + 9);
        widgets.addText((class_2561)text, point.x, point.y, -1, true);
        Point dimensionBounds = (Point)base.clone();
        dimensionBounds.y = point.y + 18;
        Point whitelistBounds = (Point)dimensionBounds.clone();
        whitelistBounds.x += 18;
        ArrayList<class_5684> whitelist = new ArrayList<class_5684>();
        whitelist.add(class_5684.method_32662((class_5481)TextCompat.translatable("cobblegen.info.whitelistedDim").method_30937()));
        List<String> recipeWhitelist = this.getResult().dimensions;
        try {
            for (String dim : recipeWhitelist) {
                class_2960 id = new class_2960(dim);
                whitelist.add(class_5684.method_32662((class_5481)TextCompat.literal("- " + id).method_30937()));
            }
        }
        catch (NullPointerException ignored) {
            whitelist.add(class_5684.method_32662((class_5481)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.any")).method_30937()));
        }
        widgets.addTexture(Constants.JEI_UI_COMPONENT.toMC(), whitelistBounds.x, whitelistBounds.y, 15, 20, 0, 0).tooltip((mouseX, mouseY) -> whitelist);
        Point blacklistBounds = (Point)dimensionBounds.clone();
        blacklistBounds.x += this.getDisplayWidth() - 15 - 18;
        ArrayList<class_5684> blacklist = new ArrayList<class_5684>();
        blacklist.add(class_5684.method_32662((class_5481)TextCompat.translatable("cobblegen.info.blacklistedDim").method_30937()));
        List<String> recipeBlacklist = this.getResult().excludedDimensions;
        try {
            for (String dim : recipeBlacklist) {
                class_2960 id = new class_2960(dim);
                blacklist.add(class_5684.method_32662((class_5481)TextCompat.literal("- " + id).method_30937()));
            }
        }
        catch (NullPointerException ignored) {
            blacklist.add(class_5684.method_32662((class_5481)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.none")).method_30937()));
        }
        widgets.addTexture(Constants.JEI_UI_COMPONENT.toMC(), blacklistBounds.x, blacklistBounds.y, 15, 20, 15, 0).tooltip((mouseX, mouseY) -> blacklist);
    }

    public class_2960 getId() {
        class_2960 resultId = new class_2960(this.getResult().id);
        class_2960 source = Util.getFluidId(this.getSourceFluid());
        class_2960 neighbour = this.getNeighbourBlock().equals(class_2246.field_10124) ? Util.getFluidId(this.getNeighbourFluid()) : Util.getBlockId(this.getNeighbourBlock());
        class_2960 modifierId = Util.identifierOf("none");
        if (!this.getModifier().equals(class_2246.field_10124)) {
            modifierId = Util.getBlockId(this.getModifier());
        }
        return Util.identifierOf("fluid_interaction_" + this.getType().name().toLowerCase() + "-" + source.method_36181() + "-" + resultId.method_36181() + "-" + neighbour.method_36181() + "-" + modifierId.method_36181());
    }

    static {
        IBootstrap.dasBoot();
    }
}

