/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration.viewer.emi;

import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.compat.TextCompat;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.integration.viewer.emi.FluidInteractionRecipe;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class CGEMIPlugin
implements EmiPlugin {
    public static final String ID_PREFIX = "fluid_interaction_";
    public static final Map<String, EmiRecipeCategory> FLUID_INTERACTION_CATEGORIES;

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst);
        } else {
            recipe.leftInput(input);
        }
    }

    private void input(EmiWorldInteractionRecipe.Builder recipe, EmiIngredient input, boolean catalyst, Function<SlotWidget, SlotWidget> mutator, InputPosition position) {
        if (position.equals((Object)InputPosition.RIGHT)) {
            recipe.rightInput(input, catalyst, mutator);
        } else {
            recipe.leftInput(input, mutator);
        }
    }

    public void register(EmiRegistry registry) {
        if (!CobbleGen.META_CONFIG.enableRecipeViewer.booleanValue()) {
            return;
        }
        if (!CobbleGen.META_CONFIG.mergeEMIRecipeCategory.booleanValue()) {
            FLUID_INTERACTION_CATEGORIES.forEach((ignored, category) -> registry.addCategory(category));
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                class_2248 modifier = null;
                if (!modifierId.isWildcard()) {
                    modifier = Util.getBlock(modifierId.toMC());
                }
                for (WeightedBlock block : blocks) {
                    registry.addRecipe((EmiRecipe)new FluidInteractionRecipe((class_3611)fluid, Util.notNullOr(generator.getFluid(), class_3612.field_15906), Util.notNullOr(generator.getBlock(), class_2246.field_10124), block, generator.getType(), Util.notNullOr(modifier, class_2246.field_10124)));
                }
            })));
        } else {
            class_310 minecraft = class_310.method_1551();
            CobbleGen.FLUID_INTERACTION.getGenerators().forEach((fluid, generators) -> generators.forEach(generator -> generator.getOutput().forEach((modifierId, blocks) -> {
                EmiStack trigger = EmiStack.of((class_3611)fluid, (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                Optional<Object> modifier = Optional.empty();
                if (!modifierId.isWildcard()) {
                    modifier = Optional.of(Util.getBlock(modifierId.toMC()));
                }
                for (WeightedBlock block : blocks) {
                    EmiStack neighbourRemainder;
                    EmiStack neighbour;
                    class_2960 neighbourId;
                    class_2960 resultId = new class_2960(block.id);
                    EmiStack output = EmiStack.of((class_1935)Util.getBlock(resultId));
                    class_2960 source = Util.getFluidId(fluid);
                    if (generator.getFluid() == null) {
                        neighbourId = Util.getBlockId(generator.getBlock());
                        neighbour = EmiStack.of((class_1935)((class_1935)Objects.requireNonNull(generator.getBlock())));
                    } else {
                        neighbourId = Util.getFluidId(generator.getFluid());
                        neighbour = EmiStack.of((class_3611)Objects.requireNonNull(generator.getFluid()), (long)(LoaderCompat.isForge() != false ? 1000L : 81000L));
                    }
                    if (CobbleGen.META_CONFIG.emi.removeOverlaps.booleanValue()) {
                        registry.removeRecipes(r -> new HashSet(r.getInputs()).containsAll(List.of(neighbour, trigger)) && r.getOutputs().contains(output) && r.getId().toString().startsWith("emi"));
                    }
                    class_2960 id = Util.identifierOf(ID_PREFIX + generator.getType().name().toLowerCase() + "-" + source.method_36181() + "-" + resultId.method_36181() + "-" + neighbourId.method_36181() + "-" + modifierId.toDebugFileName());
                    EmiWorldInteractionRecipe.Builder recipe = EmiWorldInteractionRecipe.builder().id(id);
                    this.input(recipe, (EmiIngredient)trigger.copy().setRemainder(trigger), false, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.RIGHT : InputPosition.LEFT);
                    EmiStack emiStack = neighbourRemainder = neighbour.isEmpty() ? neighbour : neighbour.copy().setRemainder(neighbour);
                    if (modifier.isPresent()) {
                        this.input(recipe, (EmiIngredient)EmiStack.of((class_1935)((class_1935)modifier.get())), false, s -> s.appendTooltip((class_2561)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil").method_27692(class_124.field_1060)), CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, s -> generator.getBlock() != null ? s.appendTooltip((class_2561)TextCompat.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice").method_27692(class_124.field_1060)) : s, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    } else {
                        this.input(recipe, (EmiIngredient)neighbourRemainder, false, CobbleGen.META_CONFIG.emi.invertInput != false ? InputPosition.LEFT : InputPosition.RIGHT);
                    }
                    recipe.output(output, s -> {
                        Integer maxY;
                        if (!CobbleGen.META_CONFIG.emi.addTooltip.booleanValue()) {
                            return s;
                        }
                        Integer minY = block.minY;
                        if (minY == null) {
                            minY = minecraft.field_1687 != null ? minecraft.field_1687.method_31607() : 0;
                        }
                        if ((maxY = block.maxY) == null) {
                            maxY = minecraft.field_1687 != null ? minecraft.field_1687.method_31600() : 256;
                        }
                        s.appendTooltip((class_2561)TextCompat.translatable("cobblegen.info.weight").method_10852(class_2561.method_30163((String)block.weight.toString())));
                        s.appendTooltip((class_2561)TextCompat.translatable("cobblegen.info.minY").method_10852(class_2561.method_30163((String)minY.toString())));
                        s.appendTooltip((class_2561)TextCompat.translatable("cobblegen.info.maxY").method_10852(class_2561.method_30163((String)maxY.toString())));
                        s.appendTooltip((class_2561)TextCompat.translatable("cobblegen.info.blacklistedDim").method_27692(class_124.field_1060));
                        List<String> recipeBlacklist = block.excludedDimensions;
                        try {
                            for (String string : recipeBlacklist) {
                                class_2960 dimId = new class_2960(string);
                                s.appendTooltip((class_2561)TextCompat.literal("- " + dimId));
                            }
                        }
                        catch (NullPointerException ignored) {
                            s.appendTooltip((class_2561)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.none")));
                        }
                        s.appendTooltip((class_2561)TextCompat.translatable("cobblegen.info.whitelistedDim").method_27692(class_124.field_1060));
                        List<String> recipeWhitelist = block.dimensions;
                        try {
                            for (String dim : recipeWhitelist) {
                                class_2960 dimId = new class_2960(dim);
                                s.appendTooltip((class_2561)TextCompat.literal("- " + dimId));
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            s.appendTooltip((class_2561)TextCompat.literal("- ").method_10852((class_2561)TextCompat.translatable("cobblegen.dim.any")));
                        }
                        return s;
                    });
                    registry.addRecipe((EmiRecipe)recipe.build());
                }
            })));
        }
    }

    static {
        IBootstrap.dasBoot();
        FLUID_INTERACTION_CATEGORIES = Map.of("COBBLE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_cobble"), (EmiRenderable)EmiStack.of((class_1935)class_2246.field_10445)), "STONE", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_stone"), (EmiRenderable)EmiStack.of((class_1935)class_2246.field_10340)), "BASALT", new EmiRecipeCategory(Util.identifierOf("fluid_interaction_basalt"), (EmiRenderable)EmiStack.of((class_1935)class_2246.field_22091)));
    }

    static enum InputPosition {
        LEFT,
        RIGHT;


        static {
            IBootstrap.dasBoot();
        }
    }
}

