/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.integration;

import io.github.null2264.cobblegen.CGPlugin;
import io.github.null2264.cobblegen.CobbleGenPlugin;
import io.github.null2264.cobblegen.compat.LoaderCompat;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.ConfigData;
import io.github.null2264.cobblegen.data.config.ConfigHelper;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.generator.BasaltGenerator;
import io.github.null2264.cobblegen.data.generator.CobbleGenerator;
import io.github.null2264.cobblegen.data.generator.StoneGenerator;
import io.github.null2264.cobblegen.data.model.BlockGenerator;
import io.github.null2264.cobblegen.data.model.CGRegistry;
import io.github.null2264.cobblegen.util.CGLog;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

@CGPlugin
public class BuiltInPlugin
implements CobbleGenPlugin {
    private static final Path configPath;
    private static final File configFile;
    @Nullable
    private static ConfigData config;
    private boolean isReload = false;

    private class_3611 getFluidFromString(String string) {
        return Util.getFluid(new class_2960(string));
    }

    private class_2248 getBlockFromString(String string) {
        return Util.getBlock(new class_2960(string));
    }

    @Override
    public void registerInteraction(CGRegistry registry) {
        CGLog.info((!this.isReload ? "L" : "Rel") + "oading config...", new String[0]);
        if (config == null || this.isReload) {
            config = ConfigHelper.loadConfig(this.isReload, configFile, config, ConfigData.defaultConfig(), ConfigData.class);
        }
        if (config == null) {
            throw new RuntimeException("How?");
        }
        AtomicInteger count = new AtomicInteger();
        GeneratorMap stoneGen = new GeneratorMap();
        if (BuiltInPlugin.config.customGen != null && BuiltInPlugin.config.customGen.stoneGen != null) {
            stoneGen = BuiltInPlugin.config.customGen.stoneGen;
        }
        GeneratorMap cobbleGen = new GeneratorMap();
        if (BuiltInPlugin.config.customGen != null && BuiltInPlugin.config.customGen.cobbleGen != null) {
            cobbleGen = BuiltInPlugin.config.customGen.cobbleGen;
        }
        GeneratorMap basaltGen = new GeneratorMap();
        if (BuiltInPlugin.config.customGen != null && BuiltInPlugin.config.customGen.basaltGen != null) {
            basaltGen = BuiltInPlugin.config.customGen.basaltGen;
        }
        stoneGen.put(CGIdentifier.wildcard(), Util.notNullOr(BuiltInPlugin.config.stoneGen, new ResultList()));
        cobbleGen.put(CGIdentifier.wildcard(), Util.notNullOr(BuiltInPlugin.config.cobbleGen, new ResultList()));
        basaltGen.put(CGIdentifier.fromBlock(class_2246.field_22090), Util.notNullOr(BuiltInPlugin.config.basaltGen, new ResultList()));
        if (BuiltInPlugin.config.advanced != null) {
            BuiltInPlugin.config.advanced.forEach((fluid, value) -> {
                class_3611 actualFluid = this.getFluidFromString((String)fluid);
                value.forEach((neighbour, gen) -> {
                    GeneratorMap results = gen.results;
                    GeneratorMap obi = gen.obsidian;
                    boolean isNeighbourBlock = neighbour.startsWith("b:");
                    if (isNeighbourBlock) {
                        neighbour = neighbour.substring(2);
                    }
                    if (gen.resultsFromTop != null && !gen.resultsFromTop.isEmpty()) {
                        registry.addGenerator(actualFluid, new StoneGenerator(gen.resultsFromTop, this.getFluidFromString((String)neighbour), (boolean)gen.silent));
                        count.getAndIncrement();
                    }
                    if (!results.isEmpty()) {
                        BlockGenerator generator = isNeighbourBlock ? new BasaltGenerator(results, this.getBlockFromString((String)neighbour), (boolean)gen.silent) : new CobbleGenerator(results, this.getFluidFromString((String)neighbour), (boolean)gen.silent, obi);
                        registry.addGenerator(actualFluid, generator);
                        count.getAndIncrement();
                    }
                });
            });
        }
        registry.addGenerator((class_3611)class_3612.field_15908, new StoneGenerator(stoneGen, (class_3611)class_3612.field_15910, false));
        registry.addGenerator((class_3611)class_3612.field_15908, new CobbleGenerator(cobbleGen, (class_3611)class_3612.field_15910, false, GeneratorMap.of(new Pair[0])));
        registry.addGenerator((class_3611)class_3612.field_15908, new BasaltGenerator(basaltGen, class_2246.field_10384, false));
        count.addAndGet(3);
        CGLog.info(String.valueOf(count.get()), "generators has been added from config");
        if (this.isReload) {
            this.isReload = false;
        }
    }

    @Override
    public void onReload() {
        CGLog.info("Reloading built-in plugin...", new String[0]);
        this.isReload = true;
    }

    static {
        IBootstrap.dasBoot();
        configPath = LoaderCompat.getConfigDir();
        configFile = new File(configPath + File.separator + "cobblegen.json5");
        config = null;
    }
}

