/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.generator;

import io.github.null2264.cobblegen.CobbleGen;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.ConfigMetaData;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.cobblegen.data.model.BlockGenerator;
import io.github.null2264.cobblegen.data.model.Generator;
import io.github.null2264.cobblegen.util.GeneratorType;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CobbleGenerator
extends BlockGenerator {
    private final GeneratorMap possibleBlocks;
    private final GeneratorMap obsidianReplacements;
    private class_3611 fluid;
    private final boolean silent;

    public CobbleGenerator(ResultList possibleBlocks, class_3611 fluid, boolean silent) {
        this(possibleBlocks, fluid, silent, GeneratorMap.of(new Pair[0]));
    }

    public CobbleGenerator(ResultList possibleBlocks, class_3611 fluid, boolean silent, GeneratorMap obsidianReplacements) {
        this(GeneratorMap.of(Pair.of(CGIdentifier.wildcard(), possibleBlocks)), fluid, silent, obsidianReplacements);
    }

    public CobbleGenerator(GeneratorMap possibleBlocks, class_3611 fluid, boolean silent, GeneratorMap obsidianReplacements) {
        this.possibleBlocks = possibleBlocks;
        this.obsidianReplacements = obsidianReplacements;
        this.fluid = fluid;
        this.silent = silent;
    }

    public static CobbleGenerator fromString(Map<String, List<WeightedBlock>> possibleBlocks, class_3611 fluid, boolean silent, Map<String, List<WeightedBlock>> obsidianReplacements) {
        GeneratorMap map1 = new GeneratorMap();
        possibleBlocks.forEach((k, v) -> map1.put(CGIdentifier.of(k), new ResultList((List<WeightedBlock>)v)));
        GeneratorMap map2 = new GeneratorMap();
        obsidianReplacements.forEach((k, v) -> map2.put(CGIdentifier.of(k), new ResultList((List<WeightedBlock>)v)));
        return new CobbleGenerator(map1, fluid, silent, map2);
    }

    @Override
    @NotNull
    public GeneratorMap getOutput() {
        return this.possibleBlocks;
    }

    @Override
    public GeneratorMap getObsidianOutput() {
        return this.obsidianReplacements;
    }

    @Override
    @NotNull
    public GeneratorType getType() {
        return GeneratorType.COBBLE;
    }

    @Override
    public class_3611 getFluid() {
        return this.fluid;
    }

    @Override
    public void setFluid(class_3611 fluid) {
        this.fluid = fluid;
    }

    @Override
    @Nullable
    public class_2248 getBlock() {
        return null;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    @Override
    public Optional<class_2680> tryGenerate(class_1936 level, class_2338 pos, class_2680 state, class_2350 direction) {
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        return this.tryGenerate(level, pos, state.method_26227(), level.method_8316(blockPos));
    }

    @Override
    public Optional<class_2680> tryGenerate(class_1936 level, class_2338 pos, class_3610 source, class_3610 neighbour) {
        if (Generator.getStillFluid(neighbour) == this.getFluid()) {
            if (source.method_15772() == class_3612.field_15908 && source.method_15771()) {
                if (Util.optional(CobbleGen.META_CONFIG).orElse((ConfigMetaData)new ConfigMetaData()).enableExperimentalFeatures.booleanValue()) {
                    return this.getBlockCandidate(level, pos, this.getObsidianOutput(), class_2246.field_10540);
                }
                return Optional.of(class_2246.field_10540.method_9564());
            }
            return this.getBlockCandidate(level, pos, this.getOutput());
        }
        return Optional.empty();
    }

    @Override
    public void toPacket(class_2540 buf) {
        buf.method_10814(this.getClass().getName());
        buf.method_10812(Util.getFluidId(this.fluid));
        buf.writeBoolean(this.silent);
        this.getOutput().toPacket(buf);
        this.getObsidianOutput().toPacket(buf);
    }

    public static Generator fromPacket(class_2540 buf) {
        class_3611 fluid = Util.getFluid(buf.method_10810());
        boolean silent = buf.readBoolean();
        GeneratorMap outMap = GeneratorMap.fromPacket(buf);
        GeneratorMap obiMap = GeneratorMap.fromPacket(buf);
        return new CobbleGenerator(outMap, fluid, silent, obiMap);
    }

    static {
        IBootstrap.dasBoot();
    }
}

