/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.model.PacketSerializable;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.jankson.JsonArray;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.JsonPrimitive;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WeightedBlock
implements PacketSerializable<WeightedBlock>,
JanksonSerializable {
    public String id;
    public Double weight;
    @Nullable
    public List<String> dimensions;
    @Nullable
    public List<String> excludedDimensions;
    @Nullable
    public Integer maxY;
    @Nullable
    public Integer minY;
    @Nullable
    public List<String> neighbours;

    public WeightedBlock(String id, Double weight) {
        this(id, weight, null, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds) {
        this(id, weight, dimIds, null);
    }

    public WeightedBlock(String id, Double weight, List<String> dimIds, List<String> excludedDimensions) {
        this(id, weight, dimIds, excludedDimensions, null, null, null);
    }

    public WeightedBlock(String id, Double weight, @Nullable List<String> dimIds, @Nullable List<String> excludedDimensions, @Nullable Integer maxY, @Nullable Integer minY, @Nullable List<String> neighbours) {
        this.id = id;
        this.weight = weight;
        this.dimensions = dimIds;
        this.excludedDimensions = excludedDimensions;
        this.maxY = maxY;
        this.minY = minY;
        this.neighbours = neighbours;
    }

    public static WeightedBlock fromBlock(class_2248 block, Double weight) {
        return WeightedBlock.fromBlock(block, weight, null, null, null, null);
    }

    public Optional<List<String>> getDimensions() {
        return Util.optional(this.dimensions);
    }

    public static WeightedBlock fromBlock(class_2248 block, Double weight, List<String> dimIds, List<String> excludedDimensions, Integer maxY, Integer minY) {
        String id = Util.getBlockId(block).toString();
        return new WeightedBlock(id, weight, dimIds, excludedDimensions, maxY, minY, null);
    }

    public class_2248 getBlock() {
        return Util.getBlock(class_2960.method_12829((String)this.id));
    }

    public Optional<List<String>> getExcludedDimensions() {
        return Util.optional(this.excludedDimensions);
    }

    public Optional<Integer> getMaxY() {
        return Util.optional(this.maxY);
    }

    public Optional<Integer> getMinY() {
        return Util.optional(this.minY);
    }

    @Override
    public void toPacket(class_2540 buf) {
        buf.method_10814(this.id);
        buf.writeDouble(this.weight.doubleValue());
        buf.method_37435(Util.optional(this.dimensions), (o, value) -> o.method_34062((Collection)value, class_2540::method_10814));
        buf.method_37435(Util.optional(this.excludedDimensions), (o, value) -> o.method_34062((Collection)value, class_2540::method_10814));
        buf.method_37435(Util.optional(this.maxY), class_2540::writeInt);
        buf.method_37435(Util.optional(this.minY), class_2540::writeInt);
    }

    public static WeightedBlock fromPacket(class_2540 buf) {
        String id = buf.method_19772();
        Double weight = buf.readDouble();
        Optional dimensions = buf.method_37436(o -> o.method_34066(class_2540::method_19772));
        Optional excludedDimensions = buf.method_37436(o -> o.method_34066(class_2540::method_19772));
        Optional maxY = buf.method_37436(class_2540::readInt);
        Optional minY = buf.method_37436(class_2540::readInt);
        return new WeightedBlock(id, weight, dimensions.orElse(null), excludedDimensions.orElse(null), maxY.orElse(null), minY.orElse(null), null);
    }

    @Override
    @Serializer
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("id", JsonPrimitive.of(this.id));
        json.put("weight", JsonPrimitive.of(this.weight));
        json.put("dimensions", Constants.JANKSON.toJson(this.dimensions));
        json.put("excludedDimensions", Constants.JANKSON.toJson(this.excludedDimensions));
        json.put("maxY", Constants.JANKSON.toJson(this.maxY));
        json.put("minY", Constants.JANKSON.toJson(this.minY));
        return json;
    }

    @Deserializer
    public static WeightedBlock fromJson(JsonObject json) {
        ArrayList<String> excludedDimensions;
        ArrayList<String> dimensions;
        JsonElement _id = json.get("id");
        if (!(_id instanceof JsonPrimitive)) {
            return null;
        }
        String id = ((JsonPrimitive)_id).asString();
        Double weight = json.getDouble("weight", 0.0);
        if (json.get("dimensions") instanceof JsonArray) {
            JsonArray _dimensions = (JsonArray)json.get("dimensions");
            dimensions = new ArrayList<String>();
            _dimensions.forEach(value -> dimensions.add(((JsonPrimitive)value).asString()));
        } else {
            dimensions = null;
        }
        if (json.get("excludedDimensions") instanceof JsonArray) {
            JsonArray _excludedDimensions = (JsonArray)json.get("excludedDimensions");
            excludedDimensions = new ArrayList<String>();
            _excludedDimensions.forEach(value -> excludedDimensions.add(((JsonPrimitive)value).asString()));
        } else {
            excludedDimensions = null;
        }
        Integer maxY = null;
        if (json.get("maxY") instanceof JsonPrimitive) {
            JsonPrimitive _maxY = (JsonPrimitive)json.get("maxY");
            maxY = _maxY.asInt(0);
        }
        Integer minY = null;
        if (json.get("minY") instanceof JsonPrimitive) {
            JsonPrimitive _minY = (JsonPrimitive)json.get("minY");
            minY = _minY.asInt(0);
        }
        return new WeightedBlock(id, weight, dimensions, excludedDimensions, maxY, minY, null);
    }

    static {
        IBootstrap.dasBoot();
    }
}

