/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.util.Constants;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import org.jetbrains.annotations.Nullable;

public class CustomGen
implements JanksonSerializable {
    @Nullable
    public GeneratorMap cobbleGen;
    @Nullable
    public GeneratorMap stoneGen;
    @Nullable
    public GeneratorMap basaltGen;

    public CustomGen(@Nullable GeneratorMap cobbleGen, @Nullable GeneratorMap stoneGen, @Nullable GeneratorMap basaltGen) {
        this.cobbleGen = cobbleGen;
        this.stoneGen = stoneGen;
        this.basaltGen = basaltGen;
    }

    @Override
    @Serializer
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.cobbleGen != null) {
            json.put("cobbleGen", this.cobbleGen.toJson());
        }
        if (this.stoneGen != null) {
            json.put("stoneGen", Constants.JANKSON.toJson(this.stoneGen));
        }
        if (this.basaltGen != null) {
            json.put("basaltGen", Constants.JANKSON.toJson(this.basaltGen));
        }
        return json;
    }

    @Deserializer
    public static CustomGen fromJson(JsonObject json) {
        if (json == null) {
            return null;
        }
        GeneratorMap cobbleGen = GeneratorMap.fromJson(json.getObject("cobbleGen"));
        GeneratorMap stoneGen = GeneratorMap.fromJson(json.getObject("stoneGen"));
        GeneratorMap basaltGen = GeneratorMap.fromJson(json.getObject("basaltGen"));
        return new CustomGen(cobbleGen, stoneGen, basaltGen);
    }

    static {
        IBootstrap.dasBoot();
    }
}

