/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data.config;

import io.github.null2264.cobblegen.compat.CollectionCompat;
import io.github.null2264.cobblegen.data.CGIdentifier;
import io.github.null2264.cobblegen.data.JanksonSerializable;
import io.github.null2264.cobblegen.data.Pair;
import io.github.null2264.cobblegen.data.config.Config;
import io.github.null2264.cobblegen.data.config.CustomGen;
import io.github.null2264.cobblegen.data.config.FluidInteractionMap;
import io.github.null2264.cobblegen.data.config.GeneratorMap;
import io.github.null2264.cobblegen.data.config.ResultList;
import io.github.null2264.cobblegen.data.config.WeightedBlock;
import io.github.null2264.shadowed.jankson.Comment;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonObject;
import io.github.null2264.shadowed.jankson.JsonPrimitive;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigData
implements Config,
JanksonSerializable {
    @Comment(value="CobbleGen Format Version, you can leave this alone for now. v2.0 will be released in CobbleGen v6.0")
    @NotNull
    public String formatVersion = "1.0";
    @Comment(value="Default Generators\n{\n  \"id\": \"mod_id:block_id\",\n  \"weight\": 95.5,\n  \"dimensions\": [\n    \"mod_id:dimension_id\",\n    \"mod_id:dimension_id\"\n  ],\n  \"excludedDimensions\": [\n    \"mod_id:dimension_id\",\n    \"mod_id:dimension_id\"\n  ],\n  \"minY\": 0,\n  \"maxY\": 69\n}")
    @Nullable
    public ResultList cobbleGen;
    @Nullable
    public ResultList stoneGen;
    @Nullable
    public ResultList basaltGen;
    @Comment(value="Custom Generators\n<stoneGen|cobbleGen|basaltGen>: {\n  \"mod_id:modifier_block_id\": [\n    {\n      \"id\": \"mod_id:block_id\",\n      \"weight\": 95.5,\n      \"dimensions\": [\n        \"mod_id:dimension_id\",\n        \"mod_id:dimension_id\"\n      ],\n      \"excludedDimensions\": [\n        \"mod_id:dimension_id\",\n        \"mod_id:dimension_id\"\n      ],\n      \"minY\": 0,\n      \"maxY\": 69\n    },\n    ...\n  ]\n}")
    @Nullable
    public CustomGen customGen;
    @Nullable
    public FluidInteractionMap advanced;

    public static ConfigData defaultConfig() {
        ConfigData config = new ConfigData();
        config.cobbleGen = ResultList.of(new WeightedBlock("minecraft:cobblestone", 100.0, null, null, null, 0, null), new WeightedBlock("minecraft:cobbled_deepslate", 100.0, null, null, 0, null, null));
        config.stoneGen = ResultList.of(new WeightedBlock("minecraft:stone", 100.0));
        config.basaltGen = ResultList.of(new WeightedBlock("minecraft:basalt", 100.0));
        config.customGen = new CustomGen(GeneratorMap.of(Pair.of(CGIdentifier.of("minecraft:bedrock"), ResultList.of(new WeightedBlock("minecraft:emerald_ore", 2.0), new WeightedBlock("minecraft:diamond_ore", 5.0), new WeightedBlock("minecraft:lapis_ore", 8.0), new WeightedBlock("minecraft:gold_ore", 10.0), new WeightedBlock("minecraft:iron_ore", 15.0), new WeightedBlock("minecraft:coal_ore", 20.0), new WeightedBlock("minecraft:cobblestone", 80.0)))), GeneratorMap.of(Pair.of(CGIdentifier.of("minecraft:bedrock"), ResultList.of(new WeightedBlock("minecraft:stone", 40.0), new WeightedBlock("minecraft:diorite", 20.0), new WeightedBlock("minecraft:andesite", 20.0), new WeightedBlock("minecraft:granite", 20.0)))), GeneratorMap.of(Pair.of(CGIdentifier.of("minecraft:bedrock"), ResultList.of(new WeightedBlock("minecraft:end_stone", 100.0, CollectionCompat.listOf("minecraft:the_end")), new WeightedBlock("minecraft:blackstone", 100.0, null, CollectionCompat.listOf("minecraft:overworld"))))));
        return config;
    }

    @Override
    @Serializer
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("formatVersion", JsonPrimitive.of(this.formatVersion));
        if (this.cobbleGen != null) {
            json.put("cobbleGen", this.cobbleGen.toJson());
        }
        if (this.stoneGen != null) {
            json.put("stoneGen", this.stoneGen.toJson());
        }
        if (this.basaltGen != null) {
            json.put("basaltGen", this.basaltGen.toJson());
        }
        if (this.customGen != null) {
            json.put("customGen", this.customGen.toJson());
        }
        if (this.advanced != null) {
            json.put("advanced", this.advanced.toJson());
        }
        return json;
    }

    @Deserializer
    public static ConfigData fromJson(JsonObject json) {
        ConfigData config = new ConfigData();
        JsonElement formatVersion = json.get("formatVersion");
        config.formatVersion = formatVersion instanceof JsonPrimitive ? ((JsonPrimitive)formatVersion).asString() : "1.0";
        config.cobbleGen = ResultList.fromJson(json.get("cobbleGen"));
        config.stoneGen = ResultList.fromJson(json.get("stoneGen"));
        config.stoneGen = ResultList.fromJson(json.get("stoneGen"));
        config.customGen = CustomGen.fromJson(json.getObject("customGen"));
        config.advanced = FluidInteractionMap.fromJson(json.getObject("advanced"));
        return config;
    }

    static {
        IBootstrap.dasBoot();
    }
}

