/*
 * Decompiled with CFR 0.152.
 */
package io.github.null2264.cobblegen.data;

import io.github.null2264.cobblegen.util.Util;
import io.github.null2264.shadowed.jankson.JsonElement;
import io.github.null2264.shadowed.jankson.JsonPrimitive;
import io.github.null2264.shadowed.jankson.annotation.Deserializer;
import io.github.null2264.shadowed.jankson.annotation.Serializer;
import io.github.null2264.shadowed.manifold.rt.api.IBootstrap;
import java.util.Objects;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record CGIdentifier(String modid, String name) {
    public static CGIdentifier of(String id) {
        if (id.equals("*")) {
            return CGIdentifier.wildcard();
        }
        String[] split = id.split(":", 2);
        if (split.length < 1) {
            throw new RuntimeException("Invalid ID");
        }
        if (split.length == 1) {
            return new CGIdentifier("cobblegen", split[0]);
        }
        return new CGIdentifier(split[0], split[1]);
    }

    public static CGIdentifier wildcard() {
        return new CGIdentifier("cobblegen", "*");
    }

    public boolean isWildcard() {
        return this.name.equals("*");
    }

    @Override
    public String toString() {
        if (this.isWildcard()) {
            return "*";
        }
        return String.format("%s:%s", this.modid, this.name);
    }

    public static CGIdentifier fromMC(class_2960 location) {
        return new CGIdentifier(location.method_12836(), location.method_12832());
    }

    public class_2960 toMC() {
        if (this.isWildcard()) {
            throw new RuntimeException("Wildcard is not a valid MC ID");
        }
        return new class_2960(this.modid, this.name);
    }

    public static CGIdentifier fromBlock(class_2248 block) {
        return CGIdentifier.fromMC(Util.getBlockId(block));
    }

    public void writeToBuf(class_2540 buf) {
        buf.method_10814(this.toString());
    }

    public static CGIdentifier readFromBuf(class_2540 buf) {
        return CGIdentifier.of(buf.method_19772());
    }

    public String toDebugFileName() {
        if (this.isWildcard()) {
            return "cobblegen/wildcard";
        }
        return this.toString().replace('/', '_').replace(':', '_');
    }

    @Serializer
    public JsonElement toJson() {
        return JsonPrimitive.of(this.toString());
    }

    @Deserializer
    public static CGIdentifier fromJson(JsonPrimitive json) {
        return CGIdentifier.of(json.asString());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CGIdentifier)) {
            return false;
        }
        return this.modid().equals(((CGIdentifier)obj).modid()) && this.name().equals(((CGIdentifier)obj).name());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.modid, this.name);
    }

    static {
        IBootstrap.dasBoot();
    }
}

