/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_2586;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TweakedPeripheral<BE extends class_2586>
implements IPeripheral {
    private final String type;
    private final BE blockEntity;
    private final List<IComputerAccess> computers = new LinkedList<IComputerAccess>();

    public TweakedPeripheral(String type, @Nullable BE blockEntity) {
        this.type = type;
        this.blockEntity = blockEntity;
    }

    public void sendEvent(@Nonnull String event, Object ... arguments) {
        for (IComputerAccess pc : this.computers) {
            pc.queueEvent(event, new Object[]{pc.getAttachmentName(), arguments});
        }
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.computers.add(computer);
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.computers.removeIf(p -> p.getID() == computer.getID());
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public BE getTarget() {
        return this.blockEntity;
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other == this && other.getType().equals(this.type) && other.getTarget() == this.getTarget();
    }
}

