/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.peripherals;

import cc.tweaked_programs.cccbridge.blockEntity.SourceBlockEntity;
import cc.tweaked_programs.cccbridge.peripherals.TweakedPeripheral;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import java.util.LinkedList;
import java.util.List;

public class SourceBlockPeripheral
extends TweakedPeripheral<SourceBlockEntity> {
    private final Terminal term = new Terminal(4, 2);

    public SourceBlockPeripheral(SourceBlockEntity blockentity) {
        super("create_source", blockentity);
    }

    public void setSize(int width, int height) {
        int oldW = this.term.getWidth();
        int oldH = this.term.getHeight();
        if (oldW == width && oldH == height) {
            return;
        }
        this.term.resize(width, height);
        super.sendEvent("monitor_resize", new Object[0]);
    }

    public List<String> getContent() {
        LinkedList<String> content = new LinkedList<String>();
        for (int i = 0; i < this.term.getHeight(); ++i) {
            content.add(this.term.getLine(i).toString());
        }
        return content;
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) {
        this.term.setCursorPos(x - 1, y - 1);
    }

    @LuaFunction
    public final void write(String text) {
        this.term.write(text);
        this.term.setCursorPos(this.term.getCursorX() + text.length(), this.term.getCursorY());
    }

    @LuaFunction
    public final void scroll(int yDiff) {
        this.term.scroll(yDiff);
    }

    @LuaFunction
    public final void clear() {
        this.term.clear();
    }

    @LuaFunction
    public final void clearLine() {
        this.term.clearLine();
    }

    @LuaFunction
    public final String getLine(int y) throws LuaException {
        if (y < 1 || y > this.term.getHeight()) {
            throw new LuaException("Expected number in range 1-" + this.term.getHeight());
        }
        TextBuffer line = this.term.getLine(y - 1);
        return line.toString();
    }

    @LuaFunction
    public final Object[] getCursorPos() {
        return new Object[]{this.term.getCursorX() + 1, this.term.getCursorY() + 1};
    }

    @LuaFunction
    public final Object[] getSize() {
        return new Object[]{this.term.getWidth(), this.term.getHeight()};
    }
}

