/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import rbasamoyai.createbigcannons.CreateBigCannons;

public abstract class PropertiesTypeHandler<TYPE, PROPERTIES> {
    private final Map<TYPE, PROPERTIES> propertiesByType = new Reference2ObjectOpenHashMap();

    public final void clearForReload() {
        this.propertiesByType.clear();
    }

    public final void loadFromJson(TYPE type, class_2960 loc, JsonObject obj) throws JsonParseException {
        this.propertiesByType.put(type, this.parseJson(loc, obj));
    }

    protected abstract PROPERTIES parseJson(class_2960 var1, JsonObject var2) throws JsonParseException;

    public static <V> V getOrWarn(JsonObject obj, String key, String id, V defValue, Function<JsonElement, V> func) {
        if (!obj.has(key)) {
            CreateBigCannons.LOGGER.warn("{} is missing {} value, will be set to {}", (Object)id, (Object)key, defValue);
            return defValue;
        }
        return func.apply((JsonElement)obj.getAsJsonPrimitive(key));
    }

    public final void loadFromNetwork(TYPE type, class_2540 buf) {
        this.propertiesByType.put(type, this.readPropertiesFromNetwork(type, buf));
    }

    public final void writeToNetwork(TYPE type, class_2540 buf) {
        this.writePropertiesToNetwork(this.propertiesByType.get(type), buf);
    }

    protected abstract PROPERTIES readPropertiesFromNetwork(TYPE var1, class_2540 var2);

    protected abstract void writePropertiesToNetwork(PROPERTIES var1, class_2540 var2);

    @Nonnull
    public final PROPERTIES getPropertiesOf(TYPE type) {
        return this.propertiesByType.getOrDefault(type, this.getNoPropertiesValue());
    }

    protected abstract PROPERTIES getNoPropertiesValue();
}

