/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.SmokeShellSmokeParticleData;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;

public class SmokeEmitterEntity
extends class_1297 {
    private static final class_2940<Float> SMOKE_SIZE_X = class_2945.method_12791(SmokeEmitterEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SMOKE_SIZE_Y = class_2945.method_12791(SmokeEmitterEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SMOKE_SIZE_Z = class_2945.method_12791(SmokeEmitterEntity.class, (class_2941)class_2943.field_13320);
    protected int duration;
    protected int age;

    public SmokeEmitterEntity(class_1299<? extends SmokeEmitterEntity> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693() {
        this.field_6011.method_12784(SMOKE_SIZE_X, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SMOKE_SIZE_Y, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SMOKE_SIZE_Z, (Object)Float.valueOf(0.0f));
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    protected void method_5652(class_2487 tag) {
        tag.method_10569("Duration", this.duration);
        tag.method_10569("Age", this.age);
        tag.method_10566("Size", (class_2520)this.method_5846(new double[]{this.getSizeX(), this.getSizeY(), this.getSizeZ()}));
    }

    protected void method_5749(class_2487 tag) {
        this.duration = tag.method_10550("Duration");
        class_2499 sizeDims = tag.method_10554("Size", 6);
        this.setSizeX((float)sizeDims.method_10611(0));
        this.setSizeY((float)sizeDims.method_10611(1));
        this.setSizeZ((float)sizeDims.method_10611(2));
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setSize(float size) {
        this.field_6011.method_12778(SMOKE_SIZE_X, (Object)Float.valueOf(Math.abs(size)));
        this.field_6011.method_12778(SMOKE_SIZE_Y, (Object)Float.valueOf(Math.abs(size)));
        this.field_6011.method_12778(SMOKE_SIZE_Z, (Object)Float.valueOf(Math.abs(size)));
        this.method_5857(this.method_33332());
    }

    public float getMeanSize() {
        float sizeX = this.getSizeX();
        float sizeY = this.getSizeY();
        float sizeZ = this.getSizeZ();
        return (sizeX + sizeY + sizeZ) / 3.0f;
    }

    public float getVolume() {
        return this.getSizeX() * this.getSizeY() * this.getSizeZ();
    }

    public void setSizeX(float sizeX) {
        this.field_6011.method_12778(SMOKE_SIZE_X, (Object)Float.valueOf(Math.abs(sizeX)));
        this.method_5857(this.method_33332());
    }

    public float getSizeX() {
        return ((Float)this.field_6011.method_12789(SMOKE_SIZE_X)).floatValue();
    }

    public void setSizeY(float sizeY) {
        this.field_6011.method_12778(SMOKE_SIZE_Y, (Object)Float.valueOf(Math.abs(sizeY)));
        this.method_5857(this.method_33332());
    }

    public float getSizeY() {
        return ((Float)this.field_6011.method_12789(SMOKE_SIZE_Y)).floatValue();
    }

    public void setSizeZ(float sizeZ) {
        this.field_6011.method_12778(SMOKE_SIZE_Z, (Object)Float.valueOf(Math.abs(sizeZ)));
        this.method_5857(this.method_33332());
    }

    public float getSizeZ() {
        return ((Float)this.field_6011.method_12789(SMOKE_SIZE_Z)).floatValue();
    }

    public void method_5773() {
        boolean doStuff = this.canDoStuff();
        if (this.field_6002.field_9236) {
            if (doStuff) {
                double sizeX = this.getSizeX();
                double sizeY = this.getSizeY();
                double sizeZ = this.getSizeZ();
                double count = Math.ceil(this.getMeanSize());
                class_2394 particle = this.getParticle();
                double baseX = this.method_23317();
                double baseY = this.method_23318();
                double baseZ = this.method_23321();
                int i = 0;
                while ((double)i < count) {
                    double rx = this.field_5974.nextDouble() * sizeX - sizeX * 0.5 + baseX;
                    double ry = this.field_5974.nextDouble() * sizeY - sizeY * 0.5 + baseY;
                    double rz = this.field_5974.nextDouble() * sizeZ - sizeZ * 0.5 + baseZ;
                    double dx = this.field_5974.nextGaussian() * 0.05;
                    double dy = this.field_5974.nextGaussian() * 0.02;
                    double dz = this.field_5974.nextGaussian() * 0.05;
                    this.field_6002.method_8466(particle, true, rx, ry, rz, dx, dy, dz);
                    ++i;
                }
            }
        } else {
            if (doStuff) {
                double sizeX = this.getSizeX();
                double sizeY = this.getSizeY();
                double sizeZ = this.getSizeZ();
                class_238 bounding = this.method_5829();
                class_238 queryBounding = bounding.method_1014(8.0);
                for (SmokeEmitterEntity other : this.field_6002.method_8390(SmokeEmitterEntity.class, queryBounding, this::canMergeWithOther)) {
                    double otherSizeX = other.getSizeX();
                    double otherSizeY = other.getSizeY();
                    double otherSizeZ = other.getSizeZ();
                    class_243 disp = other.method_19538().method_1020(this.method_19538());
                    class_243 totalDims = new class_243(sizeX + otherSizeX, sizeY + otherSizeY, sizeZ + otherSizeZ);
                    class_243 maxSpacing = totalDims.method_1021(0.55);
                    if (Math.abs(disp.field_1352) > maxSpacing.field_1352 || Math.abs(disp.field_1351) > maxSpacing.field_1351 || Math.abs(disp.field_1350) > maxSpacing.field_1350) continue;
                    class_238 otherBounding = other.method_5829();
                    bounding = new class_238(Math.min(bounding.field_1323, otherBounding.field_1323), Math.min(bounding.field_1322, otherBounding.field_1322), Math.min(bounding.field_1321, otherBounding.field_1321), Math.max(bounding.field_1320, otherBounding.field_1320), Math.max(bounding.field_1325, otherBounding.field_1325), Math.max(bounding.field_1324, otherBounding.field_1324));
                    this.mergeWith(other);
                    other.method_31472();
                }
                this.setSizeX((float)bounding.method_17939());
                this.setSizeY((float)bounding.method_17940());
                this.setSizeZ((float)bounding.method_17941());
                this.method_33574(bounding.method_1005());
            }
            ++this.age;
            if (this.age >= this.getLifetime()) {
                this.method_31472();
                return;
            }
            class_1937 class_19372 = this.field_6002;
            if (class_19372 instanceof class_3218) {
                class_3218 slevel = (class_3218)class_19372;
                if (!this.method_31481() && this.canChunkLoad()) {
                    class_1923 cpos = new class_1923(this.method_24515());
                    RitchiesProjectileLib.queueForceLoad((class_3218)slevel, (int)cpos.field_9181, (int)cpos.field_9180);
                }
            }
        }
        super.method_5773();
    }

    protected boolean canDoStuff() {
        return this.field_5953 || (this.field_6002.method_8510() + (long)this.method_5628()) % 5L == 0L;
    }

    protected int getLifetime() {
        return this.duration;
    }

    protected boolean canChunkLoad() {
        return (Boolean)CBCConfigs.SERVER.munitions.smokeCloudsCanChunkload.get();
    }

    public boolean canMergeWithOther(SmokeEmitterEntity other) {
        return this != other && other.method_5864() == this.method_5864();
    }

    public void mergeWith(SmokeEmitterEntity other) {
        this.duration = class_3532.method_15384((double)((double)(this.duration + other.duration) / 2.0)) + 10;
        this.age = Math.max(class_3532.method_15384((double)((double)(this.age + other.age) / 2.0)) - 10, 0);
    }

    protected class_238 method_33332() {
        double sizeX = (double)this.getSizeX() * 0.5;
        double sizeY = (double)this.getSizeY() * 0.5;
        double sizeZ = (double)this.getSizeZ() * 0.5;
        return new class_238(this.method_23317() + sizeX, this.method_23318() + sizeY, this.method_23321() + sizeZ, this.method_23317() - sizeX, this.method_23318() - sizeY, this.method_23321() - sizeZ);
    }

    protected class_2394 getParticle() {
        return new SmokeShellSmokeParticleData(4.0f);
    }

    public boolean method_5863() {
        return false;
    }
}

