/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.EndFluidStack;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobEffectRegistry;
import rbasamoyai.createbigcannons.munitions.big_cannon.fluid_shell.FluidBlobParticleData;
import rbasamoyai.createbigcannons.munitions.fragment_burst.CBCProjectileBurst;
import rbasamoyai.createbigcannons.network.ClientboundFluidBlobStackSyncPacket;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurst;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurstClipContext;

public class FluidBlobBurst
extends CBCProjectileBurst {
    private static final class_2940<Byte> BLOB_SIZE = class_2945.method_12791(FluidBlobBurst.class, (class_2941)class_2943.field_13319);
    private EndFluidStack fluidStack = EndFluidStack.EMPTY;
    private final Set<class_1297> clippedThisTick = new HashSet<class_1297>();

    public FluidBlobBurst(class_1299<? extends FluidBlobBurst> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static float getBlockAffectChance() {
        return CBCConfigs.SERVER.munitions.fluidBlobBlockAffectChance.getF();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BLOB_SIZE, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("Size", this.getBlobSize());
        tag.method_10566("Fluid", (class_2520)this.getFluidStack().writeTag(new class_2487()));
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setBlobSize(tag.method_10571("Size"));
        this.setFluidStack(EndFluidStack.readTag(tag.method_10562("Fluid")));
    }

    protected void setBlobSize(byte size) {
        this.field_6011.method_12778(BLOB_SIZE, (Object)(size < 0 ? (byte)0 : size));
    }

    public byte getBlobSize() {
        return (Byte)this.field_6011.method_12789(BLOB_SIZE);
    }

    public void setFluidStack(EndFluidStack fstack) {
        this.fluidStack = fstack;
    }

    public EndFluidStack getFluidStack() {
        return this.fluidStack;
    }

    public double getSubProjectileWidth() {
        return 0.8;
    }

    public double getSubProjectileHeight() {
        return 0.8;
    }

    @Override
    public void method_5773() {
        this.clippedThisTick.clear();
        super.method_5773();
        if (!this.field_6002.field_9236 && this.field_6002.method_8510() % 3L == 0L) {
            NetworkPlatform.sendToClientTracking(new ClientboundFluidBlobStackSyncPacket(this), (class_1297)this);
        }
        if (this.field_6002.field_9236 && !this.getFluidStack().isEmpty()) {
            for (ProjectileBurst.SubProjectile subProjectile : this.subProjectiles) {
                double[] disp = subProjectile.displacement();
                double[] vel = subProjectile.velocity();
                this.field_6002.method_8406((class_2394)new FluidBlobParticleData((float)this.getBlobSize() * 0.25f + 1.0f, this.getFluidStack().copy()), this.method_23317() + disp[0], this.method_23318() + disp[1], this.method_23321() + disp[2], vel[0], vel[1], vel[2]);
            }
        }
    }

    protected class_239 clipAndDamage(ProjectileBurst.SubProjectile info) {
        class_243 vel = new class_243(info.velocity()[0], info.velocity()[1], info.velocity()[2]);
        class_243 start = new class_243(info.displacement()[0] + this.method_23317(), info.displacement()[1] + this.method_23318(), info.displacement()[2] + this.method_23321());
        class_243 end = start.method_1019(vel);
        double halfHeight = this.getSubProjectileHeight() / 2.0;
        double halfWidth = this.getSubProjectileWidth() / 2.0;
        class_3965 hitResult = this.field_6002.method_17742((class_3959)new ProjectileBurstClipContext(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this, start.field_1351 - halfHeight));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            end = hitResult.method_17784();
        }
        class_238 aabb = new class_238(start.field_1352 - halfWidth, start.field_1351 - halfHeight, start.field_1350 - halfWidth, start.field_1352 + halfWidth, start.field_1351 + halfHeight, start.field_1350 + halfWidth).method_1014((double)this.getBlobSize());
        this.clipEntities(start, end, aabb.method_18804(vel).method_1014(1.0), info);
        return hitResult;
    }

    private void clipEntities(class_243 startVec, class_243 endVec, class_238 boundingBox, ProjectileBurst.SubProjectile subProjectile) {
        float inflate = (float)this.getBlobSize() + 0.3f;
        for (class_1297 entity : this.field_6002.method_8333((class_1297)this, boundingBox, this::method_26958)) {
            class_238 entityBB = entity.method_5829().method_1014((double)inflate);
            Optional optional = entityBB.method_992(startVec, endVec);
            if (!optional.isPresent()) continue;
            this.onSubProjectileHitEntity(new class_3966(entity), subProjectile);
        }
    }

    @Override
    public boolean method_26958(class_1297 target) {
        return !this.clippedThisTick.contains(target) && super.method_26958(target);
    }

    protected void onSubProjectileHit(class_239 result, ProjectileBurst.SubProjectile subProjectile) {
        if (!this.field_6002.field_9236) {
            FluidBlobEffectRegistry.effectOnAllHit(this, subProjectile, result);
        }
        super.onSubProjectileHit(result, subProjectile);
    }

    protected void onSubProjectileHitBlock(class_3965 result, ProjectileBurst.SubProjectile subProjectile) {
        if (!this.field_6002.field_9236) {
            FluidBlobEffectRegistry.effectOnHitBlock(this, subProjectile, result);
        }
        super.onSubProjectileHitBlock(result, subProjectile);
    }

    protected void onSubProjectileHitEntity(class_3966 result, ProjectileBurst.SubProjectile subProjectile) {
        this.clippedThisTick.add(result.method_17782());
        if (!this.field_6002.field_9236) {
            FluidBlobEffectRegistry.effectOnHitEntity(this, subProjectile, result);
        }
        super.onSubProjectileHitEntity(result, subProjectile);
    }

    public class_238 getAreaOfEffect(class_2338 pos) {
        return new class_238(pos).method_1014((double)this.getBlobSize());
    }
}

