/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions.autocannon;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import rbasamoyai.createbigcannons.CreateBigCannons;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesHandler;
import rbasamoyai.createbigcannons.block_armor_properties.BlockArmorPropertiesProvider;
import rbasamoyai.createbigcannons.config.CBCCfgMunitions;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.smoke.TrailSmokeParticleData;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.munitions.AbstractCannonProjectile;
import rbasamoyai.createbigcannons.munitions.ProjectileContext;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.config.components.BallisticPropertiesComponent;
import rbasamoyai.createbigcannons.network.ClientboundPlayBlockHitEffectPacket;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class AbstractAutocannonProjectile
extends AbstractCannonProjectile {
    protected double displacement = 0.0;
    protected int ageRemaining;
    protected final Map<class_1657, Integer> whooshedPlayers = new HashMap<class_1657, Integer>();

    protected AbstractAutocannonProjectile(class_1299<? extends AbstractAutocannonProjectile> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void onTickRotate() {
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        if (!this.isInGround()) {
            class_243 vel = this.method_18798();
            if (vel.method_1027() > 0.005) {
                this.method_36456((float)(class_3532.method_15349((double)vel.field_1352, (double)vel.field_1350) * 57.2957763671875));
                this.method_36457((float)(class_3532.method_15349((double)vel.field_1351, (double)vel.method_37267()) * 57.2957763671875));
            }
            this.method_36456(this.method_36454());
            this.method_36457(this.method_36455());
        }
    }

    @Override
    public void method_5773() {
        class_243 prevPos = this.method_19538();
        class_1923 cpos = new class_1923(this.method_24515());
        class_243 nextVelocity = this.nextVelocity;
        if (this.field_6002.field_9236 || this.field_6002.method_8393(cpos.field_9181, cpos.field_9180)) {
            super.method_5773();
            this.displacement += this.method_19538().method_1022(prevPos);
            if (!this.field_6002.field_9236) {
                --this.ageRemaining;
                if (this.ageRemaining <= 0) {
                    this.expireProjectile();
                }
            }
            if (!this.isInGround()) {
                TrailType trailType = (TrailType)((Object)CBCConfigs.SERVER.munitions.autocannonTrailType.get());
                if (trailType != TrailType.NONE) {
                    int lifetime = trailType == TrailType.SHORT ? 50 : 100 + this.field_6002.field_9229.nextInt(50);
                    TrailSmokeParticleData options = new TrailSmokeParticleData(lifetime);
                    for (int i = 0; i < 10; ++i) {
                        double partial = (float)i * 0.1f;
                        double dx = class_3532.method_16436((double)partial, (double)this.field_6038, (double)this.method_23317());
                        double dy = class_3532.method_16436((double)partial, (double)this.field_5971, (double)this.method_23318());
                        double dz = class_3532.method_16436((double)partial, (double)this.field_5989, (double)this.method_23321());
                        double sx = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                        double sy = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                        double sz = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                        this.field_6002.method_17452((class_2394)options, true, dx, dy, dz, sx, sy, sz);
                    }
                    if (nextVelocity != null) {
                        TrailSmokeParticleData options1 = new TrailSmokeParticleData(lifetime - 1);
                        class_243 nextPos = this.method_19538().method_1019(nextVelocity);
                        for (int i = 0; i < 20; ++i) {
                            double partial = (float)i * 0.1f;
                            double dx = class_3532.method_16436((double)partial, (double)this.method_23317(), (double)nextPos.field_1352);
                            double dy = class_3532.method_16436((double)partial, (double)this.method_23318(), (double)nextPos.field_1351);
                            double dz = class_3532.method_16436((double)partial, (double)this.method_23321(), (double)nextPos.field_1350);
                            double sx = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                            double sy = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                            double sz = this.field_6002.field_9229.nextDouble(-0.002, 0.002);
                            this.field_6002.method_17452((class_2394)options1, true, dx, dy, dz, sx, sy, sz);
                        }
                    }
                }
                if (this.field_6002.field_9236 && ((Boolean)CBCConfigs.CLIENT.enableAutocannonFlybySounds.get()).booleanValue()) {
                    Iterator<Map.Entry<class_1657, Integer>> iter = this.whooshedPlayers.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<class_1657, Integer> entry = iter.next();
                        if (entry.getKey().method_31481() || !entry.getKey().method_5805()) {
                            iter.remove();
                            continue;
                        }
                        int v = entry.getValue();
                        if (v <= 0) {
                            iter.remove();
                            continue;
                        }
                        entry.setValue(v - 1);
                    }
                    class_3414 soundEvent = this.getAutocannonRoundType() == AutocannonAmmoType.MACHINE_GUN ? CBCSoundEvents.MACHINE_GUN_ROUND_FLYBY.getMainEvent() : CBCSoundEvents.AUTOCANNON_ROUND_FLYBY.getMainEvent();
                    class_243 curPos = this.method_19538();
                    class_243 displacementVec = curPos.method_1020(prevPos);
                    class_238 path = this.method_5829().method_18804(displacementVec.method_22882()).method_1014(3.0);
                    for (class_1657 player : this.field_6002.method_18464(class_4051.method_36626(), null, path)) {
                        class_243 diff = player.method_19538().method_1020(prevPos);
                        boolean flag = this.whooshedPlayers.containsKey(player);
                        this.whooshedPlayers.put(player, 3);
                        if (flag) continue;
                        float volume = displacementVec.method_1026(diff) < 0.0 ? 0.25f : 1.0f;
                        float pitch = 0.95f + this.field_5974.nextFloat() * 0.2f;
                        this.field_6002.method_8465(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, class_3419.field_15254, volume, pitch);
                    }
                }
            }
        }
    }

    protected void expireProjectile() {
        this.method_31472();
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.whooshedPlayers.clear();
    }

    public void setTracer(boolean tracer) {
        if (tracer) {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) | 2)));
        } else {
            this.field_6011.method_12778(ID_FLAGS, (Object)((byte)((Byte)this.field_6011.method_12789(ID_FLAGS) & 0xFD)));
        }
    }

    public void setLifetime(int lifetime) {
        this.ageRemaining = lifetime;
    }

    @Override
    protected AbstractCannonProjectile.ImpactResult calculateBlockPenetration(ProjectileContext projectileContext, class_2680 state, class_3965 blockHitResult) {
        boolean shatter;
        class_2338 pos = blockHitResult.method_17777();
        class_243 hitLoc = blockHitResult.method_17784();
        BallisticPropertiesComponent ballistics = this.getBallisticProperties();
        BlockArmorPropertiesProvider blockArmor = BlockArmorPropertiesHandler.getProperties(state);
        boolean unbreakable = projectileContext.griefState() == CBCCfgMunitions.GriefState.NO_DAMAGE || state.method_26214((class_1922)this.field_6002, pos) == -1.0f;
        class_243 accel = this.getForces(this.method_19538(), this.method_18798());
        class_243 curVel = this.method_18798().method_1019(accel);
        class_243 normal = CBCUtils.getSurfaceNormalVector(this.field_6002, blockHitResult);
        double incidence = Math.max(0.0, curVel.method_1029().method_1026(normal.method_22882()));
        double velMag = curVel.method_1033();
        double mass = this.getProjectileMass();
        double bonusMomentum = 1.0 + Math.max(0.0, (velMag - (double)CBCConfigs.SERVER.munitions.minVelocityForPenetrationBonus.getF()) * (double)CBCConfigs.SERVER.munitions.penetrationBonusScale.getF());
        double momentum = mass * velMag * incidence * bonusMomentum;
        double hardnessPenalty = Math.max(blockArmor.hardness(this.field_6002, state, pos, true) - (double)ballistics.penetration(), 0.0);
        double projectileDeflection = ballistics.deflection();
        double baseChance = CBCConfigs.SERVER.munitions.baseProjectileBounceChance.getF();
        double bounceChance = projectileDeflection < 0.01 || incidence > projectileDeflection ? 0.0 : Math.max(baseChance, 1.0 - incidence / projectileDeflection);
        boolean surfaceImpact = this.lastPenetratedBlock.method_26215();
        boolean canBounce = (Boolean)CBCConfigs.SERVER.munitions.projectilesCanBounce.get();
        AbstractCannonProjectile.ImpactResult.KinematicOutcome outcome = surfaceImpact && canBounce && this.field_6002.method_8409().nextDouble() < bounceChance ? AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE : AbstractCannonProjectile.ImpactResult.KinematicOutcome.STOP;
        boolean bl = shatter = surfaceImpact && outcome != AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE && hardnessPenalty > (double)ballistics.toughness();
        if (!this.field_6002.field_9236) {
            class_243 effectNormal;
            boolean bounced;
            boolean bl2 = bounced = outcome == AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE;
            if (bounced) {
                double elasticity = 1.7f;
                effectNormal = curVel.method_1020(normal.method_1021(normal.method_1026(curVel) * elasticity));
            } else {
                effectNormal = curVel.method_22882();
            }
            for (class_2680 state1 : blockArmor.containedBlockStates(this.field_6002, state, pos.method_10062(), true)) {
                projectileContext.addPlayedEffect(new ClientboundPlayBlockHitEffectPacket(state1, this.method_5864(), bounced, true, hitLoc.field_1352, hitLoc.field_1351, hitLoc.field_1350, (float)effectNormal.field_1352, (float)effectNormal.field_1351, (float)effectNormal.field_1350));
            }
            if (hardnessPenalty > 0.01) {
                momentum = (double)ballistics.toughness() < 0.01 ? 0.0 : (momentum *= Math.max(0.25, 1.0 - hardnessPenalty / (double)ballistics.toughness()));
            }
            if (!unbreakable) {
                CreateBigCannons.BLOCK_DAMAGE.damageBlock(pos.method_10062(), Math.max(class_3532.method_15384((double)momentum), 0), state, this.field_6002);
            }
        }
        this.onImpact((class_239)blockHitResult, new AbstractCannonProjectile.ImpactResult(outcome, shatter), projectileContext);
        return new AbstractCannonProjectile.ImpactResult(outcome, !this.field_6002.field_9236 && (shatter || outcome != AbstractCannonProjectile.ImpactResult.KinematicOutcome.BOUNCE));
    }

    protected boolean onImpact(class_239 hitResult, AbstractCannonProjectile.ImpactResult impactResult, ProjectileContext projectileContext) {
        return false;
    }

    public boolean isTracer() {
        return ((Byte)this.field_6011.method_12789(ID_FLAGS) & 2) != 0;
    }

    public double getTotalDisplacement() {
        return this.displacement;
    }

    public void setTotalDisplacement(double value) {
        this.displacement = value;
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10556("Tracer", this.isTracer());
        tag.method_10569("Age", this.ageRemaining);
        tag.method_10549("Displacement", this.displacement);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setTracer(tag.method_10577("Tracer"));
        this.ageRemaining = tag.method_10550("Age");
        this.displacement = tag.method_10583("Displacement");
    }

    @Override
    public class_2487 addExtraSyncData() {
        class_2487 tag = super.addExtraSyncData();
        tag.method_10549("Displacement", this.displacement);
        return tag;
    }

    @Override
    public void readExtraSyncData(class_2487 tag) {
        super.readExtraSyncData(tag);
        this.displacement = tag.method_10574("Displacement");
    }

    public AutocannonAmmoType getAutocannonRoundType() {
        return AutocannonAmmoType.AUTOCANNON;
    }

    public static enum TrailType {
        NONE,
        LONG,
        SHORT;

    }
}

