/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import rbasamoyai.createbigcannons.block_hit_effects.BlockImpactTransformationHandler;
import rbasamoyai.createbigcannons.config.CBCConfigs;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellBlastWaveEffectParticleData;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellExplosionCloudParticleData;
import rbasamoyai.createbigcannons.index.CBCSoundEvents;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.ClientboundCBCExplodePacket;
import rbasamoyai.createbigcannons.remix.CustomExplosion;

public class ShellExplosion
extends CustomExplosion.Impl {
    private final Set<class_2338> changedBlocks = new HashSet<class_2338>();
    private final boolean isPlume;
    private final boolean noEffects;

    public ShellExplosion(class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, class_1927.class_4179 interaction, boolean noEffects) {
        super(level, source, damageSource, null, toBlowX, toBlowY, toBlowZ, radius, fire, interaction);
        class_2338 pos = new class_2338(this.x, this.y, this.z);
        this.isPlume = this.level.method_8320(pos.method_10084()).method_26215() && !this.level.method_8320(pos.method_10074()).method_26215();
        this.noEffects = noEffects;
    }

    public ShellExplosion(class_1937 level, @Nullable class_1297 source, @Nullable class_1282 damageSource, double toBlowX, double toBlowY, double toBlowZ, float radius, boolean fire, class_1927.class_4179 interaction) {
        this(level, source, damageSource, toBlowX, toBlowY, toBlowZ, radius, fire, interaction, false);
    }

    public ShellExplosion(class_1937 level, ClientboundCBCExplodePacket packet) {
        super(level, packet);
        class_2338 pos = new class_2338(this.x, this.y, this.z);
        this.isPlume = this.level.method_8320(pos.method_10084()).method_26215() && !this.level.method_8320(pos.method_10074()).method_26215();
        this.noEffects = packet.explosionType() == ClientboundCBCExplodePacket.ExplosionType.SHELL_NO_EFFECTS;
    }

    @Override
    protected void spawnParticles() {
        if (this.noEffects) {
            return;
        }
        ShellBlastWaveEffectParticleData blastWave = new ShellBlastWaveEffectParticleData(this.size * 12.0f, CBCSoundEvents.SHELL_EXPLOSION.getMainEvent(), class_3419.field_15245, Math.max(this.size * 2.0f, 16.0f), 0.8f + this.level.field_9229.nextFloat() * 0.4f, 2.0f, this.size);
        ShellExplosionCloudParticleData explosionCloud = new ShellExplosionCloudParticleData(this.size, this.isPlume);
        this.level.method_8466((class_2394)blastWave, true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        this.level.method_8466((class_2394)explosionCloud, true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
    }

    @Override
    public void editBlock(class_1937 level, class_2338 pos, class_2680 blockState, class_3610 fluidState, float power) {
        if (this.noEffects || !((Boolean)CBCConfigs.SERVER.munitions.projectilesChangeSurroundings.get()).booleanValue() || this.changedBlocks.contains(pos)) {
            return;
        }
        class_2680 transformed = BlockImpactTransformationHandler.transformBlock(blockState);
        level.method_8652(pos, transformed, 11);
        this.changedBlocks.add(pos);
    }

    @Override
    public void sendExplosionToClient(class_3222 player) {
        double distSqr = player.method_5649(this.x, this.y, this.z);
        if (distSqr < 263000.0) {
            class_243 knockback = this.method_8351().getOrDefault(player, class_243.field_1353);
            ClientboundCBCExplodePacket.ExplosionType type = this.noEffects ? ClientboundCBCExplodePacket.ExplosionType.SHELL_NO_EFFECTS : ClientboundCBCExplodePacket.ExplosionType.SHELL;
            NetworkPlatform.sendToClientPlayer(new ClientboundCBCExplodePacket(this.x, this.y, this.z, this.size, this.method_8346(), (float)knockback.field_1352, (float)knockback.field_1351, (float)knockback.field_1350, type), player);
        }
    }
}

