/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.munitions;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import rbasamoyai.createbigcannons.effects.particles.smoke.GasCloudParticleData;
import rbasamoyai.createbigcannons.equipment.gas_mask.GasMaskItem;
import rbasamoyai.createbigcannons.munitions.big_cannon.smoke_shell.SmokeEmitterEntity;

public class GasCloudEntity
extends SmokeEmitterEntity {
    private static final class_2940<Integer> DATA_COLOR = class_2945.method_12791(GasCloudEntity.class, (class_2941)class_2943.field_13327);
    private int waitTime;
    private class_1842 potion = class_1847.field_8984;
    private final List<class_1293> effects = new ArrayList<class_1293>();
    private final Map<class_1297, Integer> victims = Maps.newHashMap();
    private boolean fixedColor;
    private int reapplicationDelay = 20;

    public GasCloudEntity(class_1299<? extends GasCloudEntity> type, class_1937 level) {
        super(type, level);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_COLOR, (Object)0);
    }

    public void setPotion(class_1842 potion) {
        this.potion = potion;
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    private void updateColor() {
        if (this.potion == class_1847.field_8984 && this.effects.isEmpty()) {
            this.method_5841().method_12778(DATA_COLOR, (Object)0);
        } else {
            this.method_5841().method_12778(DATA_COLOR, (Object)class_1844.method_8055((Collection)class_1844.method_8059((class_1842)this.potion, this.effects)));
        }
    }

    public void addEffect(class_1293 effectInstance) {
        this.effects.add(effectInstance);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return (Integer)this.method_5841().method_12789(DATA_COLOR);
    }

    public void setFixedColor(int color) {
        this.fixedColor = true;
        this.method_5841().method_12778(DATA_COLOR, (Object)color);
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236 && this.age >= this.waitTime && this.canDoStuff()) {
            this.victims.entrySet().removeIf(entry -> this.field_6012 >= (Integer)entry.getValue());
            ArrayList<class_1293> toApply = new ArrayList<class_1293>();
            for (class_1293 potionEffect : this.potion.method_8049()) {
                toApply.add(new class_1293(potionEffect.method_5579(), potionEffect.method_5584() / 4, potionEffect.method_5578(), potionEffect.method_5591(), potionEffect.method_5581()));
            }
            toApply.addAll(this.effects);
            if (toApply.isEmpty()) {
                this.victims.clear();
            } else {
                for (class_1309 target : this.field_6002.method_18467(class_1309.class, this.method_5829())) {
                    if (this.victims.containsKey(target) || !target.method_6086() || this.isBlockedBy(target)) continue;
                    this.victims.put((class_1297)target, this.field_6012 + this.reapplicationDelay);
                    for (class_1293 appliedEffect : toApply) {
                        if (appliedEffect.method_5579().method_5561()) {
                            appliedEffect.method_5579().method_5564((class_1297)this, null, target, appliedEffect.method_5578(), 0.5);
                            continue;
                        }
                        target.method_37222(new class_1293(appliedEffect), (class_1297)this);
                    }
                }
            }
        }
    }

    @Override
    public boolean canMergeWithOther(SmokeEmitterEntity other) {
        if (!super.canMergeWithOther(other) || !(other instanceof GasCloudEntity)) {
            return false;
        }
        GasCloudEntity otherGas = (GasCloudEntity)other;
        return this.potion == otherGas.potion || this.potion == null || otherGas.potion == null;
    }

    @Override
    public void mergeWith(SmokeEmitterEntity other) {
        if (!(other instanceof GasCloudEntity)) {
            return;
        }
        GasCloudEntity otherGas = (GasCloudEntity)other;
        boolean flag = this.age >= this.waitTime || otherGas.age >= otherGas.waitTime;
        super.mergeWith(other);
        if (flag) {
            this.age = Math.max(this.age, Math.min(this.waitTime, otherGas.waitTime));
        }
        if (this.potion != otherGas.potion && this.potion == null) {
            this.potion = otherGas.potion;
        }
        this.effects.addAll(otherGas.effects);
    }

    @Override
    protected void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("WaitTime", this.waitTime);
        tag.method_10569("ReapplicationDelay", this.reapplicationDelay);
        if (this.fixedColor) {
            tag.method_10569("Color", this.getColor());
        }
        if (this.potion != class_1847.field_8984) {
            tag.method_10582("Potion", class_2378.field_11143.method_10221((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            class_2499 listTag = new class_2499();
            for (class_1293 mobEffectInstance : this.effects) {
                listTag.add((Object)mobEffectInstance.method_5582(new class_2487()));
            }
            tag.method_10566("Effects", (class_2520)listTag);
        }
    }

    @Override
    protected void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.waitTime = tag.method_10550("WaitTime");
        this.reapplicationDelay = tag.method_10550("ReapplicationDelay");
        if (tag.method_10573("Color", 99)) {
            this.setFixedColor(tag.method_10550("Color"));
        }
        if (tag.method_10573("Potion", 8)) {
            this.setPotion(class_1844.method_8057((class_2487)tag));
        }
        if (tag.method_10573("Effects", 9)) {
            class_2499 listTag = tag.method_10554("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listTag.size(); ++i) {
                class_1293 mobEffectInstance = class_1293.method_5583((class_2487)listTag.method_10602(i));
                if (mobEffectInstance == null) continue;
                this.addEffect(mobEffectInstance);
            }
        }
    }

    @Override
    protected class_2394 getParticle() {
        int packed = this.getColor();
        float r = (float)(packed >> 16 & 0xFF) / 255.0f;
        float g = (float)(packed >> 8 & 0xFF) / 255.0f;
        float b = (float)(packed & 0xFF) / 255.0f;
        return new GasCloudParticleData(2.0f, r, g, b);
    }

    @Override
    protected int getLifetime() {
        return super.getLifetime() + this.waitTime;
    }

    public boolean isBlockedBy(class_1309 target) {
        return GasMaskItem.isWearingWorkingMask(target);
    }
}

