/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.index.fluid_utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import rbasamoyai.createbigcannons.base.LazySupplier;
import rbasamoyai.createbigcannons.index.fluid_utils.CBCFlowingFluid;
import rbasamoyai.createbigcannons.multiloader.IndexPlatform;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public abstract class FluidBuilder<T extends CBCFlowingFluid, P>
extends AbstractBuilder<class_3611, T, P, FluidBuilder<T, P>> {
    protected final class_2960 stillTexture;
    protected final class_2960 flowingTexture;
    public final String sourceName;
    protected final String bucketName;
    protected final NonNullFunction<CBCFlowingFluid.Properties, T> factory;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<CBCFlowingFluid.Properties> properties;
    @Nullable
    private NonNullSupplier<? extends CBCFlowingFluid> source;
    protected List<class_6862<class_3611>> tags = new ArrayList<class_6862<class_3611>>();

    public static <P> FluidBuilder<CBCFlowingFluid.Flowing, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture) {
        return FluidBuilder.create(owner, parent, name, callback, stillTexture, flowingTexture, CBCFlowingFluid.Flowing::new);
    }

    public static <T extends CBCFlowingFluid, P> FluidBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<CBCFlowingFluid.Properties, T> factory) {
        FluidBuilder<T, P> ret = IndexPlatform.createFluidBuilder(owner, parent, name, callback, stillTexture, flowingTexture, factory).defaultLang().defaultSource().defaultBlock().defaultBucket();
        return ret;
    }

    protected FluidBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, class_2960 stillTexture, class_2960 flowingTexture, NonNullFunction<CBCFlowingFluid.Properties, T> factory) {
        super(owner, parent, "flowing_" + name, callback, CBCRegistryUtils.getFluidRegistryKey());
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.factory = factory;
        String bucketName = this.bucketName;
        this.properties = p -> p.bucket(() -> (class_1792)owner.get(bucketName, CBCRegistryUtils.getItemRegistryKey()).get()).block(() -> (class_2404)owner.get(name, CBCRegistryUtils.getBlockRegistryKey()).get());
    }

    public FluidBuilder<T, P> properties(NonNullConsumer<CBCFlowingFluid.Properties> cons) {
        this.properties = this.properties.andThen(cons);
        return this;
    }

    public abstract FluidBuilder<T, P> defaultLang();

    public abstract FluidBuilder<T, P> lang(String var1);

    public FluidBuilder<T, P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public FluidBuilder<T, P> source(NonNullFunction<CBCFlowingFluid.Properties, ? extends CBCFlowingFluid> factory) {
        this.defaultSource = false;
        this.source = new LazySupplier<CBCFlowingFluid>(() -> (CBCFlowingFluid)((Object)((Object)factory.apply((Object)this.makeProperties()))));
        return this;
    }

    public FluidBuilder<T, P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public abstract BlockBuilder<class_2404, FluidBuilder<T, P>> block();

    public <B extends class_2404> BlockBuilder<B, FluidBuilder<T, P>> block(NonNullBiFunction<NonNullSupplier<? extends T>, class_4970.class_2251, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        NonNullSupplier supplier = this.asSupplier();
        return this.getOwner().block((Object)this, this.sourceName, p -> (class_2404)factory.apply((Object)supplier, p)).properties(p -> class_4970.class_2251.method_9630((class_4970)class_2246.field_10382).method_16229()).blockstate((ctx, prov) -> prov.simpleBlock((class_2248)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture)));
    }

    @Beta
    public FluidBuilder<T, P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public FluidBuilder<T, P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<class_1755, FluidBuilder<T, P>> bucket() {
        return this.bucket(class_1755::new);
    }

    public <I extends class_1755> ItemBuilder<I, FluidBuilder<T, P>> bucket(NonNullBiFunction<? extends CBCFlowingFluid, class_1792.class_1793, ? extends I> factory) {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        if (source == null) {
            throw new IllegalStateException("Cannot create a bucket before creating a source block");
        }
        return this.getOwner().item((Object)this, this.bucketName, p -> (class_1755)factory.apply((Object)((CBCFlowingFluid)((Object)((Object)this.source.get()))), p)).properties(p -> p.method_7896(class_1802.field_8550).method_7889(1)).model((ctx, prov) -> prov.generated((NonNullSupplier)ctx, new class_2960[]{CBCUtils.location(this.getOwner().getModid(), "item/" + this.bucketName)}));
    }

    @Beta
    public FluidBuilder<T, P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    public abstract FluidBuilder<T, P> tag(class_6862<class_3611> ... var1);

    @SafeVarargs
    public final FluidBuilder<T, P> removeTag(class_6862<class_3611> ... tags) {
        this.tags.removeAll(Arrays.asList(tags));
        return (FluidBuilder)this.removeTag(ProviderType.FLUID_TAGS, tags);
    }

    protected CBCFlowingFluid getSource() {
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return (CBCFlowingFluid)((Object)source.get());
    }

    protected CBCFlowingFluid.Properties makeProperties() {
        NonNullSupplier<? extends CBCFlowingFluid> source = this.source;
        CBCFlowingFluid.Properties ret = new CBCFlowingFluid.Properties((Supplier<? extends class_3611>)source, (Supplier<? extends class_3611>)this.asSupplier(), this.stillTexture, this.flowingTexture);
        this.properties.accept((Object)ret);
        return ret;
    }

    protected T createEntry() {
        return (T)((Object)((CBCFlowingFluid)((Object)this.factory.apply((Object)this.makeProperties()))));
    }

    public RegistryEntry<T> register() {
        NonNullSupplier<? extends CBCFlowingFluid> source;
        if (this.defaultSource == Boolean.TRUE) {
            this.source((NonNullFunction<CBCFlowingFluid.Properties, CBCFlowingFluid>)((NonNullFunction)CBCFlowingFluid.Still::new));
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, class_3611.class, (Builder)this, source);
        return super.register();
    }
}

