/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.fabric.munitions.autocannon;

import io.github.fabricators_of_create.porting_lib.transfer.StorageViewArrayIterator;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import rbasamoyai.createbigcannons.fabric.munitions.autocannon.AutocannonAmmoContainerSlotView;
import rbasamoyai.createbigcannons.munitions.autocannon.AutocannonAmmoType;
import rbasamoyai.createbigcannons.munitions.autocannon.ammo_container.AutocannonAmmoContainerBlockEntity;

public class AutocannonAmmoContainerInterface
extends SnapshotParticipant<ContainerSnapshot>
implements Storage<ItemVariant> {
    private final AutocannonAmmoContainerBlockEntity be;
    private final AutocannonAmmoContainerSlotView[] views;

    public AutocannonAmmoContainerInterface(AutocannonAmmoContainerBlockEntity be) {
        this.be = be;
        this.views = new AutocannonAmmoContainerSlotView[2];
        this.views[0] = new AutocannonAmmoContainerSlotView(this, false);
        this.views[1] = new AutocannonAmmoContainerSlotView(this, true);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        int capacity;
        int capacity2;
        if (maxAmount < 1L || this.be.isCreativeContainer()) {
            return 0L;
        }
        class_1799 stack = resource.toStack();
        AutocannonAmmoType ammoType = this.be.getAmmoType();
        if (!ammoType.isValidMunition(stack)) {
            return 0L;
        }
        long total = 0L;
        this.updateSnapshots(transaction);
        class_1799 mainAmmoStack = this.be.getMainAmmoStack();
        if ((mainAmmoStack.method_7960() || resource.matches(mainAmmoStack)) && (capacity2 = this.be.getMainAmmoCapacity() - Math.max(mainAmmoStack.method_7947(), 0)) > 0) {
            int add = Math.min((int)maxAmount, capacity2);
            this.be.setMainAmmoDirect(ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(mainAmmoStack.method_7947() + add)));
            maxAmount -= (long)add;
            total += (long)add;
        }
        this.updateSnapshots(transaction);
        class_1799 tracerStack = this.be.getTracerStack();
        if (maxAmount > 0L && (tracerStack.method_7960() || resource.matches(tracerStack)) && (capacity = this.be.getTracerAmmoCapacity() - Math.max(tracerStack.method_7947(), 0)) > 0) {
            int add = Math.min((int)maxAmount, capacity);
            this.be.setTracersDirect(ItemHandlerHelper.copyStackWithSize((class_1799)stack, (int)(tracerStack.method_7947() + add)));
            stack.method_7934(add);
            total += (long)add;
        }
        return total;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (maxAmount < 1L) {
            return 0L;
        }
        long total = 0L;
        boolean isCreative = this.be.isCreativeContainer();
        this.updateSnapshots(transaction);
        class_1799 mainStack = this.be.getMainAmmoStack();
        if (resource.matches(mainStack)) {
            if (isCreative) {
                return maxAmount;
            }
            long add = Math.min((long)mainStack.method_7947(), maxAmount);
            if (add > 0L) {
                mainStack.method_7971((int)add);
                if (mainStack.method_7960()) {
                    this.be.setMainAmmoDirect(class_1799.field_8037);
                }
                total += add;
            }
        }
        this.updateSnapshots(transaction);
        class_1799 tracerStack = this.be.getTracerStack();
        if (resource.matches(tracerStack)) {
            if (isCreative) {
                return maxAmount;
            }
            long add = Math.min((long)tracerStack.method_7947(), maxAmount - total);
            if (add > 0L) {
                tracerStack.method_7971((int)add);
                if (tracerStack.method_7960()) {
                    this.be.setTracersDirect(class_1799.field_8037);
                }
                total += add;
            }
        }
        return total;
    }

    @Nonnull
    public class_1799 getStack(boolean isTracers) {
        return isTracers ? this.be.getTracerStack() : this.be.getMainAmmoStack();
    }

    public Iterator<? extends StorageView<ItemVariant>> iterator(TransactionContext transaction) {
        return new StorageViewArrayIterator((StorageView[])this.views);
    }

    protected ContainerSnapshot createSnapshot() {
        return new ContainerSnapshot(this);
    }

    protected void readSnapshot(ContainerSnapshot snapshot) {
        snapshot.apply(this);
    }

    public int getCapacityForSlot(boolean isTracer) {
        return isTracer ? this.be.getTracerAmmoCapacity() : this.be.getMainAmmoCapacity();
    }

    public void restoreViewSnapshot(boolean isTracer, class_1799 snapshot) {
        if (isTracer) {
            this.be.setTracersDirect(snapshot);
        } else {
            this.be.setMainAmmoDirect(snapshot);
        }
    }

    public static class ContainerSnapshot {
        private final class_1799 ammo;
        private final class_1799 tracers;

        public ContainerSnapshot(AutocannonAmmoContainerInterface inventory) {
            this.ammo = inventory.be.getMainAmmoStack().method_7972();
            this.tracers = inventory.be.getTracerStack().method_7972();
        }

        public void apply(AutocannonAmmoContainerInterface inventory) {
            inventory.be.setMainAmmoDirect(this.ammo);
            inventory.be.setTracersDirect(this.tracers);
        }
    }
}

